/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.TypedObject;

public class RRset
implements TypedObject {
    private List rrs = new ArrayList(1);
    private List sigs = null;
    private int start = 0;
    private byte securityStatus = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRR(Record r) {
        if (r.getType() != 24) {
            List list = this.rrs;
            synchronized (list) {
                if (!this.rrs.contains(r)) {
                    this.rrs.add(r);
                }
                this.start = 0;
            }
        } else {
            if (this.sigs == null) {
                this.sigs = new ArrayList();
            }
            if (!this.sigs.contains(r)) {
                this.sigs.add(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRR(Record r) {
        if (r.getType() != 24) {
            List list = this.rrs;
            synchronized (list) {
                this.rrs.remove(r);
                this.start = 0;
            }
        } else if (this.sigs != null) {
            this.sigs.remove(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this.rrs;
        synchronized (list) {
            this.rrs.clear();
            this.start = 0;
        }
        this.sigs = null;
    }

    public synchronized Iterator rrs() {
        int size = this.rrs.size();
        if (size == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (this.start == size) {
            this.start = 0;
        }
        if (this.start++ == 0) {
            return this.rrs.iterator();
        }
        ArrayList list = new ArrayList(this.rrs.subList(this.start - 1, size));
        list.addAll(this.rrs.subList(0, this.start - 1));
        return list.iterator();
    }

    public Iterator sigs() {
        if (this.sigs == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.sigs.iterator();
    }

    public int size() {
        return this.rrs.size();
    }

    public Name getName() {
        Record r = this.first();
        if (r == null) {
            return null;
        }
        return r.getName();
    }

    public int getType() {
        Record r = this.first();
        if (r == null) {
            return 0;
        }
        return r.getType();
    }

    public int getDClass() {
        Record r = this.first();
        if (r == null) {
            return 0;
        }
        return r.getDClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTTL() {
        List list = this.rrs;
        synchronized (list) {
            if (this.rrs.size() == 0) {
                return 0;
            }
            int ttl = Integer.MAX_VALUE;
            Iterator it = this.rrs.iterator();
            while (it.hasNext()) {
                Record r = (Record)it.next();
                if (r.getTTL() >= ttl) continue;
                ttl = r.getTTL();
            }
            return ttl;
        }
    }

    public Record first() {
        try {
            return (Record)this.rrs.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    void setSecurity(byte status) {
        this.securityStatus = status;
    }

    public byte getSecurity() {
        return this.securityStatus;
    }

    private String iteratorToString(Iterator it) {
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            Record rr = (Record)it.next();
            sb.append("[");
            sb.append(rr.rdataToString());
            sb.append("]");
            if (!it.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String toString() {
        if (this.rrs == null) {
            return "{empty}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{ ");
        sb.append(this.getName() + " ");
        sb.append(this.getTTL() + " ");
        sb.append(DClass.string(this.getDClass()) + " ");
        sb.append(Type.string(this.getType()) + " ");
        sb.append(this.iteratorToString(this.rrs.iterator()));
        if (this.sigs != null) {
            sb.append(" sigs: ");
            sb.append(this.iteratorToString(this.sigs.iterator()));
        }
        sb.append(" }");
        return sb.toString();
    }
}

