/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

public final class ReverseMap {
    private static Name inaddr = Name.fromConstantString("in-addr.arpa.");

    private ReverseMap() {
    }

    public static Name fromAddress(int[] addr) {
        if (addr.length != 4) {
            throw new IllegalArgumentException("array must contain 4 elements");
        }
        StringBuffer sb = new StringBuffer();
        int i = 3;
        while (i >= 0) {
            if (addr[i] < 0 || addr[i] > 255) {
                throw new IllegalArgumentException("array must contain values between 0 and 255");
            }
            sb.append(addr[i]);
            if (i > 0) {
                sb.append(".");
            }
            --i;
        }
        try {
            return Name.fromString(sb.toString(), inaddr);
        }
        catch (TextParseException e) {
            throw new IllegalStateException("name cannot be invalid");
        }
    }

    public static Name fromAddress(InetAddress addr) {
        byte[] bytes = addr.getAddress();
        int[] array = new int[4];
        int i = 0;
        while (i < 4) {
            array[i] = bytes[i] & 0xFF;
            ++i;
        }
        return ReverseMap.fromAddress(array);
    }

    public static Name fromAddress(String addr) throws UnknownHostException {
        int[] array = Address.toArray(addr);
        if (array == null) {
            throw new UnknownHostException("Invalid IP address");
        }
        return ReverseMap.fromAddress(array);
    }
}

