/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class SOARecord
extends Record {
    private static SOARecord member = new SOARecord();
    private Name host;
    private Name admin;
    private int serial;
    private int refresh;
    private int retry;
    private int expire;
    private int minimum;

    private SOARecord() {
    }

    private SOARecord(Name name, int dclass, int ttl) {
        super(name, 6, dclass, ttl);
    }

    static SOARecord getMember() {
        return member;
    }

    public SOARecord(Name name, int dclass, int ttl, Name host, Name admin, int serial, int refresh, int retry, int expire, int minimum) {
        this(name, dclass, ttl);
        if (!host.isAbsolute()) {
            throw new RelativeNameException(host);
        }
        this.host = host;
        if (!admin.isAbsolute()) {
            throw new RelativeNameException(admin);
        }
        this.admin = admin;
        this.serial = serial;
        this.refresh = refresh;
        this.retry = retry;
        this.expire = expire;
        this.minimum = minimum;
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        SOARecord rec = new SOARecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.host = new Name(in);
        rec.admin = new Name(in);
        rec.serial = in.readInt();
        rec.refresh = in.readInt();
        rec.retry = in.readInt();
        rec.expire = in.readInt();
        rec.minimum = in.readInt();
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        SOARecord rec = new SOARecord(name, dclass, ttl);
        rec.host = st.getName(origin);
        rec.admin = st.getName(origin);
        rec.serial = (int)st.getUInt32();
        rec.refresh = st.getTTL();
        rec.retry = st.getTTL();
        rec.expire = st.getTTL();
        rec.minimum = st.getTTL();
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.host != null) {
            sb.append(this.host);
            sb.append(" ");
            sb.append(this.admin);
            if (Options.check("multiline")) {
                sb.append(" (\n\t\t\t\t\t");
                sb.append((long)this.serial & 0xFFFFFFFFL);
                sb.append("\t; serial\n\t\t\t\t\t");
                sb.append(this.refresh);
                sb.append("\t; refresh\n\t\t\t\t\t");
                sb.append(this.retry);
                sb.append("\t; retry\n\t\t\t\t\t");
                sb.append(this.expire);
                sb.append("\t; expire\n\t\t\t\t\t");
                sb.append(this.minimum);
                sb.append(" )\t; minimum");
            } else {
                sb.append(" ");
                sb.append((long)this.serial & 0xFFFFFFFFL);
                sb.append(" ");
                sb.append(this.refresh);
                sb.append(" ");
                sb.append(this.retry);
                sb.append(" ");
                sb.append(this.expire);
                sb.append(" ");
                sb.append(this.minimum);
            }
        }
        return sb.toString();
    }

    public Name getHost() {
        return this.host;
    }

    public Name getAdmin() {
        return this.admin;
    }

    public int getSerial() {
        return this.serial;
    }

    public int getRefresh() {
        return this.refresh;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getExpire() {
        return this.expire;
    }

    public int getMinimum() {
        return this.minimum;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.host == null) {
            return;
        }
        this.host.toWire(out, c, canonical);
        this.admin.toWire(out, c, canonical);
        out.writeInt(this.serial);
        out.writeInt(this.refresh);
        out.writeInt(this.retry);
        out.writeInt(this.expire);
        out.writeInt(this.minimum);
    }
}

