/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class SRVRecord
extends Record {
    private static SRVRecord member = new SRVRecord();
    private int priority;
    private int weight;
    private int port;
    private Name target;

    private SRVRecord() {
    }

    private SRVRecord(Name name, int dclass, int ttl) {
        super(name, 33, dclass, ttl);
    }

    static SRVRecord getMember() {
        return member;
    }

    public SRVRecord(Name name, int dclass, int ttl, int priority, int weight, int port, Name target) {
        this(name, dclass, ttl);
        if (priority < 0 || priority > 65535) {
            throw new IllegalArgumentException("priority is out of range");
        }
        if (weight < 0 || weight > 65535) {
            throw new IllegalArgumentException("weight is out of range");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port is out of range");
        }
        this.priority = priority;
        this.weight = weight;
        this.port = port;
        if (!target.isAbsolute()) {
            throw new RelativeNameException(target);
        }
        this.target = target;
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        SRVRecord rec = new SRVRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.priority = in.readUnsignedShort();
        rec.weight = in.readUnsignedShort();
        rec.port = in.readUnsignedShort();
        rec.target = new Name(in);
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        SRVRecord rec = new SRVRecord(name, dclass, ttl);
        rec.priority = st.getUInt16();
        rec.weight = st.getUInt16();
        rec.port = st.getUInt16();
        rec.target = st.getName(origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.target != null) {
            sb.append(this.priority + " ");
            sb.append(this.weight + " ");
            sb.append(this.port + " ");
            sb.append(this.target);
        }
        return sb.toString();
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getPort() {
        return this.port;
    }

    public Name getTarget() {
        return this.target;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        out.writeShort(this.weight);
        out.writeShort(this.port);
        this.target.toWire(out, null, canonical);
    }

    public Name getAdditionalName() {
        return this.target;
    }
}

