/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.TSIGRecord;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.ZoneTransferException;
import org.xbill.DNS.ZoneTransferIn;
import org.xbill.DNS.utils.hexdump;

public class SimpleResolver
implements Resolver {
    public static final int DEFAULT_PORT = 53;
    private InetAddress addr;
    private int port = 53;
    private boolean useTCP;
    private boolean ignoreTruncation;
    private byte EDNSlevel = (byte)-1;
    private TSIG tsig;
    private int timeoutValue = 10000;
    private static final short DEFAULT_UDPSIZE = 512;
    private static final short EDNS_UDPSIZE = 1280;
    private static String defaultResolver = "localhost";
    private static int uniqueID = 0;

    public SimpleResolver(String hostname) throws UnknownHostException {
        if (hostname == null && (hostname = FindServer.server()) == null) {
            hostname = defaultResolver;
        }
        this.addr = hostname.equals("0") ? InetAddress.getLocalHost() : InetAddress.getByName(hostname);
    }

    public SimpleResolver() throws UnknownHostException {
        this(null);
    }

    public static void setDefaultResolver(String hostname) {
        defaultResolver = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTCP(boolean flag) {
        this.useTCP = flag;
    }

    public void setIgnoreTruncation(boolean flag) {
        this.ignoreTruncation = flag;
    }

    public void setEDNS(int level) {
        if (level != 0 && level != -1) {
            throw new UnsupportedOperationException("invalid EDNS level - must be 0 or -1");
        }
        this.EDNSlevel = (byte)level;
    }

    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    public void setTSIGKey(Name name, byte[] key) {
        this.tsig = new TSIG(name, key);
    }

    public void setTSIGKey(String name, String key) {
        this.tsig = new TSIG(name, key);
    }

    public void setTSIGKey(String key) throws UnknownHostException {
        this.setTSIGKey(InetAddress.getLocalHost().getHostName(), key);
    }

    public void setTimeout(int secs) {
        this.timeoutValue = secs * 1000;
    }

    private byte[] readUDP(DatagramSocket s, int max) throws IOException {
        DatagramPacket dp = new DatagramPacket(new byte[max], max);
        s.receive(dp);
        byte[] in = new byte[dp.getLength()];
        System.arraycopy(dp.getData(), 0, in, 0, in.length);
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("UDP read", in));
        }
        return in;
    }

    private void writeUDP(DatagramSocket s, byte[] out, InetAddress addr, int port) throws IOException {
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("UDP write", out));
        }
        s.send(new DatagramPacket(out, out.length, addr, port));
    }

    private byte[] readTCP(Socket s) throws IOException {
        DataInputStream dataIn = new DataInputStream(s.getInputStream());
        int inLength = dataIn.readUnsignedShort();
        byte[] in = new byte[inLength];
        dataIn.readFully(in);
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("TCP read", in));
        }
        return in;
    }

    private void writeTCP(Socket s, byte[] out) throws IOException {
        if (Options.check("verbosemsg")) {
            System.err.println(hexdump.dump("TCP write", out));
        }
        DataOutputStream dataOut = new DataOutputStream(s.getOutputStream());
        dataOut.writeShort(out.length);
        dataOut.write(out);
    }

    private Message parseMessage(byte[] b) throws WireParseException {
        try {
            return new Message(b);
        }
        catch (IOException e2) {
            WireParseException e2;
            if (Options.check("verbose")) {
                e2.printStackTrace();
            }
            if (!(e2 instanceof WireParseException)) {
                e2 = new WireParseException("Error parsing message");
            }
            throw (WireParseException)e2;
        }
    }

    private void verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return;
        }
        byte error = tsig.verify(response, b, query.getTSIG());
        response.tsigState = error == 0 ? 1 : 3;
        if (Options.check("verbose")) {
            System.err.println("TSIG verify: " + Rcode.string(error));
        }
    }

    private void applyEDNS(Message query) {
        if (this.EDNSlevel < 0 || query.getOPT() != null) {
            return;
        }
        OPTRecord opt = new OPTRecord(1280, 0, 0);
        query.addRecord(opt, 3);
    }

    private int maxUDPSize(Message query) {
        OPTRecord opt = query.getOPT();
        if (opt == null) {
            return 512;
        }
        return opt.getPayloadSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message send(Message query) throws IOException {
        Message response;
        Record question;
        if (Options.check("verbose")) {
            System.err.println("Sending to " + this.addr.getHostAddress() + ":" + this.port);
        }
        if (query.getHeader().getOpcode() == 0 && (question = query.getQuestion()) != null && question.getType() == 252) {
            return this.sendAXFR(query);
        }
        query = (Message)query.clone();
        this.applyEDNS(query);
        if (this.tsig != null) {
            this.tsig.apply(query, null);
        }
        byte[] out = query.toWire(Message.MAXLENGTH);
        int udpSize = this.maxUDPSize(query);
        boolean tcp = false;
        while (true) {
            byte[] in;
            block10: {
                Object var10_8;
                Closeable s;
                if (this.useTCP || out.length > udpSize) {
                    tcp = true;
                }
                if (tcp) {
                    Object var8_7;
                    s = new Socket(this.addr, this.port);
                    ((Socket)s).setSoTimeout(this.timeoutValue);
                    try {
                        this.writeTCP((Socket)s, out);
                        in = this.readTCP((Socket)s);
                        var8_7 = null;
                    }
                    catch (Throwable throwable) {
                        var8_7 = null;
                        ((Socket)s).close();
                        throw throwable;
                    }
                    ((Socket)s).close();
                    {
                        break block10;
                    }
                }
                s = new DatagramSocket();
                ((DatagramSocket)s).setSoTimeout(this.timeoutValue);
                try {
                    this.writeUDP((DatagramSocket)s, out, this.addr, this.port);
                    in = this.readUDP((DatagramSocket)s, udpSize);
                    var10_8 = null;
                    ((DatagramSocket)s).close();
                }
                catch (Throwable throwable) {
                    var10_8 = null;
                    ((DatagramSocket)s).close();
                    throw throwable;
                }
            }
            response = this.parseMessage(in);
            this.verifyTSIG(query, response, in, this.tsig);
            if (tcp || this.ignoreTruncation || !response.getHeader().getFlag(6)) break;
            tcp = true;
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendAsync(Message query, ResolverListener listener) {
        Integer id;
        SimpleResolver simpleResolver = this;
        synchronized (simpleResolver) {
            id = new Integer(uniqueID++);
        }
        Record question = query.getQuestion();
        String qname = question != null ? question.getName().toString() : "(none)";
        String name = this.getClass() + ": " + qname;
        ResolveThread thread = new ResolveThread(this, query, id, listener);
        thread.setDaemon(true);
        thread.start();
        return id;
    }

    private Message sendAXFR(Message query) throws IOException {
        Name qname = query.getQuestion().getName();
        ZoneTransferIn xfrin = ZoneTransferIn.newAXFR(qname, this);
        try {
            xfrin.run();
        }
        catch (ZoneTransferException e) {
            throw new WireParseException(e.getMessage());
        }
        List records = xfrin.getAXFR();
        Message response = new Message(query.getHeader().getID());
        response.getHeader().setFlag(5);
        response.getHeader().setFlag(0);
        response.addRecord(query.getQuestion(), 0);
        Iterator it = records.iterator();
        while (it.hasNext()) {
            response.addRecord((Record)it.next(), 1);
        }
        return response;
    }

    static class Stream {
        SimpleResolver res;
        Socket sock;
        TSIG tsig;
        TSIG.StreamVerifier verifier;

        Stream(SimpleResolver res) throws IOException {
            this.res = res;
            this.sock = new Socket(res.addr, res.port);
            this.sock.setSoTimeout(res.timeoutValue);
            this.tsig = res.tsig;
        }

        void send(Message query) throws IOException {
            if (this.tsig != null) {
                this.tsig.apply(query, null);
                this.verifier = new TSIG.StreamVerifier(this.tsig, query.getTSIG());
            }
            byte[] out = query.toWire(Message.MAXLENGTH);
            this.res.writeTCP(this.sock, out);
        }

        Message next() throws IOException {
            byte[] in = this.res.readTCP(this.sock);
            Message response = this.res.parseMessage(in);
            if (response.getHeader().getRcode() != 0) {
                return response;
            }
            if (this.verifier != null) {
                TSIGRecord tsigrec = response.getTSIG();
                byte error = this.verifier.verify(response, in);
                response.tsigState = error == 0 && tsigrec != null ? 1 : (error == 0 ? 2 : 3);
            }
            return response;
        }

        void close() {
            try {
                this.sock.close();
            }
            catch (IOException e) {}
        }
    }
}

