/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class TXTRecord
extends Record {
    private static TXTRecord member = new TXTRecord();
    private List strings;

    private TXTRecord() {
    }

    private TXTRecord(Name name, int dclass, int ttl) {
        super(name, 16, dclass, ttl);
    }

    static TXTRecord getMember() {
        return member;
    }

    public TXTRecord(Name name, int dclass, int ttl, List strings) {
        this(name, dclass, ttl);
        if (strings == null) {
            throw new IllegalArgumentException("TXTRecord: strings must not be null");
        }
        this.strings = new ArrayList();
        Iterator it = strings.iterator();
        try {
            while (it.hasNext()) {
                String s = (String)it.next();
                this.strings.add(Record.byteArrayFromString(s));
            }
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public TXTRecord(Name name, int dclass, int ttl, String string) {
        this(name, dclass, ttl, Collections.nCopies(1, string));
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        TXTRecord rec = new TXTRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        int count = 0;
        rec.strings = new ArrayList();
        while (count < length) {
            byte[] b = in.readStringIntoArray();
            count += b.length + 1;
            rec.strings.add(b);
        }
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        Tokenizer.Token t;
        TXTRecord rec = new TXTRecord(name, dclass, ttl);
        rec.strings = new ArrayList();
        while ((t = st.get()).isString()) {
            try {
                rec.strings.add(Record.byteArrayFromString(t.value));
            }
            catch (TextParseException e) {
                throw st.exception(e.getMessage());
            }
        }
        st.unget();
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.strings != null) {
            Iterator it = this.strings.iterator();
            while (it.hasNext()) {
                byte[] array = (byte[])it.next();
                sb.append(Record.byteArrayToString(array, true));
                if (!it.hasNext()) continue;
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    public List getStrings() {
        ArrayList<String> list = new ArrayList<String>(this.strings.size());
        int i = 0;
        while (i < this.strings.size()) {
            list.add(Record.byteArrayToString((byte[])this.strings.get(i), false));
            ++i;
        }
        return list;
    }

    public List getStringsAsByteArrays() {
        return this.strings;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.strings == null) {
            return;
        }
        Iterator it = this.strings.iterator();
        while (it.hasNext()) {
            byte[] b = (byte[])it.next();
            out.writeArray(b, true);
        }
    }
}

