/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base16;

public class UNKRecord
extends Record {
    private static UNKRecord member = new UNKRecord();
    private byte[] data;

    private UNKRecord() {
    }

    private UNKRecord(Name name, int type, int dclass, int ttl) {
        super(name, type, dclass, ttl);
    }

    static UNKRecord getMember() {
        return member;
    }

    Record rrFromWire(Name name, int type, int dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        UNKRecord rec = new UNKRecord(name, type, dclass, ttl);
        if (in == null) {
            return rec;
        }
        if (length > 0) {
            rec.data = new byte[length];
            in.read(rec.data);
        } else {
            rec.data = null;
        }
        return rec;
    }

    Record rdataFromString(Name name, int dclass, int ttl, Tokenizer st, Name origin) throws IOException {
        throw st.exception("invalid unknown RR encoding");
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.data != null) {
            sb.append("\\# ");
            sb.append(this.data.length);
            sb.append(" ");
            sb.append(base16.toString(this.data));
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.data != null) {
            out.writeArray(this.data);
        }
    }
}

