/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.ZoneTransferException;

public class ZoneTransferIn {
    private static final int INITIALSOA = 0;
    private static final int FIRSTDATA = 1;
    private static final int IXFR_DELSOA = 2;
    private static final int IXFR_DEL = 3;
    private static final int IXFR_ADDSOA = 4;
    private static final int IXFR_ADD = 5;
    private static final int AXFR = 6;
    private static final int END = 7;
    private SimpleResolver res;
    private Name zname;
    private int qtype;
    private int ixfr_serial;
    private boolean want_fallback;
    private SimpleResolver.Stream stream;
    private int state;
    private int end_serial;
    private int current_serial;
    private Record initialsoa;
    private int rtype;
    private List axfr;
    private List ixfr;

    private ZoneTransferIn() {
    }

    private ZoneTransferIn(SimpleResolver sres, Name zone, int xfrtype, int serial, boolean fallback) {
        this.res = sres;
        if (zone.isAbsolute()) {
            this.zname = zone;
        } else {
            try {
                this.zname = Name.concatenate(zone, Name.root);
            }
            catch (NameTooLongException e) {
                throw new IllegalArgumentException("ZoneTransferIn: name too long");
            }
        }
        this.qtype = xfrtype;
        this.ixfr_serial = serial;
        this.want_fallback = fallback;
        this.state = 0;
    }

    private static SimpleResolver newResolver(String host, int port, TSIG key) throws UnknownHostException {
        SimpleResolver sres = new SimpleResolver(host);
        if (port != 0) {
            sres.setPort(port);
        }
        if (key != null) {
            sres.setTSIGKey(key);
        }
        return sres;
    }

    public static ZoneTransferIn newAXFR(Name zone, SimpleResolver res) {
        return new ZoneTransferIn(res, zone, 252, 0, false);
    }

    public static ZoneTransferIn newAXFR(Name zone, String host, int port, TSIG key) throws UnknownHostException {
        return ZoneTransferIn.newAXFR(zone, ZoneTransferIn.newResolver(host, port, key));
    }

    public static ZoneTransferIn newAXFR(Name zone, String host, TSIG key) throws UnknownHostException {
        return ZoneTransferIn.newAXFR(zone, ZoneTransferIn.newResolver(host, 0, key));
    }

    public static ZoneTransferIn newIXFR(Name zone, int serial, boolean fallback, SimpleResolver res) {
        return new ZoneTransferIn(res, zone, 251, serial, fallback);
    }

    public static ZoneTransferIn newIXFR(Name zone, int serial, boolean fallback, String host, int port, TSIG key) throws UnknownHostException {
        return ZoneTransferIn.newIXFR(zone, serial, fallback, ZoneTransferIn.newResolver(host, port, key));
    }

    public static ZoneTransferIn newIXFR(Name zone, int serial, boolean fallback, String host, TSIG key) throws UnknownHostException {
        return ZoneTransferIn.newIXFR(zone, serial, fallback, ZoneTransferIn.newResolver(host, 0, key));
    }

    private void openConnection() throws IOException {
        this.stream = new SimpleResolver.Stream(this.res);
    }

    private void sendQuery() throws IOException {
        Record question = Record.newRecord(this.zname, this.qtype, 1);
        Message query = new Message();
        query.getHeader().setOpcode((byte)0);
        query.addRecord(question, 0);
        if (this.qtype == 251) {
            SOARecord soa = new SOARecord(this.zname, 1, 0, Name.root, Name.root, this.ixfr_serial, 0, 0, 0, 0);
            query.addRecord(soa, 2);
        }
        this.stream.send(query);
    }

    private int getSOASerial(Record rec) {
        SOARecord soa = (SOARecord)rec;
        return soa.getSerial();
    }

    private void logxfr(String s) {
        if (Options.check("verbose")) {
            System.out.println(this.zname + ": " + s);
        }
    }

    private void fail(String s) throws ZoneTransferException {
        throw new ZoneTransferException(s);
    }

    private void fallback() throws ZoneTransferException {
        if (!this.want_fallback) {
            this.fail("server doesn't support IXFR");
        }
        this.logxfr("falling back to AXFR");
        this.qtype = 252;
        this.state = 0;
        this.closeConnection();
    }

    private void parseRR(Record rec) throws ZoneTransferException {
        Name name = rec.getName();
        int type = rec.getType();
        switch (this.state) {
            case 0: {
                if (type != 6) {
                    this.fail("missing initial SOA");
                }
                this.initialsoa = rec;
                this.end_serial = this.getSOASerial(rec);
                if (this.qtype == 251 && this.end_serial <= this.ixfr_serial) {
                    this.logxfr("up to date");
                    this.state = 7;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (this.qtype == 251 && type == 6 && this.getSOASerial(rec) == this.ixfr_serial) {
                    this.rtype = 251;
                    this.ixfr = new ArrayList();
                    this.logxfr("got incremental response");
                    this.state = 2;
                } else {
                    this.rtype = 252;
                    this.axfr = new ArrayList();
                    this.axfr.add(this.initialsoa);
                    this.logxfr("got nonincremental response");
                    this.state = 6;
                }
                this.parseRR(rec);
                return;
            }
            case 2: {
                Delta delta = new Delta();
                this.ixfr.add(delta);
                delta.start = this.getSOASerial(rec);
                delta.deletes.add(rec);
                this.state = 3;
                break;
            }
            case 3: {
                if (type == 6) {
                    this.current_serial = this.getSOASerial(rec);
                    this.state = 4;
                    this.parseRR(rec);
                    return;
                }
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                delta.deletes.add(rec);
                break;
            }
            case 4: {
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                delta.end = this.getSOASerial(rec);
                delta.adds.add(rec);
                this.state = 5;
                break;
            }
            case 5: {
                if (type == 6) {
                    int soa_serial = this.getSOASerial(rec);
                    if (soa_serial == this.end_serial) {
                        this.state = 7;
                        break;
                    }
                    if (soa_serial != this.current_serial) {
                        this.fail("IXFR out of sync: expected serial " + this.current_serial + " , got " + soa_serial);
                    } else {
                        this.state = 2;
                        this.parseRR(rec);
                        return;
                    }
                }
                Delta delta = (Delta)this.ixfr.get(this.ixfr.size() - 1);
                delta.adds.add(rec);
                break;
            }
            case 6: {
                if (type == 1 && rec.getDClass() != 1) break;
                this.axfr.add(rec);
                if (type != 6) break;
                this.state = 7;
                break;
            }
            case 7: {
                this.fail("extra data");
                break;
            }
            default: {
                this.fail("invalid state");
            }
        }
    }

    private void closeConnection() {
        this.stream.close();
    }

    private void doxfr() throws IOException, ZoneTransferException {
        this.sendQuery();
        while (this.state != 7) {
            Message response = this.stream.next();
            if (response.tsigState == 3) {
                this.fail("TSIG failure");
            }
            Record[] answers = response.getSectionArray(1);
            if (this.state == 0) {
                Record question;
                short rcode = response.getRcode();
                if (rcode != 0) {
                    if (this.qtype == 251 && rcode == 4) {
                        this.fallback();
                        this.run();
                        return;
                    }
                    this.fail(Rcode.string(rcode));
                }
                if ((question = response.getQuestion()) != null && question.getType() != this.qtype) {
                    this.fail("invalid question section");
                }
                if (answers.length == 0 && this.qtype == 251) {
                    this.fallback();
                    this.run();
                    return;
                }
            }
            int i = 0;
            while (i < answers.length) {
                this.parseRR(answers[i]);
                ++i;
            }
            if (this.state != 7 || response.tsigState != 2) continue;
            this.fail("last message must be signed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List run() throws IOException, ZoneTransferException {
        this.openConnection();
        try {
            this.doxfr();
            Object var2_1 = null;
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.closeConnection();
            throw throwable;
        }
        if (this.axfr != null) {
            return this.axfr;
        }
        if (this.ixfr != null) {
            return this.ixfr;
        }
        return null;
    }

    public boolean isAXFR() {
        return this.rtype == 252;
    }

    public List getAXFR() {
        return this.axfr;
    }

    public boolean isIXFR() {
        return this.rtype == 251;
    }

    public List getIXFR() {
        return this.ixfr;
    }

    public boolean isCurrent() {
        return this.axfr == null && this.ixfr == null;
    }

    public static class Delta {
        public int start;
        public int end;
        public List adds = new ArrayList();
        public List deletes = new ArrayList();

        private Delta() {
        }
    }
}

