/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;

public class DataByteOutputStream
extends ByteArrayOutputStream {
    public DataByteOutputStream(int size) {
        super(size);
    }

    public DataByteOutputStream() {
    }

    public void writeByte(int i) {
        this.write(i);
    }

    public void writeShort(int i) {
        this.write(i >>> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeInt(int i) {
        this.write(i >>> 24 & 0xFF);
        this.write(i >>> 16 & 0xFF);
        this.write(i >>> 8 & 0xFF);
        this.write(i & 0xFF);
    }

    public void writeLong(long l) {
        this.write((int)(l >>> 56) & 0xFF);
        this.write((int)(l >>> 48) & 0xFF);
        this.write((int)(l >>> 40) & 0xFF);
        this.write((int)(l >>> 32) & 0xFF);
        this.write((int)(l >>> 24) & 0xFF);
        this.write((int)(l >>> 16) & 0xFF);
        this.write((int)(l >>> 8) & 0xFF);
        this.write((int)l & 0xFF);
    }

    public void writeString(String s) {
        this.writeByte(s.length());
        this.writeArray(s.getBytes());
    }

    public void writeString(byte[] s, int start) {
        this.write(s, start, s[start] + 1);
    }

    public void writeArray(byte[] b, boolean writeLength) {
        if (writeLength) {
            this.writeByte(b.length);
        }
        this.write(b, 0, b.length);
    }

    public void writeArray(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void writeBigInteger(BigInteger i) {
        byte[] b = i.toByteArray();
        if (b[0] == 0) {
            this.write(b, 1, b.length - 1);
        } else {
            this.write(b, 0, b.length);
        }
    }

    public void writeShortAt(int i, int pos) {
        if (pos < 0 || pos > this.count) {
            throw new IllegalArgumentException(pos + " out of range");
        }
        int oldcount = this.count;
        this.count = pos;
        this.writeShort(i);
        this.count = oldcount;
    }

    public void setPos(int pos) {
        this.count = pos;
    }

    public int getPos() {
        return this.count;
    }
}

