/*
 * Decompiled with CFR 0.152.
 */
public class JMXGrinderCmd {
    private static boolean verbose;
    private int standardCompliantCount = 0;
    private int dynamicCompliantCount = 0;
    private int unresolvedCount = 0;
    private int nonCompliantCount = 0;
    private static final String SPACE = " ";

    public JMXGrinderCmd(String[] stringArray, boolean bl) {
        verbose = bl;
        int n = 0;
        while (n < stringArray.length) {
            this.checkMBean(stringArray[n]);
            ++n;
        }
        this.printTotals();
    }

    private void checkMBean(String string) {
        Object object = null;
        try {
            object = GrinderWrapper.testCompliance(Class.forName(string));
            if (object instanceof MBeanInfo) {
                ++this.standardCompliantCount;
                this.printStandardMBeanInfo((MBeanInfo)object);
                return;
            }
            ++this.dynamicCompliantCount;
            this.printDynamicMBeanInfo(string, (MBeanConstructorInfo[])object);
            return;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            ++this.nonCompliantCount;
            this.printNonCompliantMBean(string, notCompliantMBeanException);
            return;
        }
        catch (Exception exception) {
            ++this.unresolvedCount;
            this.printUnresolvedMBean(string, exception);
            return;
        }
    }

    private void printDynamicMBeanInfo(String string, MBeanConstructorInfo[] mBeanConstructorInfoArray) {
        if (verbose) {
            System.out.println(String.valueOf(JMXResources.getString("className")) + SPACE + ":" + SPACE + string);
            int n = 0;
            while (n < mBeanConstructorInfoArray.length) {
                System.out.print("  " + JMXResources.getString("constructorInfo") + SPACE + (n + 1) + SPACE + ":" + SPACE + mBeanConstructorInfoArray[n].getName() + "(" + SPACE);
                MBeanParameterInfo[] mBeanParameterInfoArray = mBeanConstructorInfoArray[n].getSignature();
                int n2 = 0;
                while (n2 < mBeanParameterInfoArray.length) {
                    System.out.print(String.valueOf(mBeanParameterInfoArray[n2].getType()) + SPACE);
                    ++n2;
                }
                System.out.println(")");
                System.out.println();
                ++n;
            }
            System.out.println(String.valueOf(string) + SPACE + "-" + SPACE + JMXResources.getString("jmxDynamicMBeanCompliant"));
        } else {
            System.out.println(String.valueOf(string) + SPACE + "-" + SPACE + JMXResources.getString("jmxDynamicMBeanCompliant"));
        }
    }

    private void printNonCompliantMBean(String string, NotCompliantMBeanException notCompliantMBeanException) {
        System.out.println(String.valueOf(string) + SPACE + "-" + SPACE + JMXResources.getString("notJMXCompliant") + SPACE + ":" + SPACE + notCompliantMBeanException.toString());
        if (verbose) {
            System.out.println();
        }
    }

    private void printStandardMBeanInfo(MBeanInfo mBeanInfo) {
        if (verbose) {
            int n;
            MBeanFeatureInfo[] mBeanFeatureInfoArray;
            int n2;
            MBeanFeatureInfo[] mBeanFeatureInfoArray2;
            System.out.println(String.valueOf(JMXResources.getString("className")) + SPACE + ":" + SPACE + mBeanInfo.getClassName());
            MBeanConstructorInfo[] mBeanConstructorInfoArray = mBeanInfo.getConstructors();
            int n3 = 0;
            while (n3 < mBeanConstructorInfoArray.length) {
                System.out.print("  " + JMXResources.getString("constructorInfo") + SPACE + (n3 + 1) + SPACE + ":" + SPACE + mBeanConstructorInfoArray[n3].getName() + "(" + SPACE);
                mBeanFeatureInfoArray2 = mBeanConstructorInfoArray[n3].getSignature();
                n2 = 0;
                while (n2 < mBeanFeatureInfoArray2.length) {
                    System.out.print(String.valueOf(((MBeanParameterInfo)mBeanFeatureInfoArray2[n2]).getType()) + SPACE);
                    ++n2;
                }
                System.out.println(")");
                ++n3;
            }
            mBeanFeatureInfoArray2 = mBeanInfo.getOperations();
            n2 = 0;
            while (n2 < mBeanFeatureInfoArray2.length) {
                System.out.print("  " + JMXResources.getString("operationInfo") + SPACE + (n2 + 1) + SPACE + ":" + SPACE + mBeanFeatureInfoArray2[n2].getReturnType() + SPACE + mBeanFeatureInfoArray2[n2].getName() + "(" + SPACE);
                mBeanFeatureInfoArray = ((MBeanOperationInfo)mBeanFeatureInfoArray2[n2]).getSignature();
                n = 0;
                while (n < mBeanFeatureInfoArray.length) {
                    System.out.print(String.valueOf(((MBeanParameterInfo)mBeanFeatureInfoArray[n]).getType()) + SPACE);
                    ++n;
                }
                System.out.println(")");
                ++n2;
            }
            mBeanFeatureInfoArray = mBeanInfo.getAttributes();
            n = 0;
            while (n < mBeanFeatureInfoArray.length) {
                System.out.println("  " + JMXResources.getString("attributeInfo") + SPACE + (n + 1) + SPACE + ":" + SPACE + JMXResources.getString("attributeName") + "=" + mBeanFeatureInfoArray[n].getName() + SPACE + JMXResources.getString("attributeType") + "=" + ((MBeanAttributeInfo)mBeanFeatureInfoArray[n]).getType() + SPACE + JMXResources.getString("attributeIsReadable") + "=" + ((MBeanAttributeInfo)mBeanFeatureInfoArray[n]).isReadable() + SPACE + JMXResources.getString("attributeIsWriteable") + "=" + ((MBeanAttributeInfo)mBeanFeatureInfoArray[n]).isWritable());
                ++n;
            }
            System.out.println(String.valueOf(mBeanInfo.getClassName()) + SPACE + "-" + SPACE + JMXResources.getString("jmxStandardMBeanCompliant"));
            System.out.println();
        } else {
            System.out.println(String.valueOf(mBeanInfo.getClassName()) + SPACE + "-" + SPACE + JMXResources.getString("jmxStandardMBeanCompliant"));
        }
    }

    private void printTotals() {
        System.out.println(String.valueOf(JMXResources.getString("summary")) + ":");
        System.out.println("  " + JMXResources.getString("jmxStandardMBeanCompliant") + SPACE + ":" + SPACE + this.standardCompliantCount);
        System.out.println("  " + JMXResources.getString("jmxDynamicMBeanCompliant") + SPACE + ":" + SPACE + this.dynamicCompliantCount);
        System.out.println("  " + JMXResources.getString("notJMXCompliant") + SPACE + ":" + SPACE + this.nonCompliantCount);
        System.out.println("  " + JMXResources.getString("unresolvedClass") + SPACE + ":" + SPACE + this.unresolvedCount);
        System.out.println("-------------------------------------");
        System.out.println("  " + JMXResources.getString("total") + SPACE + ":" + SPACE + (this.standardCompliantCount + this.dynamicCompliantCount + this.nonCompliantCount + this.unresolvedCount));
        System.out.println("-------------------------------------");
        System.out.println();
        if (this.unresolvedCount > 0) {
            System.exit(1);
        }
        if (this.nonCompliantCount > 0) {
            System.exit(-1);
        }
        System.exit(0);
    }

    private void printUnresolvedMBean(String string, Exception exception) {
        System.out.println(String.valueOf(string) + SPACE + "-" + SPACE + JMXResources.getString("unresolvedClass") + SPACE + ":" + SPACE + exception.toString());
        if (verbose) {
            System.out.println();
        }
    }
}

