/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JMXGrinderGUI
extends JFrame
implements ActionListener,
KeyListener,
WindowListener,
MouseListener,
ChangeListener {
    private static final String SPACE = " ";
    private JTree classTree;
    private JTree standardMBeanTree;
    private JTree dynamicMBeanTree;
    private JTree noncompliantMBeanTree;
    private JTree unresolvedTree;
    private DefaultMutableTreeNode standardTreeRoot;
    private DefaultMutableTreeNode dynamicTreeRoot;
    private DefaultMutableTreeNode unresolvedTreeRoot;
    private DefaultMutableTreeNode noncompliantTreeRoot;
    private static final String CLASS_TAG = ".class";
    private Vector classPathSegmentsDone;
    private ImageIcon standardIcon = new ImageIcon(JMXGrinderGUI.getResource("resources/standardMBean.gif"));
    private ImageIcon dynamicIcon = new ImageIcon(JMXGrinderGUI.getResource("resources/dynamicMBean.gif"));
    private ImageIcon noncompliantIcon = new ImageIcon(JMXGrinderGUI.getResource("resources/noncompliantMBean.gif"));
    private ImageIcon unresolvedIcon = new ImageIcon(JMXGrinderGUI.getResource("resources/unresolvedMBean.gif"));
    private ImageIcon loadIcon = new ImageIcon(JMXGrinderGUI.getResource("resources/load.gif"));
    private ImageIcon checkIcon = new ImageIcon(JMXGrinderGUI.getResource("resources/check.gif"));
    private JTextField classPath;
    private URLClassLoader urlClassLoader;
    private JLabel standardStatus;
    private JLabel dynamicStatus;
    private JLabel noncompliantStatus;
    private JLabel unresolvedStatus;
    private JDialog aboutBox;
    private JTabbedPane resultsPane;
    private static final int STANDARD_TAB = 0;
    private static final int DYNAMIC_TAB = 1;
    private static final int NONCOMPLIANT_TAB = 2;
    private static final int UNRESOLVED_TAB = 3;
    private JMXPropertyViewer propertyViewer;
    private boolean warnIfIgnoring = false;
    private JDialog waitDialog;
    private JLabel waitMessage;

    public JMXGrinderGUI() {
        super(JMXResources.getString("jmx.grinder.name"));
        this.setupScreen();
    }

    private void aboutBox() {
        if (this.aboutBox == null) {
            this.aboutBox = new JDialog(this, JMXResources.getString("about"), true);
            JPanel jPanel = new JPanel(new GridLayout(5, 1));
            jPanel.setBorder(BorderFactory.createBevelBorder(1));
            jPanel.add(new JLabel(String.valueOf(JMXResources.getString("jmx.grinder.name")) + SPACE + JMXResources.getString("jmx.grinder.version"), 0));
            jPanel.add(new JLabel(String.valueOf(JMXResources.getString("jmx.specification.name")) + SPACE + JMXResources.getString("jmx.grinder.version"), 0));
            jPanel.add(new JLabel(JMXResources.getString("copyright1"), 0));
            jPanel.add(new JLabel(JMXResources.getString("copyright2"), 0));
            this.aboutBox.getContentPane().add((Component)jPanel, "Center");
            JButton jButton = new JButton(JMXResources.getString("close"));
            this.aboutBox.getContentPane().add((Component)jButton, "South");
            jButton.addActionListener(this);
            this.aboutBox.pack();
        }
        this.aboutBox.setLocationRelativeTo(this);
        ((Component)this.aboutBox).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("printResults"))) {
                this.printResults();
                return;
            }
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("expandClassTree"))) {
                JMXGrinderGUI.expandAll(this.classTree);
                return;
            }
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("collapseClassTree"))) {
                JMXGrinderGUI.collapseAll(this.classTree);
                return;
            }
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("clearResults"))) {
                this.standardTreeRoot.removeAllChildren();
                ((DefaultTreeModel)this.standardMBeanTree.getModel()).reload(this.standardTreeRoot);
                this.dynamicTreeRoot.removeAllChildren();
                ((DefaultTreeModel)this.dynamicMBeanTree.getModel()).reload(this.dynamicTreeRoot);
                this.unresolvedTreeRoot.removeAllChildren();
                ((DefaultTreeModel)this.unresolvedTree.getModel()).reload(this.unresolvedTreeRoot);
                this.noncompliantTreeRoot.removeAllChildren();
                ((DefaultTreeModel)this.noncompliantMBeanTree.getModel()).reload(this.noncompliantTreeRoot);
                this.standardStatus.setText("0");
                this.dynamicStatus.setText(this.standardStatus.getText());
                this.noncompliantStatus.setText(this.standardStatus.getText());
                this.unresolvedStatus.setText(this.standardStatus.getText());
                ((Component)this.propertyViewer).setVisible(false);
                return;
            }
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("viewProperties"))) {
                ((Component)this.propertyViewer).setVisible(true);
                return;
            }
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("about"))) {
                this.aboutBox();
                return;
            }
            if (((JMenuItem)actionEvent.getSource()).getText().equals(JMXResources.getString("exit"))) {
                this.shutDown();
            }
        }
        if (actionEvent.getSource() instanceof JButton) {
            if (((JButton)actionEvent.getSource()).getText().equals(JMXResources.getString("load"))) {
                this.loadClassPath(this.classPath.getText());
                return;
            }
            if (((JButton)actionEvent.getSource()).getText().equals(JMXResources.getString("checkSelected"))) {
                this.checkSelectedClasses();
                return;
            }
            if (((JButton)actionEvent.getSource()).getText().equals(JMXResources.getString("close"))) {
                ((Component)this.aboutBox).setVisible(false);
            }
        }
    }

    private void add(String string, Vector vector) {
        block3: {
            String string2 = "";
            if (string.length() == 0) break block3;
            File file = new File(string);
            if (file.isDirectory()) {
                string2 = "/";
            }
            try {
                vector.addElement(new URL("file:" + string + string2));
            }
            catch (Exception exception) {
                System.out.println("Internal error occurred :" + exception.toString());
            }
        }
    }

    private void addNode(DefaultMutableTreeNode defaultMutableTreeNode, Vector vector) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        String string = (String)vector.get(0);
        vector.remove(0);
        if (vector.size() == 0) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(string));
            return;
        }
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            if (defaultMutableTreeNode2.getUserObject().equals(string)) {
                this.addNode(defaultMutableTreeNode2, vector);
                return;
            }
            ++n;
        }
        defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        this.addNode(defaultMutableTreeNode2, vector);
    }

    private boolean alreadyProcessed(String string) {
        int n = 0;
        while (n < this.classPathSegmentsDone.size()) {
            if (string.equals((String)this.classPathSegmentsDone.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void checkClass(DefaultMutableTreeNode defaultMutableTreeNode) {
        Class clazz = null;
        JMXResult jMXResult = new JMXResult(defaultMutableTreeNode.getUserObject().toString());
        try {
            clazz = this.findClass(defaultMutableTreeNode);
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                if (this.warnIfIgnoring) {
                    JOptionPane.showMessageDialog(this, JMXResources.getString("checkInterfaceError"), JMXResources.getString("error"), 0);
                    this.warnIfIgnoring = false;
                }
                return;
            }
            jMXResult.setClassType(clazz);
            jMXResult.setResult(GrinderWrapper.testCompliance(clazz));
            if (jMXResult.getResult() instanceof MBeanInfo) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(jMXResult);
                this.removeNode(this.standardTreeRoot, defaultMutableTreeNode2);
                this.standardTreeRoot.add(defaultMutableTreeNode2);
                ((DefaultTreeModel)this.standardMBeanTree.getModel()).reload(this.standardTreeRoot);
                this.resultsPane.setSelectedIndex(0);
            } else {
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(jMXResult);
                this.removeNode(this.dynamicTreeRoot, defaultMutableTreeNode3);
                this.dynamicTreeRoot.add(defaultMutableTreeNode3);
                ((DefaultTreeModel)this.dynamicMBeanTree.getModel()).reload(this.dynamicTreeRoot);
                this.resultsPane.setSelectedIndex(1);
            }
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(jMXResult);
            this.removeNode(this.noncompliantTreeRoot, defaultMutableTreeNode4);
            this.noncompliantTreeRoot.add(defaultMutableTreeNode4);
            ((DefaultTreeModel)this.noncompliantMBeanTree.getModel()).reload(this.noncompliantTreeRoot);
            this.resultsPane.setSelectedIndex(2);
            jMXResult.setResult(notCompliantMBeanException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(jMXResult);
            this.removeNode(this.unresolvedTreeRoot, defaultMutableTreeNode5);
            this.unresolvedTreeRoot.add(defaultMutableTreeNode5);
            ((DefaultTreeModel)this.unresolvedTree.getModel()).reload(this.unresolvedTreeRoot);
            this.resultsPane.setSelectedIndex(3);
            jMXResult.setResult(noClassDefFoundError);
        }
        catch (LinkageError linkageError) {
            DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(jMXResult);
            this.removeNode(this.unresolvedTreeRoot, defaultMutableTreeNode6);
            this.unresolvedTreeRoot.add(defaultMutableTreeNode6);
            ((DefaultTreeModel)this.unresolvedTree.getModel()).reload(this.unresolvedTreeRoot);
            this.resultsPane.setSelectedIndex(3);
            jMXResult.setResult(linkageError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(jMXResult);
            this.removeNode(this.unresolvedTreeRoot, defaultMutableTreeNode7);
            this.unresolvedTreeRoot.add(defaultMutableTreeNode7);
            ((DefaultTreeModel)this.unresolvedTree.getModel()).reload(this.unresolvedTreeRoot);
            this.resultsPane.setSelectedIndex(3);
            jMXResult.setResult(classNotFoundException);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, JMXResources.getString("checkEmptyError"), JMXResources.getString("error"), 0);
            return;
        }
    }

    private void checkSelectedClasses() {
        Vector vector = this.getSelectedNodes(this.classTree);
        this.checkSelectedClasses(vector);
    }

    private void checkSelectedClasses(Vector vector) {
        try {
            try {
                if (vector.size() == 0) {
                    JOptionPane.showMessageDialog(this, JMXResources.getString("noneSelectedError"), JMXResources.getString("error"), 0);
                }
                this.warnIfIgnoring = vector.size() == 1;
                int n = 0;
                while (n < vector.size()) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)vector.elementAt(n);
                    this.waitMessage(String.valueOf(JMXResources.getString("checking")) + SPACE + defaultMutableTreeNode.getUserObject().toString());
                    if (defaultMutableTreeNode.isLeaf()) {
                        this.checkClass(defaultMutableTreeNode);
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
            }
            Object var3_4 = null;
            this.finishMessage();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.finishMessage();
            throw throwable;
        }
        this.updateStatus();
    }

    private void checkSingleClass(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.waitMessage(String.valueOf(JMXResources.getString("checking")) + SPACE + defaultMutableTreeNode.getUserObject().toString());
        try {
            try {
                this.checkClass(defaultMutableTreeNode);
            }
            catch (Throwable throwable) {
            }
            Object var3_2 = null;
            this.finishMessage();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.finishMessage();
            throw throwable;
        }
    }

    private static void collapseAll(JTree jTree) {
        int n = jTree.getRowCount() - 1;
        while (n != 0) {
            jTree.collapseRow(n);
            --n;
        }
    }

    private static void expandAll(JTree jTree) {
        int n = 0;
        while (n != jTree.getRowCount()) {
            jTree.expandRow(n);
            ++n;
        }
    }

    private Class findClass(DefaultMutableTreeNode defaultMutableTreeNode) throws ClassNotFoundException {
        TreeNode[] treeNodeArray = defaultMutableTreeNode.getPath();
        String string = "";
        int n = 1;
        while (n < treeNodeArray.length) {
            string = String.valueOf(string) + "*" + treeNodeArray[n].toString();
            ++n;
        }
        string = string.substring(string.indexOf("*") + 1, string.length());
        String string2 = string.substring(0, string.indexOf("*"));
        string = string.substring(string.indexOf("*") + 1, string.length());
        string = string.replace('*', '.');
        try {
            return this.urlClassLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.urlClassLoader.loadClass(defaultMutableTreeNode.getUserObject().toString());
        }
    }

    private void finishMessage() {
        if (this.waitDialog != null) {
            ((Component)this.waitDialog).setVisible(false);
            this.waitDialog.dispose();
            this.waitDialog = null;
        }
    }

    public Vector getAllNodes(DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>(defaultMutableTreeNode.getChildCount());
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!defaultMutableTreeNode.isLeaf()) continue;
            vector.addElement(defaultMutableTreeNode);
        }
        return vector;
    }

    public DefaultMutableTreeNode getNode(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    private String getPad(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = 45;
            ++n2;
        }
        return new String(cArray);
    }

    protected static URL getResource(String string) {
        try {
            if (string != null) {
                return Class.forName("JMXGrinderGUI").getResource(string);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Vector getSelectedNodes(JTree jTree) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        TreePath[] treePathArray = jTree.getSelectionPaths();
        if (treePathArray == null) {
            return vector;
        }
        int n = 0;
        while (n < treePathArray.length) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.getNode(treePathArray[n]);
            if (defaultMutableTreeNode.isLeaf()) {
                vector.addElement(defaultMutableTreeNode);
            } else if (!jTree.isExpanded(treePathArray[n])) {
                Vector vector2 = this.getAllNodes(defaultMutableTreeNode);
                int n2 = 0;
                while (n2 < vector2.size()) {
                    vector.addElement((DefaultMutableTreeNode)vector2.elementAt(n2));
                    ++n2;
                }
            }
            ++n;
        }
        return vector;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n') {
            this.loadClassPath(this.classPath.getText());
        }
    }

    private void loadClassPath(String string) {
        this.waitMessage(JMXResources.getString("loading"));
        try {
            try {
                this.urlClassLoader = new URLClassLoader(this.split(string));
                this.classPathSegmentsDone = new Vector();
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("java.class.path");
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    File file;
                    String string2 = stringTokenizer.nextToken();
                    if (!this.alreadyProcessed(string2) && (file = new File(string2)).exists()) {
                        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string2);
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        if (file.isDirectory()) {
                            this.loadDirectory(defaultMutableTreeNode2, file);
                        } else {
                            this.loadJar(defaultMutableTreeNode2, file);
                        }
                    }
                    this.classPathSegmentsDone.addElement(string2);
                }
                ((DefaultTreeModel)this.classTree.getModel()).setRoot(defaultMutableTreeNode);
                this.classPathSegmentsDone = null;
            }
            catch (Exception exception) {
                System.out.println("Caught internal error (2) :" + exception.toString());
            }
            Object var3_8 = null;
            this.finishMessage();
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.finishMessage();
            throw throwable;
        }
    }

    private void loadDirectory(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        try {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            String[] stringArray = file.list();
            int n = 0;
            while (n < stringArray.length) {
                File file2 = new File(String.valueOf(file.getPath()) + File.separator + stringArray[n]);
                if (file2.isDirectory()) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n]);
                    this.loadDirectory(defaultMutableTreeNode2, file2);
                    if (!defaultMutableTreeNode2.isLeaf()) {
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                    }
                } else if (stringArray[n].endsWith(CLASS_TAG)) {
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(stringArray[n].substring(0, stringArray[n].indexOf(CLASS_TAG)));
                    defaultMutableTreeNode.add(defaultMutableTreeNode2);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(exception.getMessage()));
        }
    }

    private void loadJar(DefaultMutableTreeNode defaultMutableTreeNode, File file) {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.isDirectory() && zipEntry.getName().charAt(zipEntry.getName().length() - 1) != '/' && zipEntry.getName().endsWith(CLASS_TAG)) {
                    StringTokenizer stringTokenizer = new StringTokenizer(zipEntry.getName().substring(0, zipEntry.getName().lastIndexOf(CLASS_TAG)), "/");
                    Vector<String> vector = new Vector<String>(stringTokenizer.countTokens());
                    while (stringTokenizer.hasMoreTokens()) {
                        vector.add(stringTokenizer.nextToken());
                    }
                    this.addNode(defaultMutableTreeNode, vector);
                }
                zipInputStream.closeEntry();
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(exception.getMessage()));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TreePath treePath;
        if (mouseEvent.getSource().equals(this.classTree) && (treePath = this.classTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            if (mouseEvent.getClickCount() == 2 && defaultMutableTreeNode.isLeaf()) {
                Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>(1);
                vector.addElement(defaultMutableTreeNode);
                this.checkSelectedClasses(vector);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private void printResults() {
        JMXPrintManager jMXPrintManager = new JMXPrintManager("Print results", this);
        if (jMXPrintManager.startPrint()) {
            String[] stringArray = new String[]{String.valueOf(JMXResources.getString("jmx.grinder.name")) + " Results", "Beans checked according to " + JMXResources.getString("jmx.specification.name") + SPACE + JMXResources.getString("jmx.specification.version") + " specification", "CLASSPATH=" + this.classPath.getText()};
            jMXPrintManager.setHeader(stringArray);
            jMXPrintManager.printHeader();
            jMXPrintManager.println("");
            jMXPrintManager.bold();
            jMXPrintManager.println(String.valueOf(JMXResources.getString("standardMBeans")) + ":");
            jMXPrintManager.plain();
            Vector vector = this.getAllNodes(this.standardTreeRoot);
            int n = 0;
            while (n < vector.size()) {
                if (!((DefaultMutableTreeNode)vector.elementAt(n)).equals(this.standardTreeRoot)) {
                    jMXPrintManager.println(String.valueOf(this.getPad(((DefaultMutableTreeNode)vector.elementAt(n)).getDepth())) + ((DefaultMutableTreeNode)vector.elementAt(n)).getUserObject().toString());
                }
                ++n;
            }
            jMXPrintManager.println("");
            jMXPrintManager.bold();
            jMXPrintManager.println(String.valueOf(JMXResources.getString("dynamicMBeans")) + ":");
            jMXPrintManager.plain();
            vector = this.getAllNodes(this.dynamicTreeRoot);
            int n2 = 0;
            while (n2 < vector.size()) {
                if (!((DefaultMutableTreeNode)vector.elementAt(n2)).equals(this.dynamicTreeRoot)) {
                    jMXPrintManager.println(String.valueOf(this.getPad(((DefaultMutableTreeNode)vector.elementAt(n2)).getDepth())) + ((DefaultMutableTreeNode)vector.elementAt(n2)).getUserObject().toString());
                }
                ++n2;
            }
            jMXPrintManager.println("");
            jMXPrintManager.bold();
            jMXPrintManager.println(String.valueOf(JMXResources.getString("noncompliantMBeans")) + ":");
            jMXPrintManager.plain();
            vector = this.getAllNodes(this.noncompliantTreeRoot);
            int n3 = 0;
            while (n3 < vector.size()) {
                if (!((DefaultMutableTreeNode)vector.elementAt(n3)).equals(this.noncompliantTreeRoot)) {
                    jMXPrintManager.println(String.valueOf(this.getPad(((DefaultMutableTreeNode)vector.elementAt(n3)).getDepth())) + ((DefaultMutableTreeNode)vector.elementAt(n3)).getUserObject().toString());
                }
                ++n3;
            }
            jMXPrintManager.println("");
            jMXPrintManager.bold();
            jMXPrintManager.println(String.valueOf(JMXResources.getString("unresolvedClasses")) + ":");
            jMXPrintManager.plain();
            vector = this.getAllNodes(this.unresolvedTreeRoot);
            int n4 = 0;
            while (n4 < vector.size()) {
                if (!((DefaultMutableTreeNode)vector.elementAt(n4)).equals(this.unresolvedTreeRoot)) {
                    jMXPrintManager.println(String.valueOf(this.getPad(((DefaultMutableTreeNode)vector.elementAt(n4)).getDepth())) + ((DefaultMutableTreeNode)vector.elementAt(n4)).getUserObject().toString());
                }
                ++n4;
            }
            jMXPrintManager.endPrint();
        }
    }

    private void removeNode(DefaultMutableTreeNode defaultMutableTreeNode, DefaultMutableTreeNode defaultMutableTreeNode2) {
        int n = 0;
        while (n < defaultMutableTreeNode.getChildCount()) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n);
            if (defaultMutableTreeNode3.getUserObject().equals(defaultMutableTreeNode2.getUserObject())) {
                defaultMutableTreeNode.remove(defaultMutableTreeNode3);
                return;
            }
            ++n;
        }
    }

    private void setupMenu() {
        this.propertyViewer = new JMXPropertyViewer();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(JMXResources.getString("file"));
        JMenuItem jMenuItem = new JMenuItem(JMXResources.getString("printResults"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(JMXResources.getString("expandClassTree"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(JMXResources.getString("collapseClassTree"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(JMXResources.getString("clearResults"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(JMXResources.getString("exit"));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(JMXResources.getString("view"));
        jMenuItem = new JMenuItem(JMXResources.getString("viewProperties"));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        JMenu jMenu3 = new JMenu(JMXResources.getString("help"));
        jMenuItem = new JMenuItem(JMXResources.getString("about"));
        jMenuItem.addActionListener(this);
        jMenu3.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener(this);
    }

    private void setupScreen() {
        this.setupMenu();
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createBevelBorder(1));
        JButton jButton = new JButton(JMXResources.getString("load"), this.loadIcon);
        jButton.addActionListener(this);
        this.classPath = new JTextField(System.getProperties().getProperty("java.class.path"), 20);
        this.classPath.addKeyListener(this);
        jPanel.add((Component)this.classPath, "Center");
        jPanel.add((Component)jButton, "East");
        jPanel.add((Component)new JLabel(JMXResources.getString("classpath"), 0), "West");
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        this.classTree = new JTree(new DefaultMutableTreeNode(JMXResources.getString("noClassesLoaded")));
        JScrollPane jScrollPane = new JScrollPane(this.classTree);
        this.classTree.addMouseListener(this);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMXResources.getString("visibleClasses")));
        jPanel2.add(jScrollPane);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMXResources.getString("results")));
        this.resultsPane = new JTabbedPane();
        jPanel3.add(this.resultsPane);
        this.standardTreeRoot = new DefaultMutableTreeNode(JMXResources.getString("standardMBeans"));
        this.standardMBeanTree = new JTree(this.standardTreeRoot);
        jScrollPane = new JScrollPane(this.standardMBeanTree);
        this.standardMBeanTree.getSelectionModel().setSelectionMode(1);
        this.standardMBeanTree.addTreeSelectionListener(this.propertyViewer);
        ((DefaultTreeCellRenderer)this.standardMBeanTree.getCellRenderer()).setLeafIcon(this.standardIcon);
        this.resultsPane.addTab(JMXResources.getString("standard"), this.standardIcon, jScrollPane, JMXResources.getString("standardTooltip"));
        this.dynamicTreeRoot = new DefaultMutableTreeNode(JMXResources.getString("dynamicMBeans"));
        this.dynamicMBeanTree = new JTree(this.dynamicTreeRoot);
        jScrollPane = new JScrollPane(this.dynamicMBeanTree);
        this.dynamicMBeanTree.getSelectionModel().setSelectionMode(1);
        this.dynamicMBeanTree.addTreeSelectionListener(this.propertyViewer);
        ((DefaultTreeCellRenderer)this.dynamicMBeanTree.getCellRenderer()).setLeafIcon(this.dynamicIcon);
        this.resultsPane.addTab(JMXResources.getString("dynamic"), this.dynamicIcon, jScrollPane, JMXResources.getString("dynamicTooltip"));
        this.noncompliantTreeRoot = new DefaultMutableTreeNode(JMXResources.getString("noncompliantMBeans"));
        this.noncompliantMBeanTree = new JTree(this.noncompliantTreeRoot);
        jScrollPane = new JScrollPane(this.noncompliantMBeanTree);
        this.noncompliantMBeanTree.getSelectionModel().setSelectionMode(1);
        this.noncompliantMBeanTree.addTreeSelectionListener(this.propertyViewer);
        ((DefaultTreeCellRenderer)this.noncompliantMBeanTree.getCellRenderer()).setLeafIcon(this.noncompliantIcon);
        this.resultsPane.addTab(JMXResources.getString("noncompliant"), this.noncompliantIcon, jScrollPane, JMXResources.getString("noncompliantTooltip"));
        this.unresolvedTreeRoot = new DefaultMutableTreeNode(JMXResources.getString("unresolvedClasses"));
        this.unresolvedTree = new JTree(this.unresolvedTreeRoot);
        jScrollPane = new JScrollPane(this.unresolvedTree);
        this.unresolvedTree.getSelectionModel().setSelectionMode(1);
        this.unresolvedTree.addTreeSelectionListener(this.propertyViewer);
        ((DefaultTreeCellRenderer)this.unresolvedTree.getCellRenderer()).setLeafIcon(this.unresolvedIcon);
        this.resultsPane.addTab(JMXResources.getString("unresolved"), this.unresolvedIcon, jScrollPane, JMXResources.getString("unresolvedTooltip"));
        this.resultsPane.addChangeListener(this);
        jPanel2.add(jPanel3);
        this.getContentPane().add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createBevelBorder(1));
        JPanel jPanel5 = new JPanel(new GridLayout(1, 4));
        JPanel jPanel6 = new JPanel();
        String string = "000";
        jPanel6.setBorder(BorderFactory.createBevelBorder(1));
        jPanel6.add(new JLabel(String.valueOf(JMXResources.getString("standard")) + " :", 4));
        this.standardStatus = new JLabel(string, 2);
        jPanel6.add(this.standardStatus);
        jPanel5.add(jPanel6);
        jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createBevelBorder(1));
        jPanel6.add(new JLabel(String.valueOf(JMXResources.getString("dynamic")) + " :", 4));
        this.dynamicStatus = new JLabel(string, 2);
        jPanel6.add(this.dynamicStatus);
        jPanel5.add(jPanel6);
        jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createBevelBorder(1));
        jPanel6.add(new JLabel(String.valueOf(JMXResources.getString("noncompliant")) + " :", 4));
        this.noncompliantStatus = new JLabel(string, 2);
        jPanel6.add(this.noncompliantStatus);
        jPanel5.add(jPanel6);
        jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createBevelBorder(1));
        jPanel6.add(new JLabel(String.valueOf(JMXResources.getString("unresolved")) + " :", 4));
        this.unresolvedStatus = new JLabel(string, 2);
        jPanel6.add(this.unresolvedStatus);
        jPanel5.add(jPanel6);
        jPanel4.add((Component)jPanel5, "Center");
        jButton = new JButton(JMXResources.getString("checkSelected"), this.checkIcon);
        jPanel4.add((Component)jButton, "East");
        jButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel4, "South");
        this.pack();
        ((Component)this).setVisible(true);
        this.updateStatus();
    }

    private void shutDown() {
        System.exit(0);
    }

    private URL[] split(String string) {
        char c = File.pathSeparatorChar;
        Vector vector = new Vector();
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 != -1) {
            this.add(string.substring(n, n2), vector);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        if (n != string.length()) {
            this.add(string.substring(n), vector);
        }
        Object[] objectArray = new URL[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            Container container = (Container)((JTabbedPane)changeEvent.getSource()).getSelectedComponent();
            Container container2 = (Container)container.getComponent(0);
            JTree jTree = (JTree)container2.getComponent(0);
            TreePath treePath = jTree.getSelectionPath();
            jTree.removeSelectionPath(treePath);
            jTree.setSelectionPath(treePath);
        }
        catch (Exception exception) {
            System.out.println("Internal error 312 occurred :" + exception.toString());
        }
    }

    private String stripPackageInfo(String string) {
        if (string.indexOf(46) >= 0) {
            return string.substring(string.lastIndexOf(46) + 1, string.length());
        }
        return string;
    }

    private void updateStatus() {
        this.standardStatus.setText(Integer.toString(this.standardTreeRoot.getChildCount()));
        this.dynamicStatus.setText(Integer.toString(this.dynamicTreeRoot.getChildCount()));
        this.noncompliantStatus.setText(Integer.toString(this.noncompliantTreeRoot.getChildCount()));
        this.unresolvedStatus.setText(Integer.toString(this.unresolvedTreeRoot.getChildCount()));
    }

    private void waitMessage(String string) {
        if (this.waitDialog == null) {
            this.waitDialog = new JDialog(this, JMXResources.getString("waitMessage"), false);
            this.waitMessage = new JLabel(string);
            this.waitDialog.getContentPane().add(this.waitMessage);
            this.waitDialog.pack();
            ((Component)this.waitDialog).setSize(300, this.waitDialog.getSize().height);
            this.waitDialog.setLocationRelativeTo(this);
            ((Component)this.waitDialog).setVisible(true);
        } else {
            this.waitMessage.setText(string);
            this.waitDialog.setLocationRelativeTo(this);
            this.waitDialog.toFront();
            Graphics graphics = ((Component)this.waitDialog).getGraphics();
            this.waitDialog.update(graphics);
            graphics.dispose();
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.shutDown();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

