/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.util.Properties;

public class JMXPrintManager {
    private Graphics page;
    private PrintJob printJob;
    private Font printFont;
    private FontMetrics fm;
    private Color printColor;
    private int printXPos;
    private int printYPos;
    private int pageNumber = 0;
    private int pageWidth;
    private int pageHeight;
    private int fontHeight;
    private int fontDescent;
    private static final int INSET = 11;
    private boolean printBorder;
    private boolean wrapText;
    private String[] header;

    public JMXPrintManager(String string, Frame frame) {
        this.printJob = frame.getToolkit().getPrintJob(frame, string, new Properties());
        if (this.printJob != null) {
            this.printFont = new Font("Monospaced", 0, 8);
            this.printColor = Color.black;
            this.printBorder = false;
            this.wrapText = true;
            this.newPage();
        }
    }

    public void bold() {
        this.setStyle(1);
    }

    public void endPrint() {
        this.page.dispose();
        this.printJob.end();
    }

    public boolean getBorder() {
        return this.printBorder;
    }

    public Color getColor() {
        return this.printColor;
    }

    public Font getFont() {
        return this.printFont;
    }

    public Graphics getGraphics() {
        return this.page;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getStyle() {
        return this.getFont().getStyle();
    }

    public boolean getWrap() {
        return this.wrapText;
    }

    public void newLine() {
        this.printXPos = 0;
        this.printYPos += this.fontHeight;
    }

    public void newPage() {
        if (this.page != null) {
            this.page.dispose();
        }
        this.page = this.printJob.getGraphics();
        ++this.pageNumber;
        this.setFont(this.getFont());
        this.setColor(this.getColor());
        this.printXPos = 0;
        this.printYPos = 0;
        this.pageHeight = this.printJob.getPageDimension().height;
        this.pageWidth = this.printJob.getPageDimension().width;
        if (this.printBorder) {
            this.page.drawRect(11, 11, this.pageWidth - 24, this.pageHeight - 24);
        }
        this.newLine();
        this.printHeader();
    }

    public void plain() {
        this.setStyle(0);
    }

    public void print(int n, int n2, String string) {
        this.page.drawString(string, n, n2);
    }

    public void print(String string) {
        if (this.printYPos + this.fontHeight > this.pageHeight - 24) {
            this.newPage();
            this.print(string);
        } else if (this.wrapText && this.fm.stringWidth(string) > this.printXPos + this.pageWidth - 24) {
            int n = string.length();
            while (this.fm.stringWidth(string.substring(0, n)) > this.printXPos + this.pageWidth - 24) {
                --n;
            }
            this.print(string.substring(0, n));
            if (n != string.length()) {
                this.newLine();
                this.print(string.substring(n, string.length()));
            }
        } else {
            this.page.drawString(string, this.printXPos + 11, this.printYPos - this.fontDescent + 11);
            this.printXPos += this.fm.stringWidth(string);
        }
    }

    public void printHeader() {
        if (this.header == null) {
            return;
        }
        this.printLine('-');
        this.setStyle(1);
        String string = "Page " + this.pageNumber;
        int n = 0;
        while (n < this.header.length) {
            this.println(this.header[n]);
            ++n;
        }
        this.println(string);
        this.printLine('-');
        this.setStyle(0);
    }

    public void printLine(char c) {
        StringBuffer stringBuffer = new StringBuffer(c);
        do {
            stringBuffer.append(c);
        } while (this.fm.stringWidth(stringBuffer.toString()) < this.printXPos + this.pageWidth - 24);
        stringBuffer.setLength(stringBuffer.length() - 1);
        this.println(stringBuffer.toString());
    }

    public void println(String string) {
        this.print(string);
        this.newLine();
    }

    public void setBorder(boolean bl) {
        this.printBorder = bl;
    }

    public void setColor(Color color) {
        this.printColor = color;
        this.page.setColor(this.printColor);
    }

    public void setFont(Font font) {
        this.printFont = font;
        this.page.setFont(font);
        this.fm = this.page.getFontMetrics(this.printFont);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
    }

    public void setHeader(String[] stringArray) {
        this.header = stringArray;
    }

    public void setStyle(int n) {
        this.setFont(new Font(this.getFont().getName(), n, this.getFont().getSize()));
    }

    public void setWrap(boolean bl) {
        this.wrapText = bl;
    }

    public boolean startPrint() {
        return this.printJob != null;
    }
}

