/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class JMXPropertyViewer
extends JFrame
implements ActionListener,
TreeSelectionListener {
    private JTable exceptionTable;
    private Container lastPanel;
    private JLabel className;
    private JTabbedPane standardMBeanPanel;
    private JTable constructorsTable;
    private String[] constructorsTitles = new String[]{JMXResources.getString("constructorTitles")};
    private JTable operationsTable;
    private String[] operationsTitles = new String[]{JMXResources.getString("operations")};
    private JTable attributesTable;
    private String[] attributesTitles = new String[]{JMXResources.getString("attributeName"), JMXResources.getString("attributeType"), JMXResources.getString("attributeIsReadable"), JMXResources.getString("attributeIsWriteable")};
    private JLabel description;
    private JScrollPane dynamicMBeanPanel;
    private JTable dynamicConstructorsTable;
    private String[] dynamicConstructorsTitles = new String[]{JMXResources.getString("dynamicConstructors")};
    private JScrollPane exceptionPanel;
    private String[] exceptionTitles = new String[]{JMXResources.getString("exceptionException"), JMXResources.getString("exceptionMessage")};

    public JMXPropertyViewer() {
        super(JMXResources.getString("title"));
        this.getContentPane().setLayout(new BorderLayout());
        this.className = new JLabel("", 0);
        this.getContentPane().add((Component)this.className, "North");
        this.standardMBeanPanel = new JTabbedPane();
        this.constructorsTable = new JTable();
        this.standardMBeanPanel.add(JMXResources.getString("standardConstructors"), new JScrollPane(this.constructorsTable));
        ((DefaultTableModel)this.constructorsTable.getModel()).setColumnIdentifiers(this.constructorsTitles);
        this.operationsTable = new JTable();
        this.standardMBeanPanel.add(JMXResources.getString("standardOperations"), new JScrollPane(this.operationsTable));
        ((DefaultTableModel)this.operationsTable.getModel()).setColumnIdentifiers(this.operationsTitles);
        this.attributesTable = new JTable();
        this.standardMBeanPanel.add(JMXResources.getString("standardAttributes"), new JScrollPane(this.attributesTable));
        ((DefaultTableModel)this.attributesTable.getModel()).setColumnIdentifiers(this.attributesTitles);
        this.description = new JLabel("", 0);
        this.standardMBeanPanel.add(JMXResources.getString("standardDescription"), this.description);
        this.dynamicConstructorsTable = new JTable();
        this.dynamicMBeanPanel = new JScrollPane(this.dynamicConstructorsTable);
        ((DefaultTableModel)this.dynamicConstructorsTable.getModel()).setColumnIdentifiers(this.dynamicConstructorsTitles);
        this.exceptionTable = new JTable();
        ((DefaultTableModel)this.exceptionTable.getModel()).setColumnIdentifiers(this.exceptionTitles);
        this.exceptionPanel = new JScrollPane(this.exceptionTable);
        this.lastPanel = this.exceptionPanel;
        this.getContentPane().add((Component)this.lastPanel, "Center");
        JButton jButton = new JButton(JMXResources.getString("close"));
        this.getContentPane().add((Component)jButton, "South");
        jButton.addActionListener(this);
        this.pack();
        ((Component)this).setSize(480, 180);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton && ((JButton)actionEvent.getSource()).getText().equals(JMXResources.getString("close"))) {
            ((Component)this).setVisible(false);
            return;
        }
    }

    private void displayDynamicMBean(JMXResult jMXResult) {
        MBeanConstructorInfo[] mBeanConstructorInfoArray = (MBeanConstructorInfo[])jMXResult.getResult();
        this.emptyTable(this.dynamicConstructorsTable);
        Object[] objectArray = new Object[this.dynamicConstructorsTitles.length];
        int n = 0;
        while (n < mBeanConstructorInfoArray.length) {
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanConstructorInfoArray[n].getSignature();
            String string = "";
            int n2 = 0;
            while (n2 < mBeanParameterInfoArray.length) {
                string = String.valueOf(string) + mBeanParameterInfoArray[n2].getType() + " ";
                ++n2;
            }
            objectArray[0] = String.valueOf(mBeanConstructorInfoArray[n].getName()) + "( " + string + " )";
            ((DefaultTableModel)this.dynamicConstructorsTable.getModel()).addRow(objectArray);
            ++n;
        }
        this.updatePanel(this.dynamicMBeanPanel);
    }

    private void displayStandardMBean(JMXResult jMXResult) {
        MBeanFeatureInfo[] mBeanFeatureInfoArray;
        MBeanInfo mBeanInfo = (MBeanInfo)jMXResult.getResult();
        this.description.setText(mBeanInfo.getDescription());
        this.emptyTable(this.constructorsTable);
        Object[] objectArray = new Object[this.constructorsTitles.length];
        MBeanConstructorInfo[] mBeanConstructorInfoArray = mBeanInfo.getConstructors();
        int n = 0;
        while (n < mBeanConstructorInfoArray.length) {
            mBeanFeatureInfoArray = mBeanConstructorInfoArray[n].getSignature();
            String string = "";
            int n2 = 0;
            while (n2 < mBeanFeatureInfoArray.length) {
                string = String.valueOf(string) + ((MBeanParameterInfo)mBeanFeatureInfoArray[n2]).getType() + " ";
                ++n2;
            }
            objectArray[0] = String.valueOf(mBeanConstructorInfoArray[n].getName()) + "( " + string + " )";
            ((DefaultTableModel)this.constructorsTable.getModel()).addRow(objectArray);
            ++n;
        }
        this.emptyTable(this.operationsTable);
        mBeanFeatureInfoArray = mBeanInfo.getOperations();
        int n3 = 0;
        while (n3 < mBeanFeatureInfoArray.length) {
            MBeanParameterInfo[] mBeanParameterInfoArray = ((MBeanOperationInfo)mBeanFeatureInfoArray[n3]).getSignature();
            String string = "";
            int n4 = 0;
            while (n4 < mBeanParameterInfoArray.length) {
                string = String.valueOf(string) + mBeanParameterInfoArray[n4].getType() + " ";
                ++n4;
            }
            objectArray[0] = String.valueOf(((MBeanOperationInfo)mBeanFeatureInfoArray[n3]).getReturnType()) + " " + mBeanFeatureInfoArray[n3].getName() + "( " + string + " )";
            ((DefaultTableModel)this.operationsTable.getModel()).addRow(objectArray);
            ++n3;
        }
        if (mBeanFeatureInfoArray.length == 0) {
            objectArray[0] = JMXResources.getString("noOperations");
            ((DefaultTableModel)this.operationsTable.getModel()).addRow(objectArray);
        }
        this.emptyTable(this.attributesTable);
        objectArray = new Object[this.attributesTitles.length];
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        int n5 = 0;
        while (n5 < mBeanAttributeInfoArray.length) {
            objectArray[0] = mBeanAttributeInfoArray[n5].getName();
            objectArray[1] = mBeanAttributeInfoArray[n5].getType();
            objectArray[2] = new Boolean(mBeanAttributeInfoArray[n5].isReadable());
            objectArray[3] = new Boolean(mBeanAttributeInfoArray[n5].isWritable());
            ((DefaultTableModel)this.attributesTable.getModel()).addRow(objectArray);
            ++n5;
        }
        if (mBeanAttributeInfoArray.length == 0) {
            objectArray[0] = JMXResources.getString("noAttributes");
            ((DefaultTableModel)this.attributesTable.getModel()).addRow(objectArray);
        }
        this.updatePanel(this.standardMBeanPanel);
    }

    private void displayThrowable(JMXResult jMXResult) {
        this.emptyTable(this.exceptionTable);
        Object[] objectArray = new Object[3];
        objectArray[0] = jMXResult.getResult().getClass();
        objectArray[1] = ((Throwable)jMXResult.getResult()).getMessage();
        ((DefaultTableModel)this.exceptionTable.getModel()).addRow(objectArray);
        this.updatePanel(this.exceptionPanel);
    }

    private void emptyTable(JTable jTable) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)jTable.getModel();
        while (defaultTableModel.getRowCount() > 0) {
            defaultTableModel.removeRow(0);
        }
    }

    public void setResult(JMXResult jMXResult) {
        this.className.setText(jMXResult.toString());
        if (jMXResult.getResult() instanceof Throwable) {
            this.displayThrowable(jMXResult);
            return;
        }
        if (jMXResult.getResult() instanceof MBeanInfo) {
            this.displayStandardMBean(jMXResult);
            return;
        }
        if (jMXResult.getResult() instanceof MBeanConstructorInfo[]) {
            this.displayDynamicMBean(jMXResult);
            return;
        }
        System.out.println("Internal error 1 - unexpected introspection result : " + jMXResult.getResult());
    }

    private void updatePanel(Container container) {
        this.invalidate();
        if (this.lastPanel != container) {
            this.getContentPane().remove(this.lastPanel);
            this.lastPanel = container;
            this.getContentPane().add((Component)this.lastPanel, "Center");
        }
        this.validate();
        this.validateTree();
        this.repaint();
        if (!this.isVisible()) {
            ((Component)this).setVisible(true);
        } else {
            this.toFront();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
        try {
            this.setResult((JMXResult)defaultMutableTreeNode.getUserObject());
        }
        catch (Throwable throwable) {}
    }
}

