/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Message;

public abstract class AbstractTask
extends AbstractPoolable
implements Runnable {
    protected Message message_;
    private TaskProcessor taskProcessor_;
    private TaskExecutor executor_;

    protected AbstractTask(TaskProcessor taskProcessor) {
        this.taskProcessor_ = taskProcessor;
    }

    protected TaskExecutor getTaskExecutor() {
        return this.executor_;
    }

    protected void setTaskExecutor(TaskExecutor taskExecutor) {
        this.executor_ = taskExecutor;
    }

    protected TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }

    public void setMessage(Message message) {
        if (this.message_ != null) {
            throw new RuntimeException("remove old first");
        }
        this.message_ = message;
    }

    public Message removeMessage() {
        Message message = this.message_;
        this.message_ = null;
        return message;
    }

    public Message copyMessage() {
        return (Message)this.message_.clone();
    }

    public abstract void doWork() throws Exception;

    public void run() {
        try {
            if (this.message_ == null || !this.isMessageInvalid()) {
                this.doWork();
            } else if (this.isMessageInvalid()) {
                this.dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            this.handleTaskError(this, throwable);
        }
    }

    abstract void handleTaskError(AbstractTask var1, Throwable var2);

    public void reset() {
        this.message_ = null;
    }

    private boolean isMessageInvalid() {
        return this.message_ != null && this.message_.isInvalid();
    }

    protected void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted() || this.message_.isInvalid()) {
            throw new InterruptedException();
        }
    }

    protected void schedule(boolean bl) throws InterruptedException {
        if (bl) {
            this.run();
        } else {
            this.executor_.execute(this);
        }
    }

    protected void schedule(TaskExecutor taskExecutor, boolean bl) throws InterruptedException {
        if (bl) {
            this.run();
        } else {
            taskExecutor.execute(this);
        }
    }

    public abstract void schedule() throws InterruptedException;
}

