/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class FilterProxySupplierTask
extends AbstractFilterTask {
    public static final AlternateMessageMap EMPTY_MAP = new AlternateMessageMap(Collections.EMPTY_MAP){

        public void clear() {
        }
    };
    AlternateMessageMap changedMessages_ = new AlternateMessageMap();
    private static int COUNT = 0;
    private int id_ = ++COUNT;

    FilterProxySupplierTask(TaskExecutor taskExecutor, TaskProcessor taskProcessor, TaskFactory taskFactory) {
        super(taskExecutor, taskProcessor, taskFactory);
    }

    public String toString() {
        return "[FilterProxySupplierTask#" + this.id_ + "]";
    }

    public void setFilterStage(AbstractFilterTask abstractFilterTask) {
        this.arrayCurrentFilterStage_ = abstractFilterTask.getFilterStageToBeProcessed();
    }

    public void reset() {
        super.reset();
        this.arrayCurrentFilterStage_ = null;
        this.changedMessages_.clear();
    }

    public void doWork() throws InterruptedException {
        this.filter();
        AbstractDeliverTask.scheduleTasks(this.getTaskFactory().newPushToConsumerTask(this));
        this.dispose();
    }

    private Message updatePriority(int n, Message message) {
        AnyHolder anyHolder = new AnyHolder();
        Message message2 = message;
        try {
            boolean bl = message.match(this.arrayCurrentFilterStage_[n].getPriorityFilter(), anyHolder);
            if (bl) {
                message2 = (Message)this.message_.clone();
                message2.setPriority(anyHolder.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData unsupportedFilterableData) {
            // empty catch block
        }
        return message2;
    }

    private Message updateTimeout(int n, Message message) {
        AnyHolder anyHolder = new AnyHolder();
        Message message2 = message;
        try {
            boolean bl = message2.match(this.arrayCurrentFilterStage_[n].getLifetimeFilter(), anyHolder);
            if (bl && message2 == this.message_) {
                message2 = (Message)this.message_.clone();
                message2.setTimeout(anyHolder.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData unsupportedFilterableData) {
            // empty catch block
        }
        return message2;
    }

    private void filter() {
        for (int i = 0; i < this.arrayCurrentFilterStage_.length; ++i) {
            boolean bl = false;
            if (!this.arrayCurrentFilterStage_[i].isDisposed()) {
                Message message = this.message_;
                if (this.arrayCurrentFilterStage_[i].hasPriorityFilter()) {
                    message = this.updatePriority(i, message);
                }
                if (this.arrayCurrentFilterStage_[i].hasLifetimeFilter()) {
                    message = this.updateTimeout(i, message);
                }
                if (message != this.message_) {
                    this.changedMessages_.putAlternateMessage(this.arrayCurrentFilterStage_[i], message);
                }
                bl = message.match(this.arrayCurrentFilterStage_[i]);
            }
            if (!bl) continue;
            this.addFilterStage(this.arrayCurrentFilterStage_[i].getSubsequentFilterStages());
        }
    }

    static class AlternateMessageMap {
        private Map alternateMessages_;

        public AlternateMessageMap() {
            this(new HashMap());
        }

        AlternateMessageMap(Map map) {
            this.alternateMessages_ = map;
        }

        public Message getAlternateMessage(FilterStage filterStage) {
            if (this.alternateMessages_.containsKey(filterStage)) {
                return (Message)this.alternateMessages_.get(filterStage);
            }
            return null;
        }

        public void putAlternateMessage(FilterStage filterStage, Message message) {
            this.alternateMessages_.put(filterStage, message);
        }

        public void clear() {
            this.alternateMessages_.clear();
        }
    }
}

