/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Date;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxyConsumerTask;
import org.jacorb.notification.engine.PullFromSupplierTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TimerDeliverTask;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.omg.CORBA.Any;
import org.omg.CosNotification.StructuredEvent;

public class TaskProcessor
implements Disposable,
Configurable {
    private Logger logger_ = null;
    private TaskExecutor matchTaskExecutor_;
    private TaskExecutor pushTaskExecutor_;
    private TaskExecutor pullTaskExecutor_;
    private ClockDaemon clockDaemon_ = new ClockDaemon();
    private TaskFactory taskFactory_;
    private long backoutInterval_;

    public TaskProcessor() {
        this.clockDaemon_.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("ClockDaemonThread");
                return thread;
            }
        });
    }

    public void configure(Configuration configuration) {
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.logger_.info("create TaskProcessor");
        int n = configuration.getAttributeAsInteger("jacorb.notification.proxyconsumer.thread_pool_size", 2);
        this.pullTaskExecutor_ = new TaskExecutor("PullThread", n);
        n = configuration.getAttributeAsInteger("jacorb.notification.filter.thread_pool_size", 2);
        this.matchTaskExecutor_ = new TaskExecutor("FilterThread", n);
        this.backoutInterval_ = configuration.getAttributeAsInteger("jacorb.notification.consumer.backout_interval", 2000);
        n = configuration.getAttributeAsInteger("jacorb.notification.proxysupplier.thread_pool_size", 4);
        String string = configuration.getAttribute("jacorb.notification.proxysupplier.threadpolicy", "ThreadPool");
        if ("ThreadPool".equals(string)) {
            this.pushTaskExecutor_ = new TaskExecutor("DeliverThread", n);
        } else if ("ThreadPerProxy".equals(string)) {
            this.pushTaskExecutor_ = null;
        } else {
            throw new IllegalArgumentException("The specified value: \"" + string + "\" specified in property: \"" + "jacorb.notification.proxysupplier.threadpolicy" + "\" is invalid");
        }
        this.taskFactory_ = new TaskFactory(this);
        this.taskFactory_.configure(configuration);
    }

    public TaskFactory getTaskFactory() {
        return this.taskFactory_;
    }

    public long getBackoutInterval() {
        return this.backoutInterval_;
    }

    public void configureTaskExecutor(AbstractProxySupplier abstractProxySupplier) {
        if (this.pushTaskExecutor_ != null) {
            abstractProxySupplier.setTaskExecutor(this.pushTaskExecutor_);
        } else {
            final TaskExecutor taskExecutor = new TaskExecutor("PerProxyDeliverThread", 1);
            Disposable disposable = new Disposable(){

                public void dispose() {
                    taskExecutor.dispose();
                }
            };
            abstractProxySupplier.setTaskExecutor(taskExecutor, disposable);
        }
    }

    TaskExecutor getFilterTaskExecutor() {
        return this.matchTaskExecutor_;
    }

    public void dispose() {
        this.logger_.info("shutdown TaskProcessor");
        this.clockDaemon_.shutDown();
        this.matchTaskExecutor_.dispose();
        if (this.pushTaskExecutor_ != null) {
            this.pushTaskExecutor_.dispose();
        }
        this.pullTaskExecutor_.dispose();
        this.taskFactory_.dispose();
        this.logger_.debug("shutdown complete");
    }

    public void processMessage(Message message) {
        if (message.hasStopTime()) {
            this.logger_.debug("Message has StopTime");
            if (message.getStopTime().getTime() <= System.currentTimeMillis()) {
                this.fireEventDiscarded(message);
                message.dispose();
                this.logger_.debug("Message Stoptime is passed already");
                return;
            }
            new DeferedStopTask(message);
        }
        if (message.hasTimeout()) {
            this.logger_.debug("Message has TimeOut");
            new TimeoutTask(message);
        }
        if (message.hasStartTime() && message.getStartTime().getTime() > System.currentTimeMillis()) {
            new DeferedStartTask(message);
        } else {
            this.processMessageInternal(message);
        }
    }

    protected void processMessageInternal(Message message) {
        this.logger_.debug("processMessageInternal");
        FilterProxyConsumerTask filterProxyConsumerTask = this.taskFactory_.newFilterProxyConsumerTask(message);
        try {
            ((AbstractFilterTask)filterProxyConsumerTask).schedule();
        }
        catch (InterruptedException interruptedException) {
            this.logger_.error("Interrupt while scheduling FilterTask", (Throwable)interruptedException);
        }
        catch (Throwable throwable) {
            this.logger_.error("Something else in PMI ", throwable);
        }
    }

    public void scheduleTimedPullTask(MessageSupplier messageSupplier) throws InterruptedException {
        PullFromSupplierTask pullFromSupplierTask = new PullFromSupplierTask(this.pullTaskExecutor_);
        pullFromSupplierTask.setTarget(messageSupplier);
        pullFromSupplierTask.schedule();
    }

    public void scheduleTimedPushTask(MessageConsumer messageConsumer) throws InterruptedException {
        if (!messageConsumer.isDisposed()) {
            TimerDeliverTask timerDeliverTask = new TimerDeliverTask(this);
            timerDeliverTask.setMessageConsumer(messageConsumer);
            timerDeliverTask.schedule();
        } else {
            this.logger_.info("MessageConsumer is disposed");
        }
    }

    private ClockDaemon getClockDaemon() {
        return this.clockDaemon_;
    }

    public Object executeTaskPeriodically(long l, Runnable runnable, boolean bl) {
        this.logger_.debug("executeTaskPeriodically");
        return this.getClockDaemon().executePeriodically(l, runnable, bl);
    }

    public void cancelTask(Object object) {
        ClockDaemon.cancel((Object)object);
    }

    Object executeTaskAfterDelay(long l, Runnable runnable) {
        return this.clockDaemon_.executeAfterDelay(l, runnable);
    }

    Object executeTaskAt(Date date, Runnable runnable) {
        return this.clockDaemon_.executeAt(date, runnable);
    }

    private void fireEventDiscarded(Message message) {
        switch (message.getType()) {
            case 0: {
                this.fireEventDiscarded(message.toAny());
                break;
            }
            case 1: {
                this.fireEventDiscarded(message.toStructuredEvent());
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void fireEventDiscarded(Any any) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("Any: " + any + " has been discarded");
        }
    }

    private void fireEventDiscarded(StructuredEvent structuredEvent) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("StructuredEvent: " + structuredEvent + " has been discarded");
        }
    }

    class DeferedStartTask
    implements Runnable {
        Message message_;

        DeferedStartTask(Message message) {
            if (TaskProcessor.this.logger_.isDebugEnabled()) {
                TaskProcessor.this.logger_.debug("Message with Option StartTime=" + message.getStartTime() + " will be defered until then");
            }
            this.message_ = message;
            TaskProcessor.this.executeTaskAt(this.message_.getStartTime(), this);
        }

        public void run() {
            if (TaskProcessor.this.logger_.isDebugEnabled()) {
                TaskProcessor.this.logger_.debug("Defered Message " + this.message_ + " will be processed now");
            }
            TaskProcessor.this.processMessageInternal(this.message_);
        }
    }

    class DeferedStopTask
    implements Runnable {
        Message event_;

        DeferedStopTask(Message message) {
            this.event_ = message;
            TaskProcessor.this.executeTaskAt(message.getStopTime(), this);
        }

        public void run() {
            this.event_.actionTimeout();
        }
    }

    class TimeoutTask
    implements Runnable,
    Message.MessageStateListener {
        Object timerRegistration_;
        Message message_;

        TimeoutTask(Message message) {
            this.message_ = message;
            this.message_.setMessageStateListener(this);
            this.timerRegistration_ = TaskProcessor.this.executeTaskAfterDelay(message.getTimeout(), this);
        }

        public void actionLifetimeChanged(long l) {
            ClockDaemon.cancel((Object)this.timerRegistration_);
            this.timerRegistration_ = TaskProcessor.this.executeTaskAfterDelay(this.message_.getTimeout(), this);
        }

        public void run() {
            TaskProcessor.this.logger_.debug("run Timeout");
            this.message_.removeMessageStateListener();
            this.message_.actionTimeout();
        }
    }
}

