/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractObjectPool
implements Runnable,
Configurable {
    public static final boolean DEBUG = false;
    public static final long SLEEP = 100L;
    public static final int LOWER_WATERMARK_DEFAULT = 30;
    public static final int SIZE_INCREASE_DEFAULT = 30;
    public static final int INITIAL_SIZE_DEFAULT = 100;
    public static final int MAXIMUM_WATERMARK_DEFAULT = 1000;
    static List sPoolsToLookAfter = new LinkedList();
    static Thread sCleanerThread;
    static ListCleaner sListCleaner;
    String name_;
    LinkedList pool_;
    HashSet active_ = new HashSet();
    int instanceCount_;
    int lendCount_;
    int returnCount_;
    int lowerWatermark_;
    int maxWatermark_;
    int sizeIncrease_;
    int initialSize_;
    protected Logger logger_;
    private Configuration config_;
    static /* synthetic */ Class class$org$jacorb$notification$util$AbstractObjectPool;

    static synchronized void registerPool(AbstractObjectPool abstractObjectPool) {
        sPoolsToLookAfter.add(abstractObjectPool);
        AbstractObjectPool.startListCleaner();
    }

    public static synchronized void deregisterPool(AbstractObjectPool abstractObjectPool) {
        sPoolsToLookAfter.remove(abstractObjectPool);
        if (sPoolsToLookAfter.isEmpty()) {
            AbstractObjectPool.stopListCleaner();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ListCleaner getListCleaner() {
        if (sListCleaner == null) {
            Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
            synchronized (clazz) {
                if (sListCleaner == null) {
                    sListCleaner = new ListCleaner();
                }
            }
        }
        return sListCleaner;
    }

    static void stopListCleaner() {
        if (sCleanerThread != null) {
            sListCleaner.setInactive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void startListCleaner() {
        if (sCleanerThread == null) {
            Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
            synchronized (clazz) {
                if (sCleanerThread == null) {
                    sCleanerThread = new Thread(AbstractObjectPool.getListCleaner());
                    sCleanerThread.setName("ObjectPoolCleaner");
                    sCleanerThread.setPriority(2);
                    sCleanerThread.setDaemon(true);
                    sCleanerThread.start();
                }
            }
        }
    }

    public void configure(Configuration configuration) {
        this.config_ = configuration;
        this.logger_ = ((org.jacorb.config.Configuration)configuration).getNamedLogger(this.getClass().getName());
        this.init();
    }

    protected AbstractObjectPool(String string) {
        this(string, 30, 30, 100, 1000);
    }

    protected AbstractObjectPool(String string, int n, int n2, int n3, int n4) {
        this.name_ = string;
        this.pool_ = new LinkedList();
        this.lowerWatermark_ = n;
        this.sizeIncrease_ = n2;
        this.initialSize_ = n3;
        this.maxWatermark_ = n4;
        AbstractObjectPool.registerPool(this);
    }

    public void run() {
        if (this.pool_.size() < this.lowerWatermark_) {
            for (int i = 0; i < this.sizeIncrease_; ++i) {
                Object object = this.newInstance();
                try {
                    ((Configurable)object).configure(this.config_);
                }
                catch (ClassCastException classCastException) {
                }
                catch (ConfigurationException configurationException) {
                    // empty catch block
                }
                ++this.instanceCount_;
                this.pool_.add(object);
            }
        }
    }

    public void init() {
        for (int i = 0; i < this.initialSize_; ++i) {
            Object object = this.newInstance();
            try {
                ((Configurable)object).configure(this.config_);
            }
            catch (ClassCastException classCastException) {
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            ++this.instanceCount_;
            this.pool_.add(object);
        }
    }

    public void dispose() {
        AbstractObjectPool.deregisterPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lendObject() {
        Object object = null;
        if (!this.pool_.isEmpty()) {
            LinkedList linkedList = this.pool_;
            synchronized (linkedList) {
                if (!this.pool_.isEmpty()) {
                    object = this.pool_.removeFirst();
                }
            }
        }
        if (object == null) {
            ++this.instanceCount_;
            object = this.newInstance();
        }
        this.activateObject(object);
        this.active_.add(object);
        ++this.lendCount_;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) {
        ++this.returnCount_;
        if (this.active_.remove(object)) {
            this.passivateObject(object);
            if (this.pool_.size() < this.maxWatermark_) {
                LinkedList linkedList = this.pool_;
                synchronized (linkedList) {
                    this.pool_.add(object);
                    this.pool_.notifyAll();
                }
            } else {
                this.destroyObject(object);
            }
        }
    }

    public abstract Object newInstance();

    public void passivateObject(Object object) {
    }

    public void activateObject(Object object) {
    }

    public void destroyObject(Object object) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ListCleaner
    extends Thread {
        boolean active_ = true;

        ListCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInactive() {
            this.active_ = false;
            this.interrupt();
            Class clazz = class$org$jacorb$notification$util$AbstractObjectPool == null ? (class$org$jacorb$notification$util$AbstractObjectPool = AbstractObjectPool.class$("org.jacorb.notification.util.AbstractObjectPool")) : class$org$jacorb$notification$util$AbstractObjectPool;
            synchronized (clazz) {
                sCleanerThread = null;
            }
        }

        public void run() {
            while (this.active_) {
                block7: {
                    try {
                        ListCleaner.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.active_) break block7;
                        return;
                    }
                }
                try {
                    for (int i = sPoolsToLookAfter.size(); i <= 0; --i) {
                        if (!this.active_) {
                            return;
                        }
                        ((Runnable)sPoolsToLookAfter.get(i)).run();
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

