/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.applet.Applet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.imr.ImRAccessImpl;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.BasicAdapter;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.NVList;
import org.jacorb.orb.NamedValue;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.TaggedComponentList;
import org.jacorb.orb.dii.ExceptionList;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.dynany.DynAnyFactoryImpl;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.policies.MaxHopsPolicy;
import org.jacorb.orb.policies.PolicyManager;
import org.jacorb.orb.policies.QueueOrderPolicy;
import org.jacorb.orb.policies.RebindPolicy;
import org.jacorb.orb.policies.RelativeRequestTimeoutPolicy;
import org.jacorb.orb.policies.RelativeRoundtripTimeoutPolicy;
import org.jacorb.orb.policies.ReplyEndTimePolicy;
import org.jacorb.orb.policies.ReplyPriorityPolicy;
import org.jacorb.orb.policies.ReplyStartTimePolicy;
import org.jacorb.orb.policies.RequestEndTimePolicy;
import org.jacorb.orb.policies.RequestPriorityPolicy;
import org.jacorb.orb.policies.RequestStartTimePolicy;
import org.jacorb.orb.policies.RoutingPolicy;
import org.jacorb.orb.policies.SyncScopePolicy;
import org.jacorb.orb.portableInterceptor.CodecFactoryImpl;
import org.jacorb.orb.portableInterceptor.IORInfoImpl;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.POAListener;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_QOS;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.Environment;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDef;
import org.omg.CORBA.ParameterDescription;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.ServiceInformationHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.MultipleComponentProfileHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHolder;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.Servant;
import org.omg.SecurityLevel2.Current;

public final class ORB
extends ORBSingleton
implements POAListener,
Configurable {
    private static final String versionString = "2.2 (JBoss patch 3)";
    private static final String dateString = "06-Oct-2004";
    private static final String nullIORString = "IOR:00000000000000010000000000000000";
    private org.jacorb.config.Configuration configuration = null;
    private boolean cacheReferences;
    private String implName;
    private int giopMinorVersion;
    private boolean giopAdd_1_0_Profiles;
    private String hashTableClassName;
    private boolean useIMR;
    private boolean useIMREndpoint;
    private String imrProxyHost = null;
    private int imrProxyPort = -1;
    private String iorProxyHost;
    private int iorProxyPort = -1;
    private boolean printVersion = true;
    private Map initial_references = new HashMap();
    private org.jacorb.poa.POA rootpoa;
    private org.jacorb.poa.Current poaCurrent;
    private BasicAdapter basicAdapter;
    private Current securityCurrent = null;
    private InterceptorManager interceptor_manager = null;
    private boolean hasClientInterceptors = false;
    private boolean hasServerInterceptors = false;
    private org.omg.PortableInterceptor.Current piCurrent = new PICurrent();
    private Map knownReferences = null;
    private ClientConnectionManager clientConnectionManager;
    private TransportManager transport_manager = null;
    private GIOPConnectionManager giop_connection_manager = null;
    private BufferManager bufferManager;
    protected Map valueFactories = new HashMap();
    protected Map boxedValueHelpers = new HashMap();
    private Map objectKeyMap = new HashMap();
    private Properties _props;
    private Logger logger;
    public String[] _args;
    public Applet applet;
    private java.lang.Object orb_synch = new java.lang.Object();
    private boolean run = true;
    private boolean wait = true;
    private boolean shutdown_in_progress = false;
    private boolean destroyed = false;
    private java.lang.Object shutdown_synch = new java.lang.Object();
    private ImRAccess imr = null;
    private int persistentPOACount;
    public static final String orb_id = "jacorb:2.2 (JBoss patch 3)";
    private Set requests = Collections.synchronizedSet(new HashSet());
    private Request request = null;
    private PolicyManager policyManager = null;
    private Map policy_factories = null;
    private static TCKind kind;
    private static final String[] services;
    private boolean bidir_giop = false;
    private boolean firstConnection = true;
    private Map connectedObjects = new HashMap();
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$org$apache$avalon$framework$configuration$Configuration;
    static /* synthetic */ Class class$org$omg$CORBA$portable$ValueFactory;

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb");
        this.cacheReferences = this.configuration.getAttribute("jacorb.reference_caching", "off").equals("on");
        this.implName = this.configuration.getAttribute("jacorb.implname", "");
        this.giopMinorVersion = this.configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
        this.giopAdd_1_0_Profiles = this.configuration.getAttribute("jacorb.giop.add_1_0_profiles", "off").equals("on");
        this.hashTableClassName = this.configuration.getAttribute("jacorb.hashtable_class", "");
        this.useIMR = this.configuration.getAttribute("jacorb.use_imr", "off").equals("on");
        this.imrProxyHost = this.configuration.getAttribute("jacorb.imr.ior_proxy_host", null);
        this.imrProxyPort = this.configuration.getAttributeAsInteger("jacorb.imr.ior_proxy_port", -1);
        this.useIMREndpoint = this.configuration.getAttribute("jacorb.use_imr", "on").equals("on");
        this.iorProxyHost = this.configuration.getAttribute("jacorb.ior_proxy_host", null);
        this.iorProxyPort = this.configuration.getAttributeAsInteger("jacorb.ior_proxy_port", -1);
        this.printVersion = this.configuration.getAttribute("jacorb.orb.print_version", "on").equals("on");
        if (this.printVersion && this.logger.isInfoEnabled()) {
            this.logger.info("\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\tJacORB V 2.2 (JBoss patch 3), www.jacorb.org\n\t(C) Gerald Brose, XTRADYNE Technologies/FU Berlin, 06-Oct-2004\n\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
        BufferManager.configure((Configuration)this.configuration);
        try {
            this.bufferManager = BufferManager.getInstance();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            bAD_INV_ORDER.printStackTrace();
        }
        this.configureObjectKeyMap((Configuration)this.configuration);
    }

    public org.jacorb.config.Configuration getConfiguration() {
        return this.configuration;
    }

    public String id() {
        return orb_id;
    }

    public boolean useBiDirGIOP() {
        return this.bidir_giop;
    }

    public void turnOnBiDirGIOP() {
        if (!this.bidir_giop) {
            this.bidir_giop = true;
            this.clientConnectionManager.setRequestListener(this.basicAdapter.getRequestListener());
        }
    }

    public synchronized Object _getObject(ParsedIOR parsedIOR) {
        Delegate delegate;
        ObjectImpl objectImpl;
        String string;
        block12: {
            string = parsedIOR.getIORString();
            objectImpl = (ObjectImpl)this.knownReferences.get(string);
            if (objectImpl != null) {
                delegate = (Delegate)objectImpl._get_delegate();
                if (delegate != null) {
                    ParsedIOR parsedIOR2 = delegate.getParsedIOR();
                    if (parsedIOR2 == null) {
                        this.knownReferences.remove(string);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Removing an invalid reference from cache.");
                        }
                    } else if (parsedIOR.getEffectiveProfile().is_match(parsedIOR2.getEffectiveProfile())) {
                        return objectImpl._duplicate();
                    }
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Remove stale reference from cache ");
                    }
                    this.knownReferences.remove(string);
                }
            }
            if (parsedIOR == null && this.logger.isErrorEnabled()) {
                this.logger.error("Internal error, pior is null");
            }
            delegate = new Delegate(this, parsedIOR);
            try {
                delegate.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isErrorEnabled()) break block12;
                this.logger.error("ConfigurationException", (Throwable)configurationException);
            }
        }
        objectImpl = delegate.getReference(null);
        if (this.cacheReferences) {
            this.knownReferences.put(string, objectImpl);
        }
        return objectImpl;
    }

    org.jacorb.poa.POA findPOA(Delegate delegate, Object object) {
        String string = null;
        if (this.rootpoa == null || this.basicAdapter == null) {
            return null;
        }
        try {
            string = POAUtil.extractImplName(delegate.getObjectKey());
        }
        catch (POAInternalError pOAInternalError) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: reference generated by foreign POA");
            }
            return null;
        }
        if (string == null) {
            if (this.implName.length() > 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: impl_name mismatch");
                }
                return null;
            }
        } else if (!this.implName.equals(string)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: impl_name mismatch");
            }
            return null;
        }
        try {
            String string2;
            org.jacorb.poa.POA pOA = this.rootpoa;
            String string3 = POAUtil.extractPOAName(delegate.getObjectKey());
            List list = POAUtil.extractScopedPOANames(string3);
            for (int i = 0; i < list.size() && !(string2 = (String)list.get(i)).equals(""); ++i) {
                try {
                    pOA = pOA._getChildPOA(string2);
                    continue;
                }
                catch (ParentIsHolding parentIsHolding) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("findPOA: holding adapter");
                    }
                    return null;
                }
            }
            byte[] byArray = POAUtil.extractOID(object);
            if (pOA.isSystemId() && !pOA.previouslyGeneratedObjectId(byArray)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("findPOA: not a previously generated object key.");
                }
                return null;
            }
            return pOA;
        }
        catch (Exception exception) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(exception.getMessage());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("findPOA: nothing found");
            }
            return null;
        }
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public GIOPConnectionManager getGIOPConnectionManager() {
        if (this.giop_connection_manager == null) {
            this.giop_connection_manager = new GIOPConnectionManager();
            try {
                this.giop_connection_manager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INTERNAL(configurationException.getMessage());
            }
        }
        return this.giop_connection_manager;
    }

    synchronized void _release(String string) {
        this.knownReferences.remove(string);
    }

    public Policy create_policy(int n, Any any) throws PolicyError {
        switch (n) {
            case 34: {
                return new MaxHopsPolicy(any);
            }
            case 35: {
                return new QueueOrderPolicy(any);
            }
            case 23: {
                return new RebindPolicy(any);
            }
            case 31: {
                return new RelativeRequestTimeoutPolicy(any);
            }
            case 32: {
                return new RelativeRoundtripTimeoutPolicy(any);
            }
            case 30: {
                return new ReplyEndTimePolicy(any);
            }
            case 26: {
                return new ReplyPriorityPolicy(any);
            }
            case 29: {
                return new ReplyStartTimePolicy(any);
            }
            case 28: {
                return new RequestEndTimePolicy(any);
            }
            case 25: {
                return new RequestPriorityPolicy(any);
            }
            case 27: {
                return new RequestStartTimePolicy(any);
            }
            case 33: {
                return new RoutingPolicy(any);
            }
            case 24: {
                return new SyncScopePolicy(any);
            }
        }
        Integer n2 = new Integer(n);
        if (this.policy_factories == null || !this.policy_factories.containsKey(n2)) {
            throw new PolicyError();
        }
        PolicyFactory policyFactory = (PolicyFactory)this.policy_factories.get(n2);
        return policyFactory.create_policy(n, any);
    }

    public boolean hasPolicyFactoryForType(int n) {
        return this.policy_factories != null && this.policy_factories.containsKey(new Integer(n));
    }

    public ContextList create_context_list() {
        throw new NO_IMPLEMENT();
    }

    public Environment create_environment() {
        throw new NO_IMPLEMENT();
    }

    public OutputStream create_output_stream() {
        return new CDROutputStream(this);
    }

    IOR createIOR(String string, byte[] byArray, boolean bl, org.jacorb.poa.POA pOA, Map map) {
        java.lang.Object object;
        TaggedProfile[] taggedProfileArray;
        IDLEntity iDLEntity;
        java.lang.Object object2;
        HashMap<Integer, java.lang.Object> hashMap;
        ArrayList<java.lang.Object> arrayList;
        block9: {
            arrayList = new ArrayList<java.lang.Object>();
            hashMap = new HashMap<Integer, java.lang.Object>();
            object2 = this.basicAdapter.getEndpointProfiles().iterator();
            while (object2.hasNext()) {
                iDLEntity = (Profile)object2.next();
                iDLEntity.set_object_key(byArray);
                arrayList.add(iDLEntity);
                taggedProfileArray = new TaggedComponentList();
                taggedProfileArray.addComponent(this.create_ORB_TYPE_ID());
                hashMap.put(new Integer(iDLEntity.tag()), taggedProfileArray);
                if (!(iDLEntity instanceof IIOPProfile)) continue;
                this.patchAddress((IIOPProfile)iDLEntity, string, bl);
                if (!pOA.isSSLRequired()) continue;
                ((IIOPProfile)iDLEntity).patchPrimaryAddress(null, 0);
            }
            object2 = new TaggedComponentList();
            hashMap.put(new Integer(1), object2);
            if (this.interceptor_manager != null && this.interceptor_manager.hasIORInterceptors()) {
                iDLEntity = new IORInfoImpl(this, pOA, hashMap, map, arrayList);
                try {
                    this.interceptor_manager.getIORIterator().iterate((IORInfoImpl)iDLEntity);
                }
                catch (Exception exception) {
                    if (!this.logger.isErrorEnabled()) break block9;
                    this.logger.error(exception.getMessage());
                }
            }
        }
        if ((iDLEntity = this.findIIOPProfile(arrayList)) != null && (this.giopMinorVersion == 0 || this.giopAdd_1_0_Profiles)) {
            taggedProfileArray = ((IIOPProfile)iDLEntity).to_GIOP_1_0();
            arrayList.add(taggedProfileArray);
            object = (TaggedComponentList)hashMap.get(new Integer(0));
            ((TaggedComponentList)object2).addAll(((IIOPProfile)iDLEntity).getComponents());
            ((TaggedComponentList)object2).addAll((TaggedComponentList)object);
            if (this.giopMinorVersion == 0) {
                arrayList.remove(iDLEntity);
            }
        }
        taggedProfileArray = null;
        if (((TaggedComponentList)object2).isEmpty()) {
            taggedProfileArray = new TaggedProfile[arrayList.size()];
        } else {
            taggedProfileArray = new TaggedProfile[arrayList.size() + 1];
            taggedProfileArray[taggedProfileArray.length - 1] = this.createMultipleComponentsProfile((TaggedComponentList)object2);
        }
        object = new TaggedProfileHolder();
        TaggedComponentSeqHolder taggedComponentSeqHolder = new TaggedComponentSeqHolder();
        for (int i = 0; i < arrayList.size(); ++i) {
            Profile profile = (Profile)arrayList.get(i);
            TaggedComponentList taggedComponentList = (TaggedComponentList)hashMap.get(new Integer(profile.tag()));
            taggedComponentSeqHolder.value = taggedComponentList.asArray();
            profile.marshal((TaggedProfileHolder)object, taggedComponentSeqHolder);
            taggedProfileArray[i] = ((TaggedProfileHolder)object).value;
        }
        return new IOR(string, taggedProfileArray);
    }

    private TaggedProfile createMultipleComponentsProfile(TaggedComponentList taggedComponentList) {
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        cDROutputStream.beginEncapsulatedArray();
        MultipleComponentProfileHelper.write(cDROutputStream, taggedComponentList.asArray());
        return new TaggedProfile(1, cDROutputStream.getBufferCopy());
    }

    private IIOPProfile findIIOPProfile(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!(profile instanceof IIOPProfile)) continue;
            return (IIOPProfile)profile;
        }
        return null;
    }

    public Context get_default_context() {
        throw new NO_IMPLEMENT();
    }

    public BasicAdapter getBasicAdapter() {
        if (this.basicAdapter == null) {
            throw new INITIALIZE("Adapters not initialized; resolve RootPOA.");
        }
        return this.basicAdapter;
    }

    public org.jacorb.poa.Current getPOACurrent() {
        if (this.poaCurrent == null) {
            this.poaCurrent = org.jacorb.poa.Current._Current_init();
        }
        return this.poaCurrent;
    }

    public Object getReference(org.jacorb.poa.POA pOA, byte[] byArray, String string, boolean bl) {
        Delegate delegate;
        block4: {
            IOR iOR;
            if (string == null) {
                string = "IDL:omg.org/CORBA/Object:1.0";
            }
            if ((iOR = this.createIOR(string, byArray, bl, pOA, null)) == null && this.logger.isErrorEnabled()) {
                this.logger.error("Interal error: createIOR returns null");
            }
            delegate = new Delegate(this, iOR);
            try {
                delegate.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error(configurationException.getMessage(), (Throwable)configurationException);
            }
        }
        return delegate.getReference(pOA);
    }

    public org.jacorb.poa.POA getRootPOA() throws INITIALIZE {
        if (this.rootpoa == null) {
            this.rootpoa = org.jacorb.poa.POA._POA_init(this);
            this.basicAdapter = new BasicAdapter(this, this.rootpoa, this.getTransportManager(), this.getGIOPConnectionManager());
            try {
                this.basicAdapter.configure((Configuration)this.configuration);
                this.rootpoa.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INITIALIZE("ConfigurationException: " + configurationException.getMessage());
            }
            this.rootpoa._addPOAEventListener(this);
        }
        return this.rootpoa;
    }

    public boolean isApplet() {
        return this.applet != null;
    }

    public Applet getApplet() {
        return this.applet;
    }

    public String[] list_initial_services() {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = this.initial_references.keySet().iterator();
        while (stringArray.hasNext()) {
            arrayList.add(stringArray.next());
        }
        stringArray = new String[services.length + arrayList.size()];
        arrayList.toArray(stringArray);
        System.arraycopy(services, 0, stringArray, arrayList.size(), services.length);
        return stringArray;
    }

    public void poaCreated(org.jacorb.poa.POA pOA) {
        pOA._addPOAEventListener(this);
        if (pOA.isPersistent()) {
            ++this.persistentPOACount;
            this.getImR();
            if (this.imr != null) {
                String string = this.implName;
                this.imr.registerPOA(string + "/" + pOA._getQualifiedName(), string, this.getServerAddress(), this.getServerPort());
            }
        }
    }

    private void getImR() {
        if (this.imr == null && this.useIMR) {
            try {
                this.imr = ImRAccessImpl.connect(this);
            }
            catch (Exception exception) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error: No connection to ImplementationRepository");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                if (exception instanceof INTERNAL) {
                    throw new OBJ_ADAPTER("Unable to resolve ImR");
                }
                if (exception instanceof TRANSIENT) {
                    throw (TRANSIENT)exception;
                }
                throw new OBJ_ADAPTER(exception.toString());
            }
        }
    }

    private void patchAddress(IIOPProfile iIOPProfile, String string, boolean bl) {
        if (string.equals("IDL:org/jacorb/imr/ImplementationRepository:1.0")) {
            iIOPProfile.patchPrimaryAddress(this.imrProxyHost, this.imrProxyPort);
        } else if (!bl && this.useIMR && this.useIMREndpoint) {
            this.getImR();
            iIOPProfile.patchPrimaryAddress(this.imr.getImRHost(), this.imr.getImRPort());
            iIOPProfile.patchPrimaryAddress(this.imrProxyHost, this.imrProxyPort);
        } else {
            iIOPProfile.patchPrimaryAddress(this.iorProxyHost, this.iorProxyPort);
        }
    }

    private TaggedComponent create_ORB_TYPE_ID() {
        CDROutputStream cDROutputStream = new CDROutputStream(this);
        cDROutputStream.beginEncapsulatedArray();
        cDROutputStream.write_long(1245790976);
        return new TaggedComponent(0, cDROutputStream.getBufferCopy());
    }

    private String getServerAddress() {
        String string = this.iorProxyHost;
        if (string == null) {
            string = this.getBasicAdapter().getAddress();
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Using proxy host " + string + " in IOR");
        }
        return string;
    }

    private int getServerPort() {
        int n = -1;
        if (this.iorProxyPort != -1) {
            n = this.iorProxyPort;
            if (n < 0) {
                throw new BAD_QOS("Negative port numbers are not allowed! (check property \"jacorb.ior_proxy_port\")");
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Using proxy port " + n + " in IOR");
            }
        } else {
            n = this.getBasicAdapter().getPort();
        }
        return n;
    }

    private String getIMRAddressForIOR(String string) {
        return this.imrProxyHost == null ? string : this.imrProxyHost;
    }

    private int getIMRPortForIOR(int n) {
        return this.imrProxyPort;
    }

    public void poaStateChanged(org.jacorb.poa.POA pOA, int n) {
        if ((n == 4 || n == 3) && pOA.isPersistent() && this.imr != null && --this.persistentPOACount == 0) {
            this.imr.setServerDown(this.implName);
        }
    }

    public void referenceCreated(Object object) {
    }

    public boolean get_service_information(short s, ServiceInformationHolder serviceInformationHolder) {
        throw new NO_IMPLEMENT();
    }

    public Object resolve_initial_references(String string) throws InvalidName {
        if (this.initial_references.containsKey(string)) {
            return (Object)this.initial_references.get(string);
        }
        Object object = null;
        String string2 = null;
        try {
            string2 = this.configuration.getAttribute("ORBInitRef." + string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            try {
                object = this.string_to_object(string2);
            }
            catch (Exception exception) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not create initial reference for \"" + string + "\"\n" + "Please check property \"ORBInitRef." + string + '\"');
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(exception.getMessage());
                }
                throw new InvalidName();
            }
        }
        if (string.equals("NameService") && this.isApplet()) {
            block27: {
                try {
                    String string3 = ObjectUtil.readURL("http://" + this.applet.getCodeBase().getHost() + "/" + "NameService.ior");
                    object = this.string_to_object(string3);
                }
                catch (IOException iOException) {
                    if (!this.logger.isWarnEnabled()) break block27;
                    this.logger.warn(iOException.getMessage());
                }
            }
            if (object != null && !object._is_a(NamingContextHelper.id())) {
                object = null;
            }
        } else {
            if (string.equals("RootPOA")) {
                return this.getRootPOA();
            }
            if (string.equals("POACurrent")) {
                return this.getPOACurrent();
            }
            if (string.equals("SecurityCurrent")) {
                block28: {
                    if (this.securityCurrent == null) {
                        try {
                            Class clazz = ObjectUtil.classForName("org.jacorb.security.level2.CurrentImpl");
                            Constructor constructor = clazz.getConstructor(class$org$omg$CORBA$ORB == null ? (class$org$omg$CORBA$ORB = ORB.class$("org.omg.CORBA.ORB")) : class$org$omg$CORBA$ORB);
                            this.securityCurrent = (Current)constructor.newInstance(this);
                            Method method = clazz.getDeclaredMethod("configure", class$org$apache$avalon$framework$configuration$Configuration == null ? (class$org$apache$avalon$framework$configuration$Configuration = ORB.class$("org.apache.avalon.framework.configuration.Configuration")) : class$org$apache$avalon$framework$configuration$Configuration);
                            method.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[]{this.configuration});
                            Method method2 = clazz.getDeclaredMethod("init", new Class[0]);
                            method2.invoke((java.lang.Object)this.securityCurrent, new java.lang.Object[0]);
                        }
                        catch (Exception exception) {
                            if (!this.logger.isWarnEnabled()) break block28;
                            this.logger.warn("Exception", (Throwable)exception);
                        }
                    }
                }
                object = this.securityCurrent;
            } else if (string.equals("DynAnyFactory")) {
                object = new DynAnyFactoryImpl(this);
            } else {
                if (string.equals("PICurrent")) {
                    return this.piCurrent;
                }
                if (string.equals("ORBPolicyManager")) {
                    return this.getPolicyManager();
                }
                if (string.equals("CodecFactory")) {
                    object = new CodecFactoryImpl(this);
                } else {
                    throw new InvalidName();
                }
            }
        }
        if (object != null) {
            this.initial_references.put(string, object);
        }
        return object;
    }

    PolicyManager getPolicyManager() {
        return this.policyManager;
    }

    public void register_initial_reference(String string, Object object) throws InvalidName {
        if (string == null || string.length() == 0 || this.initial_references.containsKey(string)) {
            throw new InvalidName();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registering initial ref " + string);
        }
        this.initial_references.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run");
        }
        try {
            java.lang.Object object = this.orb_synch;
            synchronized (object) {
                while (this.run) {
                    this.orb_synch.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB run, exit");
        }
    }

    public void send_multiple_requests_oneway(org.omg.CORBA.Request[] requestArray) {
        for (int i = 0; i < requestArray.length; ++i) {
            requestArray[i].send_oneway();
        }
    }

    public void send_multiple_requests_deferred(org.omg.CORBA.Request[] requestArray) {
        for (int i = 0; i < requestArray.length; ++i) {
            requestArray[i].send_deferred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean poll_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Iterator iterator = this.requests.iterator();
            while (iterator.hasNext()) {
                Request request = (Request)iterator.next();
                if (!request.poll_response()) continue;
                this.request = request;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Request get_next_response() {
        if (this.requests.size() == 0) {
            throw new BAD_INV_ORDER(11, CompletionStatus.COMPLETED_NO);
        }
        Set set = this.requests;
        synchronized (set) {
            Request request = null;
            if (this.request != null) {
                this.request.get_response();
                request = this.request;
                this.request = null;
                return request;
            }
            block3: while (true) {
                Iterator iterator = this.requests.iterator();
                do {
                    if (!iterator.hasNext()) continue block3;
                } while (!(request = (Request)iterator.next()).poll_response());
                break;
            }
            request.get_response();
            return request;
        }
    }

    public void addRequest(org.omg.CORBA.Request request) {
        this.requests.add(request);
    }

    public void removeRequest(org.omg.CORBA.Request request) {
        this.requests.remove(request);
    }

    protected void set_parameters(String[] stringArray, Properties properties) {
        block18: {
            this._props = properties;
            try {
                this.configure((Configuration)org.jacorb.config.Configuration.getConfiguration(properties, this));
            }
            catch (ConfigurationException configurationException) {
                if (this.logger != null && this.logger.isErrorEnabled()) {
                    this.logger.error(configurationException.getMessage());
                } else {
                    configurationException.printStackTrace();
                }
                throw new INITIALIZE(configurationException.getMessage());
            }
            if (stringArray != null) {
                this._args = stringArray;
                for (int i = 0; i < stringArray.length; ++i) {
                    int n;
                    String string;
                    String string2 = stringArray[i].trim();
                    if (string2.startsWith("-ORBInitRef.")) {
                        string = string2.substring(1);
                        n = string.indexOf(61);
                        if (n == -1) {
                            throw new BAD_PARAM("InitRef format invalid for " + string);
                        }
                        this.configuration.setAttribute(string.substring(0, n), string.substring(n + 1));
                        continue;
                    }
                    if (!string2.equals("-ORBInitRef")) continue;
                    if (stringArray.length - 1 < i + 1) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn("WARNING: -ORBInitRef argument without value");
                        continue;
                    }
                    if ((n = (string = stringArray[++i].trim()).indexOf(61)) == -1) {
                        throw new BAD_PARAM("InitRef format invalid for " + string);
                    }
                    this.configuration.setAttribute("ORBInitRef." + string.substring(0, n), string.substring(n + 1));
                }
            }
            this.policyManager = new PolicyManager(this);
            try {
                this.clientConnectionManager = new ClientConnectionManager(this, this.getTransportManager(), this.getGIOPConnectionManager());
                this.clientConnectionManager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isErrorEnabled()) break block18;
                this.logger.error(configurationException.getMessage());
            }
        }
        if (this.hashTableClassName == null || this.hashTableClassName.length() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            }
            this.knownReferences = new HashMap();
        } else {
            try {
                this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
            }
            catch (Exception exception) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(exception.getMessage());
                }
                this.knownReferences = new HashMap();
            }
        }
        this.interceptorInit();
    }

    protected void set_parameters(Applet applet, Properties properties) {
        block11: {
            this.applet = applet;
            this._props = properties;
            try {
                this.configure((Configuration)org.jacorb.config.Configuration.getConfiguration(properties, this));
            }
            catch (ConfigurationException configurationException) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error(configurationException.getMessage());
                }
                throw new INITIALIZE(configurationException.getMessage());
            }
            try {
                this.clientConnectionManager = new ClientConnectionManager(this, this.getTransportManager(), this.getGIOPConnectionManager());
                this.clientConnectionManager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                if (!this.logger.isErrorEnabled()) break block11;
                this.logger.error(configurationException.getMessage());
            }
        }
        if (this.hashTableClassName == null || this.hashTableClassName.length() == 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Property \"jacorb.hashtable_class\" not present. Will use default hashtable implementation");
            }
            this.knownReferences = new HashMap();
        } else {
            try {
                this.knownReferences = (Map)ObjectUtil.classForName(this.hashTableClassName).newInstance();
            }
            catch (Exception exception) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info(exception.getMessage());
                }
                this.knownReferences = new HashMap();
            }
        }
        this.interceptorInit();
    }

    private void interceptorInit() {
        Vector vector = this.getORBInitializers();
        if (vector.size() > 0) {
            ORBInitializer oRBInitializer;
            int n;
            ORBInitInfoImpl oRBInitInfoImpl = new ORBInitInfoImpl(this);
            for (n = 0; n < vector.size(); ++n) {
                try {
                    oRBInitializer = (ORBInitializer)vector.elementAt(n);
                    oRBInitializer.pre_init(oRBInitInfoImpl);
                    continue;
                }
                catch (Exception exception) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(exception.getMessage());
                }
            }
            for (n = 0; n < vector.size(); ++n) {
                try {
                    oRBInitializer = (ORBInitializer)vector.elementAt(n);
                    oRBInitializer.post_init(oRBInitInfoImpl);
                    continue;
                }
                catch (Exception exception) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn(exception.getMessage());
                }
            }
            oRBInitInfoImpl.setInvalid();
            Vector vector2 = oRBInitInfoImpl.getClientInterceptors();
            Vector vector3 = oRBInitInfoImpl.getServerInterceptors();
            Vector vector4 = oRBInitInfoImpl.getIORInterceptors();
            this.hasClientInterceptors = vector2.size() > 0;
            boolean bl = this.hasServerInterceptors = vector3.size() > 0;
            if (this.hasClientInterceptors || this.hasServerInterceptors || vector4.size() > 0) {
                this.interceptor_manager = new InterceptorManager(vector2, vector3, vector4, oRBInitInfoImpl.getSlotCount(), this);
            }
            this.policy_factories = oRBInitInfoImpl.getPolicyFactories();
        }
    }

    private Vector getORBInitializers() {
        String[] stringArray = this.configuration.getAttributeNames();
        Vector vector = new Vector();
        String string = "org.omg.PortableInterceptor.ORBInitializerClass.";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            String string2 = null;
            string2 = this.configuration.getAttribute(stringArray[i], "");
            if (string2.length() == 0 && stringArray[i].length() > string.length()) {
                string2 = stringArray[i].substring(string.length());
            }
            if (string2 == null) continue;
            try {
                vector.addElement(ObjectUtil.classForName(string2).newInstance());
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Build: " + string2);
                continue;
            }
            catch (Exception exception) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Unable to build ORBInitializer from >>" + string2 + "<<");
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("prepare ORB for shutdown...");
        }
        if (!this.run) {
            return;
        }
        java.lang.Object object = this.shutdown_synch;
        synchronized (object) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ORB going down...");
            }
            if (this.shutdown_in_progress && bl) {
                java.lang.Object object2 = this.shutdown_synch;
                synchronized (object2) {
                    try {
                        this.shutdown_synch.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ORB going shutdown complete (1)");
                    }
                    return;
                }
            }
            if (this.shutdown_in_progress && !bl) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ORB going shutdown complete (2)");
                }
                return;
            }
            this.shutdown_in_progress = true;
        }
        if (this.rootpoa != null) {
            this.rootpoa.destroy(true, bl);
        }
        if (this.basicAdapter != null) {
            this.basicAdapter.stopListeners();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("ORB going shutdown (cleaning up ORB...)");
        }
        this.clientConnectionManager.shutdown();
        this.knownReferences.clear();
        this.bufferManager.release();
        object = this.shutdown_synch;
        synchronized (object) {
            this.shutdown_synch.notifyAll();
        }
        object = this.orb_synch;
        synchronized (object) {
            this.run = false;
            this.orb_synch.notifyAll();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ORB shutdown complete");
        }
    }

    public void destroy() {
        if (this.destroyed) {
            throw new OBJECT_NOT_EXIST();
        }
        if (this.run) {
            this.shutdown(true);
        }
        if (this.interceptor_manager != null) {
            this.interceptor_manager.destroy();
        }
        this.destroyed = true;
    }

    public Object string_to_object(String string) {
        if (string == null) {
            return null;
        }
        try {
            ParsedIOR parsedIOR = new ParsedIOR(string, this, this.logger);
            if (parsedIOR.isNull()) {
                return null;
            }
            return this._getObject(parsedIOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(illegalArgumentException.getMessage());
            }
            return null;
        }
    }

    public Object get_value_def(String string) throws BAD_PARAM {
        throw new NO_IMPLEMENT();
    }

    public void set_delegate(java.lang.Object object) {
        if (!(object instanceof Servant)) {
            throw new BAD_PARAM("Argument must be of type org.omg.PortableServer.Servant");
        }
        try {
            ((Servant)object)._get_delegate();
        }
        catch (BAD_INV_ORDER bAD_INV_ORDER) {
            ServantDelegate servantDelegate = new ServantDelegate(this);
            ((Servant)object)._set_delegate(servantDelegate);
        }
    }

    public void useProxy() {
        this.applet = new Applet();
    }

    public String object_to_string(Object object) {
        if (object == null) {
            return nullIORString;
        }
        if (object instanceof LocalObject) {
            throw new MARSHAL("Attempt to stringify a local object");
        }
        org.omg.CORBA.portable.Delegate delegate = ((ObjectImpl)object)._get_delegate();
        if (delegate instanceof Delegate) {
            return delegate.toString();
        }
        throw new BAD_PARAM("Argument has a delegate whose class is " + delegate.getClass().getName() + ", a org.jacorb.orb.Delegate was expected");
    }

    public void perform_work() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
    }

    public boolean work_pending() {
        if (!this.run) {
            throw new BAD_INV_ORDER(4, CompletionStatus.COMPLETED_NO);
        }
        return false;
    }

    public ValueFactory register_value_factory(String string, ValueFactory valueFactory) {
        return this.valueFactories.put(string, valueFactory);
    }

    public void unregister_value_factory(String string) {
        this.valueFactories.remove(string);
    }

    public ValueFactory lookup_value_factory(String string) {
        ValueFactory valueFactory = (ValueFactory)this.valueFactories.get(string);
        if (valueFactory == null && string.startsWith("IDL")) {
            String string2 = RepositoryID.className(string, null);
            valueFactory = this.findValueFactory(string2);
            this.valueFactories.put(string, valueFactory);
        }
        return valueFactory;
    }

    private ValueFactory findValueFactory(String string) {
        Class clazz = null;
        clazz = this.findClass(string + "DefaultFactory", true);
        if (clazz != null) {
            return (ValueFactory)this.instantiate(clazz);
        }
        Class clazz2 = this.findClass(string, false);
        clazz = this.findClass(string + "Impl", false);
        if (clazz != null && clazz2.isAssignableFrom(clazz)) {
            if ((class$org$omg$CORBA$portable$ValueFactory == null ? (class$org$omg$CORBA$portable$ValueFactory = ORB.class$("org.omg.CORBA.portable.ValueFactory")) : class$org$omg$CORBA$portable$ValueFactory).isAssignableFrom(clazz)) {
                return (ValueFactory)this.instantiate(clazz);
            }
            return new JacORBValueFactory(clazz);
        }
        return null;
    }

    private Class findClass(String string, boolean bl) {
        Class clazz;
        block4: {
            clazz = null;
            try {
                clazz = ObjectUtil.classForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!bl || !string.startsWith("org.omg")) break block4;
                try {
                    clazz = ObjectUtil.classForName("omg.org" + string.substring(7));
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
            }
        }
        return clazz;
    }

    private java.lang.Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("cannot instantiate class " + clazz.getName() + " (IllegalAccessException)");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("cannot instantiate class " + clazz.getName() + " (InstantiationException)");
        }
    }

    public BoxedValueHelper getBoxedValueHelper(String string) {
        BoxedValueHelper boxedValueHelper = (BoxedValueHelper)this.boxedValueHelpers.get(string);
        if (boxedValueHelper == null) {
            if (this.boxedValueHelpers.containsKey(string)) {
                return null;
            }
            boxedValueHelper = RepositoryID.createBoxedValueHelper(string, null);
            this.boxedValueHelpers.put(string, boxedValueHelper);
        }
        return boxedValueHelper;
    }

    public boolean hasClientRequestInterceptors() {
        return this.hasClientInterceptors;
    }

    public boolean hasServerRequestInterceptors() {
        return this.hasServerInterceptors;
    }

    public boolean hasRequestInterceptors() {
        return this.hasServerInterceptors || this.hasClientInterceptors;
    }

    public InterceptorManager getInterceptorManager() {
        return this.interceptor_manager;
    }

    public TransportManager getTransportManager() {
        if (this.transport_manager == null) {
            this.transport_manager = new TransportManager(this);
            try {
                this.transport_manager.configure((Configuration)this.configuration);
            }
            catch (ConfigurationException configurationException) {
                throw new INTERNAL(configurationException.getMessage());
            }
        }
        return this.transport_manager;
    }

    public org.omg.CORBA.ExceptionList create_exception_list() {
        return new ExceptionList();
    }

    public org.omg.CORBA.NVList create_list(int n) {
        return new NVList(this, n);
    }

    public org.omg.CORBA.NamedValue create_named_value(String string, Any any, int n) {
        return new NamedValue(string, any, n);
    }

    public org.omg.CORBA.NVList create_operation_list(Object object) {
        if (!(object instanceof OperationDef)) {
            throw new BAD_PARAM("Argument must be of type org.omg.CORBA.OperationDef");
        }
        OperationDef operationDef = (OperationDef)object;
        return this.create_operation_list(operationDef);
    }

    public org.omg.CORBA.NVList create_operation_list(OperationDef operationDef) {
        int n = 0;
        ParameterDescription[] parameterDescriptionArray = null;
        parameterDescriptionArray = operationDef.params();
        if (parameterDescriptionArray != null) {
            n = parameterDescriptionArray.length;
        }
        NVList nVList = new NVList(this, n);
        for (int i = 0; i < n; ++i) {
            ParameterDescription parameterDescription = parameterDescriptionArray[i];
            Any any = this.create_any();
            any.type(parameterDescription.type);
            ((org.omg.CORBA.NVList)nVList).add_value(parameterDescription.name, any, parameterDescription.mode.value());
        }
        return nVList;
    }

    private void configureObjectKeyMap(Configuration configuration) {
        String[] stringArray = configuration.getAttributeNames();
        String string = "jacorb.orb.objectKeyMap.";
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            this.objectKeyMap.put(stringArray[i].substring(string.length()), configuration.getAttribute(stringArray[i], ""));
        }
    }

    public void addObjectKey(String string, String string2) {
        this.objectKeyMap.put(string, string2);
    }

    public byte[] mapObjectKey(byte[] byArray) {
        java.lang.Object var2_2 = null;
        java.lang.Object var3_3 = null;
        ParsedIOR parsedIOR = null;
        String string = null;
        String string2 = null;
        if (this.objectKeyMap.size() != 0 && (string = (String)this.objectKeyMap.get(string2 = new String(byArray))) != null) {
            if (ParsedIOR.isParsableProtocol(string)) {
                try {
                    parsedIOR = new ParsedIOR(string, this, this.logger);
                    return parsedIOR.get_object_key();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Error - could not read protocol " + string);
                    }
                    return byArray;
                }
            }
            return CorbaLoc.parseKey(string);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Object object) {
        if (!(object instanceof ObjectImpl)) {
            throw new BAD_PARAM("connect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(object instanceof InvokeHandler)) {
            throw new BAD_PARAM("connect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            block10: {
                if (!this.connectedObjects.containsKey(object)) {
                    ObjectImpl objectImpl = (ObjectImpl)object;
                    HandlerWrapper handlerWrapper = new HandlerWrapper(objectImpl);
                    Object object2 = handlerWrapper._this_object(this);
                    objectImpl._set_delegate(((ObjectImpl)object2)._get_delegate());
                    this.connectedObjects.put(object, handlerWrapper);
                    if (this.firstConnection) {
                        this.firstConnection = false;
                        POAManager pOAManager = this.getRootPOA().the_POAManager();
                        if (pOAManager.get_state() == State.HOLDING) {
                            try {
                                pOAManager.activate();
                            }
                            catch (AdapterInactive adapterInactive) {
                                if (!this.logger.isErrorEnabled()) break block10;
                                this.logger.error(adapterInactive.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Object object) {
        if (!(object instanceof ObjectImpl)) {
            throw new BAD_PARAM("disconnect parameter must extend org.omg.CORBA.portable.ObjectImpl");
        }
        if (!(object instanceof InvokeHandler)) {
            throw new BAD_PARAM("disconnect parameter must implement org.omg.CORBA.portable.InvokeHandler");
        }
        Map map = this.connectedObjects;
        synchronized (map) {
            block8: {
                Servant servant = (Servant)this.connectedObjects.get(object);
                if (servant != null) {
                    this.connectedObjects.remove(object);
                    try {
                        this.getRootPOA().deactivate_object(this.getRootPOA().servant_to_id(servant));
                    }
                    catch (Exception exception) {
                        if (!this.logger.isErrorEnabled()) break block8;
                        this.logger.error(exception.getMessage());
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        services = new String[]{"RootPOA", "POACurrent", "DynAnyFactory", "PICurrent", "CodecFactory"};
    }

    static class HandlerWrapper
    extends Servant
    implements InvokeHandler {
        private InvokeHandler wrappedHandler;

        public HandlerWrapper(ObjectImpl objectImpl) {
            this.wrappedHandler = (InvokeHandler)((java.lang.Object)objectImpl);
        }

        public String[] _all_interfaces(POA pOA, byte[] byArray) {
            return ((ObjectImpl)((java.lang.Object)this.wrappedHandler))._ids();
        }

        public OutputStream _invoke(String string, org.omg.CORBA.portable.InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
            return this.wrappedHandler._invoke(string, inputStream, responseHandler);
        }
    }

    private class PICurrent
    extends LocalObject
    implements org.omg.PortableInterceptor.Current {
        private PICurrent() {
        }

        private org.omg.PortableInterceptor.Current getTarget() {
            if (ORB.this.interceptor_manager == null) {
                return InterceptorManager.EMPTY_CURRENT;
            }
            return ORB.this.interceptor_manager.getCurrent();
        }

        public Any get_slot(int n) throws InvalidSlot {
            return this.getTarget().get_slot(n);
        }

        public void set_slot(int n, Any any) throws InvalidSlot {
            this.getTarget().set_slot(n, any);
        }
    }

    private class JacORBValueFactory
    implements ValueFactory {
        private Class implementationClass;

        public JacORBValueFactory(Class clazz) {
            this.implementationClass = clazz;
        }

        public Serializable read_value(InputStream inputStream) {
            StreamableValue streamableValue = (StreamableValue)ORB.this.instantiate(this.implementationClass);
            return inputStream.read_value(streamableValue);
        }
    }
}

