/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.IIOPAddress;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.SSLServerSocketFactory;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.orb.factory.SocketFactoryManager;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.ETF.Connection;
import org.omg.ETF.Handle;
import org.omg.ETF.Profile;
import org.omg.ETF._ListenerLocalBase;
import org.omg.SSLIOP.SSL;

public class IIOPListener
extends _ListenerLocalBase
implements Configurable {
    private static final int MAX_SSL_OPTIONS = 126;
    private static final int MIN_SSL_OPTIONS = 26;
    private ORB orb = null;
    private SocketFactoryManager socketFactoryManager = null;
    private ServerSocketFactory serverSocketFactory = null;
    private SSLServerSocketFactory sslServerSocketFactory = null;
    private Acceptor acceptor = null;
    private SSLAcceptor sslAcceptor = null;
    private IIOPProfile endpoint = null;
    private org.jacorb.config.Configuration configuration;
    private Logger logger = null;
    private boolean supportSSL = false;
    private boolean dnsEnabled = false;
    private int serverTimeout = 0;
    private int oaPort = 0;
    private int sslPort = 0;
    private int target_supports = 0;
    private int target_requires = 0;
    private boolean generateSSLComponents = true;
    private Handle up = null;
    private List incoming_connections = new ArrayList();
    private boolean terminated = false;
    static /* synthetic */ Class class$org$omg$SSLIOP$SSLHelper;

    public IIOPListener(ORB oRB) {
        this.orb = oRB;
        this.socketFactoryManager = new SocketFactoryManager(oRB);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)configuration;
        this.logger = this.configuration.getNamedLogger("jacorb.iiop.listener");
        this.socketFactoryManager.configure(configuration);
        this.oaPort = configuration.getAttributeAsInteger("OAPort", 0);
        this.sslPort = configuration.getAttributeAsInteger("OASSLPort", 0);
        this.dnsEnabled = configuration.getAttribute("jacorb.dns.enable", "off").equals("on");
        this.serverTimeout = configuration.getAttributeAsInteger("jacorb.connection.server.timeout", 0);
        this.supportSSL = configuration.getAttribute("jacorb.security.support_ssl", "off").equals("on");
        this.target_supports = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.target_supports |= 0x1A;
        this.target_requires = Integer.parseInt(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
        this.generateSSLComponents = configuration.getAttribute("jacorb.security.ssl_components_added_by_ior_interceptor", "off").equals("off");
        if (!this.isSSLRequired()) {
            this.acceptor = new Acceptor();
            this.acceptor.init();
        }
        if (this.supportSSL) {
            this.sslAcceptor = new SSLAcceptor();
            this.sslAcceptor.init();
        }
        this.endpoint = this.createEndPointProfile();
    }

    public void set_handle(Handle handle) {
        this.up = handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection accept() {
        if (this.up != null) {
            throw new BAD_INV_ORDER("Must not call accept() when a Handle has been set");
        }
        List list = this.incoming_connections;
        synchronized (list) {
            while (!this.terminated && this.incoming_connections.isEmpty()) {
                try {
                    this.incoming_connections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.terminated) {
                return (Connection)this.incoming_connections.remove(0);
            }
            return null;
        }
    }

    public void listen() {
        if (this.acceptor != null) {
            this.acceptor.start();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.start();
        }
    }

    public void destroy() {
        if (this.acceptor != null) {
            this.acceptor.terminate();
        }
        if (this.sslAcceptor != null) {
            this.sslAcceptor.terminate();
        }
        this.terminated = true;
        if (this.up == null) {
            this.incoming_connections.notifyAll();
        }
    }

    public void completed_data(Connection connection) {
        throw new NO_IMPLEMENT();
    }

    public Profile endpoint() {
        return this.endpoint.copy();
    }

    private boolean isSSLSupported() {
        return this.supportSSL;
    }

    private boolean isSSLRequired() throws ConfigurationException {
        if (this.isSSLSupported()) {
            return (this.target_requires & 0x7E) != 0;
        }
        return false;
    }

    private int getServerTimeout() {
        return this.serverTimeout;
    }

    private ServerSocketFactory getServerSocketFactory() {
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = this.socketFactoryManager.getServerSocketFactory();
        }
        return this.serverSocketFactory;
    }

    private SSLServerSocketFactory getSSLServerSocketFactory() {
        if (this.sslServerSocketFactory == null) {
            this.sslServerSocketFactory = this.orb.getBasicAdapter().getSSLSocketFactory();
            if (this.sslServerSocketFactory == null) {
                throw new INITIALIZE("No SSL server socket factory found");
            }
        }
        return this.sslServerSocketFactory;
    }

    private IIOPProfile createEndPointProfile() throws ConfigurationException {
        int n = 0;
        if (this.acceptor != null) {
            n = this.getConfiguredPort();
            if (n == 0) {
                n = this.acceptor.getLocalAddress().getPort();
            }
        } else if (this.sslAcceptor == null) {
            throw new INITIALIZE("no acceptors found, cannot create endpoint profile");
        }
        IIOPProfile iIOPProfile = new IIOPProfile(new IIOPAddress(this.dnsEnabled ? this.getHost().getHostName() : this.getHost().getHostAddress(), n), null);
        if (this.sslAcceptor != null && this.generateSSLComponents) {
            iIOPProfile.addComponent(20, this.createSSL(), class$org$omg$SSLIOP$SSLHelper == null ? (class$org$omg$SSLIOP$SSLHelper = IIOPListener.class$("org.omg.SSLIOP.SSLHelper")) : class$org$omg$SSLIOP$SSLHelper);
        }
        iIOPProfile.configure((Configuration)this.configuration);
        return iIOPProfile;
    }

    private SSL createSSL() {
        return new SSL((short)this.target_supports, (short)this.target_requires, (short)this.sslAcceptor.getLocalAddress().getPort());
    }

    private InetAddress getConfiguredHost() {
        try {
            String string = this.configuration.getAttribute("OAIAddr", "");
            return string.length() == 0 ? null : InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private InetAddress getHost() {
        try {
            InetAddress inetAddress = this.getConfiguredHost();
            return inetAddress == null ? InetAddress.getLocalHost() : inetAddress;
        }
        catch (UnknownHostException unknownHostException) {
            throw new INITIALIZE("Could not resolve configured listener host");
        }
    }

    private int getConfiguredPort() {
        return this.oaPort;
    }

    private int getConfiguredSSLPort() {
        return this.sslPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConnection(Socket socket, boolean bl) {
        Connection connection = null;
        try {
            connection = this.createServerConnection(socket, bl);
        }
        catch (IOException iOException) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Could not create connection from socket: " + iOException);
            }
            return;
        }
        if (this.up != null) {
            this.up.add_input(connection);
        } else {
            List list = this.incoming_connections;
            synchronized (list) {
                this.incoming_connections.add(connection);
                this.incoming_connections.notifyAll();
            }
        }
    }

    protected Connection createServerConnection(Socket socket, boolean bl) throws IOException {
        ServerIIOPConnection serverIIOPConnection = new ServerIIOPConnection(socket, bl);
        try {
            serverIIOPConnection.configure((Configuration)this.configuration);
        }
        catch (ConfigurationException configurationException) {
            throw new INTERNAL("ConfigurationException: " + configurationException.getMessage());
        }
        return serverIIOPConnection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SSLAcceptor
    extends Acceptor {
        private SSLAcceptor() {
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getSSLServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredSSLPort(), 20, IIOPListener.this.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn(iOException.getMessage());
                throw new INITIALIZE("Could not create SSL server socket");
            }
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, true);
        }
    }

    private class Acceptor
    extends Thread {
        protected ServerSocket serverSocket;
        private boolean terminated = false;

        public Acceptor() {
            this.setDaemon(true);
        }

        public void init() {
            this.serverSocket = this.createServerSocket();
            if (IIOPListener.this.logger.isDebugEnabled()) {
                IIOPListener.this.logger.debug("Created socket listener on " + this.serverSocket.getInetAddress());
            }
        }

        public void run() {
            while (!this.terminated) {
                try {
                    Socket socket = this.serverSocket.accept();
                    this.setup(socket);
                    this.deliverConnection(socket);
                }
                catch (Exception exception) {
                    if (this.terminated || !IIOPListener.this.logger.isWarnEnabled()) continue;
                    IIOPListener.this.logger.warn(exception.getMessage());
                }
            }
            if (IIOPListener.this.logger.isInfoEnabled()) {
                IIOPListener.this.logger.info("Listener exited");
            }
        }

        public void terminate() {
            block2: {
                this.terminated = true;
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    if (!IIOPListener.this.logger.isWarnEnabled()) break block2;
                    IIOPListener.this.logger.warn(iOException.getMessage());
                }
            }
        }

        public IIOPAddress getLocalAddress() {
            return new IIOPAddress(this.serverSocket.getInetAddress().getHostAddress(), this.serverSocket.getLocalPort());
        }

        protected ServerSocket createServerSocket() {
            try {
                return IIOPListener.this.getServerSocketFactory().createServerSocket(IIOPListener.this.getConfiguredPort(), 20, IIOPListener.this.getConfiguredHost());
            }
            catch (IOException iOException) {
                IIOPListener.this.logger.warn(iOException.getMessage());
                throw new INITIALIZE("Could not create server socket");
            }
        }

        protected void setup(Socket socket) throws IOException {
            socket.setSoTimeout(IIOPListener.this.serverTimeout);
        }

        protected void deliverConnection(Socket socket) {
            IIOPListener.this.deliverConnection(socket, false);
        }
    }
}

