/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.Vector;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.IORInterceptorIterator;
import org.jacorb.orb.portableInterceptor.PICurrentImpl;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager {
    private Interceptor[] client_req_interceptors = null;
    private Interceptor[] server_req_interceptors = null;
    private Interceptor[] ior_interceptors = null;
    private org.omg.CORBA.ORB orb = null;
    private int current_slots = 0;
    private Logger logger;
    private static ThreadLocal piCurrent = new ThreadLocal();
    public static final PICurrentImpl EMPTY_CURRENT = new PICurrentImpl(null, 0);

    public InterceptorManager(Vector vector, Vector vector2, Vector vector3, int n, org.omg.CORBA.ORB oRB) {
        int n2;
        int n3;
        String string;
        int n4;
        this.logger = ((ORB)oRB).getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("InterceptorManager started with " + vector2.size() + " SIs, " + vector.size() + " CIs and " + vector3.size() + " IORIs");
        }
        this.client_req_interceptors = new ClientRequestInterceptor[vector.size()];
        for (n4 = 0; n4 < this.client_req_interceptors.length; ++n4) {
            string = ((ClientRequestInterceptor)vector.elementAt(0)).name();
            n3 = 0;
            for (n2 = 1; n2 < vector.size(); ++n2) {
                if (string.compareTo(((ClientRequestInterceptor)vector.elementAt(n2)).name()) <= 0) continue;
                string = ((ClientRequestInterceptor)vector.elementAt(n2)).name();
                n3 = n2;
            }
            this.client_req_interceptors[n4] = (ClientRequestInterceptor)vector.elementAt(n3);
            vector.removeElementAt(n3);
        }
        this.server_req_interceptors = new ServerRequestInterceptor[vector2.size()];
        for (n4 = 0; n4 < this.server_req_interceptors.length; ++n4) {
            string = ((ServerRequestInterceptor)vector2.elementAt(0)).name();
            n3 = 0;
            for (n2 = 1; n2 < vector2.size(); ++n2) {
                if (string.compareTo(((ServerRequestInterceptor)vector2.elementAt(n2)).name()) <= 0) continue;
                string = ((ServerRequestInterceptor)vector2.elementAt(n2)).name();
                n3 = n2;
            }
            this.server_req_interceptors[n4] = (ServerRequestInterceptor)vector2.elementAt(n3);
            vector2.removeElementAt(n3);
        }
        this.ior_interceptors = new IORInterceptor[vector3.size()];
        for (n4 = 0; n4 < this.ior_interceptors.length; ++n4) {
            string = ((IORInterceptor)vector3.elementAt(0)).name();
            n3 = 0;
            for (n2 = 1; n2 < vector3.size(); ++n2) {
                if (string.compareTo(((IORInterceptor)vector3.elementAt(n2)).name()) <= 0) continue;
                string = ((IORInterceptor)vector3.elementAt(n2)).name();
                n3 = n2;
            }
            this.ior_interceptors[n4] = (IORInterceptor)vector3.elementAt(n3);
            vector3.removeElementAt(n3);
        }
        this.orb = oRB;
        this.current_slots = n;
    }

    public Current getCurrent() {
        Current current = (Current)piCurrent.get();
        if (current == null) {
            current = this.getEmptyCurrent();
            piCurrent.set(current);
        }
        return current;
    }

    public void setTSCurrent(Current current) {
        piCurrent.set(current);
    }

    public void removeTSCurrent() {
        piCurrent.set(null);
    }

    public Current getEmptyCurrent() {
        return new PICurrentImpl(this.orb, this.current_slots);
    }

    public ClientInterceptorIterator getClientIterator() {
        return new ClientInterceptorIterator(this.client_req_interceptors);
    }

    public ServerInterceptorIterator getServerIterator() {
        return new ServerInterceptorIterator(this.server_req_interceptors);
    }

    public IORInterceptorIterator getIORIterator() {
        return new IORInterceptorIterator(this.ior_interceptors);
    }

    public boolean hasClientRequestInterceptors() {
        return this.client_req_interceptors.length > 0;
    }

    public boolean hasServerRequestInterceptors() {
        return this.server_req_interceptors.length > 0;
    }

    public boolean hasIORInterceptors() {
        return this.ior_interceptors.length > 0;
    }

    public void destroy() {
        int n;
        if (this.hasClientRequestInterceptors()) {
            for (n = 0; n < this.client_req_interceptors.length; ++n) {
                this.client_req_interceptors[n].destroy();
            }
        }
        if (this.hasServerRequestInterceptors()) {
            for (n = 0; n < this.server_req_interceptors.length; ++n) {
                this.server_req_interceptors[n].destroy();
            }
        }
        if (this.hasIORInterceptors()) {
            for (n = 0; n < this.ior_interceptors.length; ++n) {
                this.ior_interceptors[n].destroy();
            }
        }
    }
}

