/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;

public class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private Current current;
    private Vector pool;
    private int unused_size;
    private int max_pool_size;
    private int min_pool_size;
    private boolean inUse = false;
    private Configuration configuration;
    private Logger logger;

    private RPPoolManager() {
    }

    protected RPPoolManager(Current current, int n, int n2, Logger logger, Configuration configuration) {
        this.current = current;
        this.max_pool_size = n2;
        this.min_pool_size = n;
        this.logger = logger;
        this.configuration = configuration;
    }

    private void addProcessor() {
        RequestProcessor requestProcessor = new RequestProcessor(this);
        try {
            requestProcessor.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException.toString());
        }
        this.current._addContext(requestProcessor, requestProcessor);
        requestProcessor.setDaemon(true);
        this.pool.addElement(requestProcessor);
        ++this.unused_size;
        requestProcessor.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener rPPoolManagerListener) {
        this.pmListener = EventMulticaster.add(this.pmListener, rPPoolManagerListener);
    }

    protected synchronized void destroy() {
        if (this.pool == null || !this.inUse) {
            return;
        }
        Object[] objectArray = new RequestProcessor[this.pool.size()];
        this.pool.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (((RequestProcessor)objectArray[i]).isActive()) {
                throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
            }
            this.pool.removeElement(objectArray[i]);
            --this.unused_size;
            this.current._removeContext((Thread)objectArray[i]);
            ((RequestProcessor)objectArray[i]).end();
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool == null ? 0 : this.pool.size();
    }

    protected synchronized int getPoolSize() {
        return this.unused_size;
    }

    protected synchronized RequestProcessor getProcessor() {
        if (!this.inUse) {
            this.init();
            this.inUse = true;
        }
        if (this.pool.size() == 0 && this.unused_size < this.max_pool_size) {
            this.addProcessor();
        }
        while (this.pool.size() == 0) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Thread pool exhausted, consider increasing jacorb.poa.thread_pool_max (currently: " + this.max_pool_size + ")");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        RequestProcessor requestProcessor = (RequestProcessor)this.pool.remove(this.pool.size() - 1);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(requestProcessor, this.pool.size(), this.unused_size);
        }
        return requestProcessor;
    }

    private void init() {
        this.pool = new Vector(this.max_pool_size);
        for (int i = 0; i < this.min_pool_size; ++i) {
            this.addProcessor();
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor requestProcessor) {
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addElement(requestProcessor);
            this.notifyAll();
        } else {
            --this.unused_size;
            this.current._removeContext(requestProcessor);
            requestProcessor.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(requestProcessor, this.pool.size(), this.unused_size);
        }
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener rPPoolManagerListener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, rPPoolManagerListener);
    }
}

