/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.Forwarder;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.ServiceContextTransportingOutputStream;
import org.jacorb.orb.portableInterceptor.InterceptorManager;
import org.jacorb.orb.portableInterceptor.ServerInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.poa.InvocationContext;
import org.jacorb.poa.POA;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestController;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.util.Time;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;

public class RequestProcessor
extends Thread
implements InvocationContext,
Configurable {
    private boolean start;
    private boolean terminate;
    private RPPoolManager poolManager;
    private RequestController controller;
    private ServerRequest request;
    private Servant servant;
    private ServantManager servantManager;
    private CookieHolder cookieHolder;
    private boolean checkReplyEndTime = false;
    private Logger logger;
    private static Map specialOperations;
    private static int count;

    RequestProcessor(RPPoolManager rPPoolManager) {
        super("RequestProcessor-" + ++count);
        this.poolManager = rPPoolManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.checkReplyEndTime = configuration.getAttributeAsBoolean("jacorb.poa.check_reply_end_time", false);
    }

    synchronized void begin() {
        this.start = true;
        this.notify();
    }

    synchronized void end() {
        this.terminate = true;
        this.notify();
    }

    public byte[] getObjectId() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getObjectId)");
        }
        return this.request.objectId();
    }

    public ORB getORB() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getORB)");
        }
        return this.controller.getORB();
    }

    public POA getPOA() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getPOA)");
        }
        return this.controller.getPOA();
    }

    public Servant getServant() {
        if (!this.start) {
            throw new POAInternalError("error: RequestProcessor not started (getServant)");
        }
        return this.servant;
    }

    void init(RequestController requestController, ServerRequest serverRequest, Servant servant, ServantManager servantManager) {
        this.controller = requestController;
        this.request = serverRequest;
        this.servant = servant;
        this.servantManager = servantManager;
        this.cookieHolder = null;
        this.logger = requestController.getLogger();
    }

    private void clear() {
        this.controller = null;
        this.request = null;
        this.servant = null;
        this.servantManager = null;
        this.cookieHolder = null;
    }

    private void invokeIncarnate() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke incarnate on servant activator");
        }
        try {
            this.servant = this.controller.getAOM().incarnate(this.request.objectId(), (ServantActivator)this.servantManager, this.controller.getPOA());
            if (this.servant == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: returns null");
                }
                this.request.setSystemException(new OBJ_ADAPTER());
            }
            this.controller.getORB().set_delegate(this.servant);
        }
        catch (SystemException systemException) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: system exception was thrown (" + systemException.getMessage() + ")");
            }
            this.request.setSystemException(systemException);
        }
        catch (org.omg.PortableServer.ForwardRequest forwardRequest) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: forward exception was thrown (" + forwardRequest.getMessage() + ")");
            }
            this.request.setLocationForward(forwardRequest);
        }
        catch (Throwable throwable) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " incarnate: throwable was thrown (" + throwable.getMessage() + ")", throwable);
            }
            this.request.setSystemException(new OBJ_ADAPTER(throwable.getMessage()));
        }
    }

    private void invokeOperation() {
        try {
            if (this.servant instanceof InvokeHandler) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invokeOperation on servant (stream based)");
                }
                if (specialOperations.containsKey(this.request.operation())) {
                    ((ServantDelegate)this.servant._get_delegate())._invoke(this.servant, this.request.operation(), this.request.getInputStream(), this.request);
                } else {
                    ((InvokeHandler)((Object)this.servant))._invoke(this.request.operation(), this.request.getInputStream(), this.request);
                }
            } else if (this.servant instanceof DynamicImplementation) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke operation on servant (dsi based)");
                }
                if (specialOperations.containsKey(this.request.operation()) && !(this.servant instanceof Forwarder)) {
                    ((ServantDelegate)this.servant._get_delegate())._invoke(this.servant, this.request.operation(), this.request.getInputStream(), this.request);
                } else {
                    ((DynamicImplementation)this.servant).invoke(this.request);
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " unknown servant type (neither stream nor dsi based)");
            }
        }
        catch (SystemException systemException) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invocation: system exception was thrown (" + systemException.getMessage() + ")");
            }
            this.request.setSystemException(systemException);
        }
        catch (Throwable throwable) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invocation: throwable was thrown, " + throwable.getMessage());
            }
            this.request.setSystemException(new UNKNOWN(throwable.getMessage()));
        }
    }

    private void invokePostInvoke() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke postinvoke on servant locator");
            }
            ((ServantLocator)this.servantManager).postinvoke(this.request.objectId(), this.controller.getPOA(), this.request.operation(), this.cookieHolder.value, this.servant);
        }
        catch (SystemException systemException) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " postinvoke: system exception was thrown (" + systemException.getMessage() + ")");
            }
            this.request.setSystemException(systemException);
        }
        catch (Throwable throwable) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " postinvoke: throwable was thrown" + throwable.getMessage());
            }
            this.request.setSystemException(new OBJ_ADAPTER());
        }
    }

    private void invokePreInvoke() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " invoke preinvoke on servant locator");
        }
        try {
            this.cookieHolder = new CookieHolder();
            this.servant = ((ServantLocator)this.servantManager).preinvoke(this.request.objectId(), this.controller.getPOA(), this.request.operation(), this.cookieHolder);
            if (this.servant == null) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: returns null");
                }
                this.request.setSystemException(new OBJ_ADAPTER());
            }
            this.controller.getORB().set_delegate(this.servant);
        }
        catch (SystemException systemException) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: system exception was thrown (" + systemException.getMessage() + ")");
            }
            this.request.setSystemException(systemException);
        }
        catch (org.omg.PortableServer.ForwardRequest forwardRequest) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: forward exception was thrown (" + forwardRequest.getMessage() + ")");
            }
            this.request.setLocationForward(forwardRequest);
        }
        catch (Throwable throwable) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " preinvoke: throwable was thrown, " + throwable.getMessage());
            }
            this.request.setSystemException(new OBJ_ADAPTER(throwable.getMessage()));
        }
    }

    boolean isActive() {
        return this.start;
    }

    private void process() {
        Object object;
        ServerRequestInfoImpl serverRequestInfoImpl = null;
        if (this.controller.getORB().hasServerRequestInterceptors()) {
            serverRequestInfoImpl = new ServerRequestInfoImpl(this.controller.getORB(), this.request, this.servant);
            object = this.controller.getORB().getInterceptorManager();
            serverRequestInfoImpl.current = ((InterceptorManager)object).getEmptyCurrent();
            if (!this.invokeInterceptors(serverRequestInfoImpl, (short)0)) {
                ReplyOutputStream replyOutputStream = this.request.getReplyOutputStream();
                Enumeration enumeration = serverRequestInfoImpl.getReplyServiceContexts();
                while (enumeration.hasMoreElements()) {
                    replyOutputStream.addServiceContext((ServiceContext)enumeration.nextElement());
                }
                return;
            }
            ((InterceptorManager)object).setTSCurrent(serverRequestInfoImpl.current);
        }
        if (Time.hasPassed(this.request.getRequestEndTime())) {
            this.request.setSystemException(new TIMEOUT("Request End Time exceeded", 0, CompletionStatus.COMPLETED_NO));
            return;
        }
        if (this.checkReplyEndTime && Time.hasPassed(this.request.getReplyEndTime())) {
            this.request.setSystemException(new TIMEOUT("Reply End Time exceeded", 0, CompletionStatus.COMPLETED_NO));
            return;
        }
        Time.waitFor(this.request.getRequestStartTime());
        if (this.servantManager != null) {
            if (this.servantManager instanceof ServantActivator) {
                this.invokeIncarnate();
            } else {
                this.invokePreInvoke();
            }
        }
        if (this.servant != null) {
            if (serverRequestInfoImpl != null) {
                serverRequestInfoImpl.setServant(this.servant);
                if (this.servant instanceof InvokeHandler) {
                    if (!this.invokeInterceptors(serverRequestInfoImpl, (short)1)) {
                        if (this.cookieHolder != null) {
                            this.invokePostInvoke();
                        }
                        object = this.request.getReplyOutputStream();
                        Enumeration enumeration = serverRequestInfoImpl.getReplyServiceContexts();
                        while (enumeration.hasMoreElements()) {
                            ((ServiceContextTransportingOutputStream)object).addServiceContext((ServiceContext)enumeration.nextElement());
                        }
                        return;
                    }
                } else if (this.servant instanceof DynamicImplementation) {
                    this.request.setServerRequestInfo(serverRequestInfoImpl);
                }
            }
            this.invokeOperation();
        }
        if (this.cookieHolder != null) {
            this.invokePostInvoke();
        }
        if (this.checkReplyEndTime && Time.hasPassed(this.request.getReplyEndTime())) {
            this.request.setSystemException(new TIMEOUT("Reply End Time exceeded after invocation", 0, CompletionStatus.COMPLETED_YES));
        }
        if (serverRequestInfoImpl != null) {
            object = this.controller.getORB().getInterceptorManager();
            serverRequestInfoImpl.current = ((InterceptorManager)object).getCurrent();
            int n = 0;
            switch (this.request.status().value()) {
                case 0: {
                    n = 2;
                    serverRequestInfoImpl.reply_status = 0;
                    break;
                }
                case 1: {
                    serverRequestInfoImpl.reply_status = (short)2;
                    SystemExceptionHelper.insert(serverRequestInfoImpl.sending_exception, new UNKNOWN("Stream-based UserExceptions are not available!"));
                    n = 3;
                    break;
                }
                case 2: {
                    serverRequestInfoImpl.reply_status = 1;
                    SystemExceptionHelper.insert(serverRequestInfoImpl.sending_exception, this.request.getSystemException());
                    n = 3;
                    break;
                }
                case 3: {
                    serverRequestInfoImpl.reply_status = (short)3;
                    n = 4;
                }
            }
            this.invokeInterceptors(serverRequestInfoImpl, (short)n);
            ReplyOutputStream replyOutputStream = this.request.get_out();
            Enumeration enumeration = serverRequestInfoImpl.getReplyServiceContexts();
            while (enumeration.hasMoreElements()) {
                replyOutputStream.addServiceContext((ServiceContext)enumeration.nextElement());
            }
            ((InterceptorManager)object).removeTSCurrent();
        }
    }

    private boolean invokeInterceptors(ServerRequestInfoImpl serverRequestInfoImpl, short s) {
        ServerInterceptorIterator serverInterceptorIterator = this.controller.getORB().getInterceptorManager().getServerIterator();
        try {
            serverInterceptorIterator.iterate(serverRequestInfoImpl, s);
        }
        catch (UserException userException) {
            if (userException instanceof ForwardRequest) {
                ForwardRequest forwardRequest = (ForwardRequest)userException;
                this.request.setLocationForward(new org.omg.PortableServer.ForwardRequest(forwardRequest.forward));
            }
            return false;
        }
        catch (SystemException systemException) {
            this.request.setSystemException(systemException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.terminate) {
            RequestProcessor requestProcessor = this;
            synchronized (requestProcessor) {
                while (!this.start) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!this.terminate) continue;
                    return;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " starts with request processing");
            }
            if (this.request.syncScope() == 2) {
                this.controller.returnResult(this.request);
                this.process();
            } else {
                this.process();
                this.controller.returnResult(this.request);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("rid: " + this.request.requestId() + " opname: " + this.request.operation() + " ends with request processing");
            }
            this.controller.finish(this.request);
            this.start = false;
            this.clear();
            this.poolManager.releaseProcessor(this);
        }
    }

    static {
        count = 0;
        specialOperations = new HashMap(50);
        specialOperations.put("_is_a", "");
        specialOperations.put("_interface", "");
        specialOperations.put("_non_existent", "");
        specialOperations.put("_get_policy", "");
        specialOperations.put("_set_policy_overrides", "");
    }
}

