/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;

public class SSLSocketFactory
implements org.jacorb.orb.factory.SocketFactory,
Configurable {
    private SocketFactory factory = null;
    private String[] cipher_suites = null;
    private boolean trusteesFromKS = false;
    private short clientSupportedOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private Logger logger;

    public SSLSocketFactory(ORB oRB) throws ConfigurationException {
        this.configure((Configuration)oRB.getConfiguration());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        StringTokenizer stringTokenizer;
        int n;
        block6: {
            this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.jsse");
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore", "UNSET");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password", "UNSET");
            this.clientSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.client.supported_options", "0"), 16);
            try {
                this.factory = this.createSocketFactory();
            }
            catch (Exception exception) {
                if (!this.logger.isWarnEnabled()) break block6;
                this.logger.warn("Exception", (Throwable)exception);
            }
        }
        if (this.factory == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Unable to create SSLSocketFactory!");
            }
            throw new ConfigurationException("Unable to create ServerSocketFactory!");
        }
        String string = configuration.getAttribute("jacorb.security.ssl.server.cipher_suites", null);
        if (string != null && (n = (stringTokenizer = new StringTokenizer(string, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[n];
            while (stringTokenizer.hasMoreElements()) {
                this.cipher_suites[--n] = stringTokenizer.nextToken();
            }
        }
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        SSLSocket sSLSocket = (SSLSocket)this.factory.createSocket(string, n);
        String[] stringArray = new String[]{"SSLv3"};
        sSLSocket.setEnabledProtocols(stringArray);
        if (this.cipher_suites != null) {
            sSLSocket.setEnabledCipherSuites(this.cipher_suites);
        }
        return sSLSocket;
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() throws IOException, GeneralSecurityException {
        KeyManagerFactory keyManagerFactory = null;
        KeyStore keyStore = null;
        if (this.trusteesFromKS || (this.clientSupportedOptions & 0x40) != 0) {
            keyStore = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray());
            if ((this.clientSupportedOptions & 0x40) != 0) {
                keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                keyManagerFactory.init(keyStore, this.keystore_passphrase.toCharArray());
            }
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        if (keyStore != null && this.trusteesFromKS) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Loading certs from keystore " + keyStore);
            }
            trustManagerFactory.init(keyStore);
        } else {
            trustManagerFactory.init((KeyStore)null);
        }
        SSLContext sSLContext = SSLContext.getInstance("SSLv3");
        sSLContext.init(keyManagerFactory == null ? null : keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        return sSLContext.getSocketFactory();
    }
}

