/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import bmsi.util.Diff;
import bmsi.util.DiffPrint;
import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.TextUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Category;

public class DifferenceEngine {
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$DifferenceEngine == null ? (class$com$ecyrd$jspwiki$DifferenceEngine = DifferenceEngine.class$("com.ecyrd.jspwiki.DifferenceEngine")) : class$com$ecyrd$jspwiki$DifferenceEngine));
    public static final String PROP_DIFFCOMMAND = "jspwiki.diffCommand";
    private static final char DIFF_ADDED_SYMBOL = '+';
    private static final char DIFF_REMOVED_SYMBOL = '-';
    private static final String CSS_DIFF_ADDED = "<tr><td bgcolor=\"#99FF99\" class=\"diffadd\">";
    private static final String CSS_DIFF_REMOVED = "<tr><td bgcolor=\"#FF9933\" class=\"diffrem\">";
    private static final String CSS_DIFF_UNCHANGED = "<tr><td class=\"diff\">";
    private static final String CSS_DIFF_CLOSE = "</td></tr>";
    private String m_diffCommand = null;
    private String m_encoding;
    private boolean m_useInternalDiff = true;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$DifferenceEngine;

    public DifferenceEngine(Properties props, String encoding) {
        this.m_diffCommand = props.getProperty(PROP_DIFFCOMMAND);
        this.m_useInternalDiff = this.m_diffCommand == null;
        this.m_encoding = encoding;
    }

    private String getContentEncoding() {
        return this.m_encoding;
    }

    public String makeDiff(String p1, String p2) {
        if (this.m_useInternalDiff) {
            return this.makeDiffWithBMSI(p1, p2);
        }
        return this.makeDiffWithProgram(p1, p2);
    }

    private String makeDiffWithBMSI(String p1, String p2) {
        try {
            Object[] first = DifferenceEngine.stringToArray(p1);
            Object[] second = DifferenceEngine.stringToArray(p2);
            Diff diff = new Diff(first, second);
            Diff.change script = diff.diff_2(false);
            if (script == null) {
                return "";
            }
            StringWriter sw = new StringWriter();
            WriterPrint p = new WriterPrint((String[])first, (String[])second, sw);
            p.print_script(script);
            return sw.toString();
        }
        catch (IOException e) {
            log.error((Object)"Diff failed", (Throwable)e);
            return null;
        }
    }

    private static String[] stringToArray(String str) throws IOException {
        String line;
        BufferedReader rdr = new BufferedReader(new StringReader(str));
        Vector<String> s = new Vector<String>();
        while ((line = rdr.readLine()) != null) {
            s.addElement(line);
        }
        Object[] a = new String[s.size()];
        s.copyInto(a);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String makeDiffWithProgram(String p1, String p2) {
        String diff;
        File f2;
        block9: {
            File f1 = null;
            f2 = null;
            diff = null;
            try {
                try {
                    f1 = FileUtil.newTmpFile(p1, this.getContentEncoding());
                    f2 = FileUtil.newTmpFile(p2, this.getContentEncoding());
                    String cmd = TextUtil.replaceString(this.m_diffCommand, "%s1", f1.getPath());
                    cmd = TextUtil.replaceString(cmd, "%s2", f2.getPath());
                    String output = FileUtil.runSimpleCommand(cmd, f1.getParent());
                    diff = new String(output.getBytes("ISO-8859-1"), this.getContentEncoding());
                }
                catch (IOException e) {
                    log.error((Object)"Failed to do file diff", (Throwable)e);
                    Object var9_11 = null;
                    if (f1 != null) {
                        f1.delete();
                    }
                    if (f2 == null) return diff;
                    f2.delete();
                    return diff;
                }
                catch (InterruptedException e) {
                    log.error((Object)"Interrupted", (Throwable)e);
                    Object var9_12 = null;
                    if (f1 != null) {
                        f1.delete();
                    }
                    if (f2 == null) return diff;
                    f2.delete();
                    return diff;
                }
                Object var9_10 = null;
                if (f1 == null) break block9;
                f1.delete();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                if (f1 != null) {
                    f1.delete();
                }
                if (f2 == null) throw throwable;
                f2.delete();
                throw throwable;
            }
        }
        if (f2 == null) return diff;
        f2.delete();
        return diff;
    }

    public String colorizeDiff(String diffText) throws IOException {
        String line = null;
        String start = null;
        String stop = null;
        if (diffText == null) {
            return "Invalid diff - probably something wrong with server setup.";
        }
        BufferedReader in = new BufferedReader(new StringReader(diffText));
        StringBuffer out = new StringBuffer();
        out.append("<table class=\"diff\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
        while ((line = in.readLine()) != null) {
            stop = CSS_DIFF_CLOSE;
            if (line.length() > 0) {
                switch (line.charAt(0)) {
                    case '+': {
                        start = CSS_DIFF_ADDED;
                        break;
                    }
                    case '-': {
                        start = CSS_DIFF_REMOVED;
                        break;
                    }
                    default: {
                        start = CSS_DIFF_UNCHANGED;
                        break;
                    }
                }
            } else {
                start = CSS_DIFF_UNCHANGED;
            }
            out.append(start);
            out.append(line.trim());
            out.append(stop + "\n");
        }
        out.append("</table>\n");
        return out.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class WriterPrint
    extends DiffPrint.NormalPrint {
        public WriterPrint(String[] a, String[] b, Writer w) {
            super(a, b);
            this.outfile = new PrintWriter(w);
        }

        protected void print_range_length(int a, int b) {
            this.outfile.print(b - a + 1);
        }

        protected void print_hunk(Diff.change hunk) {
            int i;
            this.analyze_hunk(hunk);
            if (this.deletes == 0 && this.inserts == 0) {
                return;
            }
            if (this.inserts != 0 && this.deletes == 0) {
                this.outfile.print("At line ");
                this.print_number_range('-', this.first0, this.last0);
                this.outfile.print(" added ");
                this.print_range_length(this.first1, this.last1);
                this.outfile.print(" line" + (this.last1 - this.first1 == 0 ? "." : "s."));
            } else if (this.deletes != 0 && this.inserts == 0) {
                this.outfile.print("Removed line" + (this.last0 - this.first0 == 0 ? " " : "s "));
                this.print_number_range('-', this.first0, this.last0);
            } else {
                if (this.last0 - this.first0 == 0) {
                    this.outfile.print("Line ");
                    this.print_number_range('-', this.first0, this.last0);
                    this.outfile.print(" was replaced by ");
                } else {
                    this.outfile.print("Lines ");
                    this.print_number_range('-', this.first0, this.last0);
                    this.outfile.print(" were replaced by ");
                }
                this.outfile.print("line" + (this.last1 - this.first1 == 0 ? " " : "s "));
                this.print_number_range('-', this.first1, this.last1);
            }
            this.outfile.println();
            if (this.deletes != 0) {
                for (i = this.first0; i <= this.last0; ++i) {
                    this.print_1_line("- ", this.file0[i]);
                }
            }
            if (this.inserts != 0) {
                for (i = this.first1; i <= this.last1; ++i) {
                    this.print_1_line("+ ", this.file1[i]);
                }
            }
        }
    }
}

