/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.PageLock;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.RepositoryModifiedException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;

public class PageManager {
    public static final String PROP_PAGEPROVIDER = "jspwiki.pageProvider";
    public static final String PROP_USECACHE = "jspwiki.usePageCache";
    public static final String PROP_LOCKEXPIRY = "jspwiki.lockExpiryTime";
    static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$PageManager == null ? (class$com$ecyrd$jspwiki$PageManager = PageManager.class$("com.ecyrd.jspwiki.PageManager")) : class$com$ecyrd$jspwiki$PageManager));
    private WikiPageProvider m_provider;
    private HashMap m_pageLocks = new HashMap();
    private WikiEngine m_engine;
    private boolean m_started;
    private Thread m_thread;
    private int m_expiryTime = 60;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$PageManager;

    public PageManager(WikiEngine engine, Properties props) throws WikiException {
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty(PROP_USECACHE));
        this.m_expiryTime = TextUtil.parseIntParameter(props.getProperty(PROP_LOCKEXPIRY), this.m_expiryTime);
        String classname = useCache ? "com.ecyrd.jspwiki.providers.CachingProvider" : props.getProperty(PROP_PAGEPROVIDER);
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiPageProvider)providerclass.newInstance();
            log.debug((Object)("Initializing page provider class " + this.m_provider));
            this.m_provider.initialize(props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new WikiException("no provider class");
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new WikiException("faulty provider class");
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new WikiException("illegal provider class");
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Provider did not found a property it was looking for: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)("An I/O exception occurred while trying to create a new page provider: " + classname), (Throwable)e);
            throw new WikiException("Unable to start page provider: " + e.getMessage());
        }
    }

    public void start() {
        this.m_started = true;
        this.m_thread = new LockReaper();
        this.m_thread.setPriority(1);
        this.m_thread.start();
    }

    public void stop() {
        this.m_started = false;
        this.m_thread.interrupt();
    }

    public WikiPageProvider getProvider() {
        return this.m_provider;
    }

    public Collection getAllPages() throws ProviderException {
        return this.m_provider.getAllPages();
    }

    public String getPageText(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        String text = null;
        try {
            text = this.m_provider.getPageText(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            log.info((Object)("Repository has been modified externally while fetching page " + pageName));
            WikiPage p = new WikiPage(pageName);
            this.m_engine.updateReferences(p);
            text = this.m_provider.getPageText(pageName, version);
        }
        return text;
    }

    public void putPageText(WikiPage page, String content) throws ProviderException {
        if (page == null || page.getName() == null || page.getName().length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        this.m_provider.putPageText(page, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageLock lockPage(WikiPage page, String user) {
        PageLock lock = null;
        HashMap hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            lock = (PageLock)this.m_pageLocks.get(page.getName());
            if (lock == null) {
                Date d = new Date();
                lock = new PageLock(page, user, d, new Date(d.getTime() + (long)(this.m_expiryTime * 60) * 1000L));
                this.m_pageLocks.put(page.getName(), lock);
                log.debug((Object)("Locked page " + page.getName() + " for " + user));
            } else {
                log.debug((Object)("Page " + page.getName() + " already locked by " + lock.getLocker()));
                lock = null;
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockPage(PageLock lock) {
        if (lock == null) {
            return;
        }
        HashMap hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            PageLock old = (PageLock)this.m_pageLocks.remove(lock.getPage().getName());
            log.debug((Object)("Unlocked page " + lock.getPage().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageLock getCurrentLock(WikiPage page) {
        PageLock lock = null;
        HashMap hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            lock = (PageLock)this.m_pageLocks.get(page.getName());
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveLocks() {
        ArrayList result = new ArrayList();
        HashMap hashMap = this.m_pageLocks;
        synchronized (hashMap) {
            Iterator i = this.m_pageLocks.values().iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
        return result;
    }

    public Collection findPages(QueryItem[] query) {
        return this.m_provider.findPages(query);
    }

    public WikiPage getPageInfo(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        WikiPage page = null;
        try {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            log.info((Object)("Repository has been modified externally while fetching info for " + pageName));
            WikiPage p = new WikiPage(pageName);
            this.m_engine.updateReferences(p);
            page = this.m_provider.getPageInfo(pageName, version);
        }
        return page;
    }

    public List getVersionHistory(String pageName) throws ProviderException {
        if (this.pageExists(pageName)) {
            return this.m_provider.getVersionHistory(pageName);
        }
        return null;
    }

    public String getProviderDescription() {
        return this.m_provider.getProviderInfo();
    }

    public int getTotalPageCount() {
        try {
            return this.m_provider.getAllPages().size();
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to count pages: ", (Throwable)e);
            return -1;
        }
    }

    public boolean pageExists(String pageName) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        return this.m_provider.pageExists(pageName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LockReaper
    extends Thread {
        private LockReaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            log.info((Object)"LockReaper start");
            while (PageManager.this.m_started) {
                try {
                    Thread.sleep(60000L);
                    HashMap hashMap = PageManager.this.m_pageLocks;
                    synchronized (hashMap) {
                        Collection entries = PageManager.this.m_pageLocks.values();
                        Date now = new Date();
                        Iterator i = entries.iterator();
                        while (i.hasNext()) {
                            PageLock p = (PageLock)i.next();
                            if (!now.after(p.getExpiryTime())) continue;
                            i.remove();
                            log.debug((Object)("Reaped lock: " + p.getPage().getName() + " by " + p.getLocker() + ", acquired " + p.getAcquisitionTime() + ", and expired " + p.getExpiryTime()));
                        }
                    }
                }
                catch (Throwable throwable) {
                }
            }
            log.info((Object)"LockReaper stop");
        }
    }
}

