/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Category;

public class ReferenceManager {
    private HashMap m_refersTo;
    private HashMap m_referredBy;
    private WikiEngine m_engine;
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$ReferenceManager == null ? (class$com$ecyrd$jspwiki$ReferenceManager = ReferenceManager.class$("com.ecyrd.jspwiki.ReferenceManager")) : class$com$ecyrd$jspwiki$ReferenceManager));
    static /* synthetic */ Class class$com$ecyrd$jspwiki$ReferenceManager;

    public ReferenceManager(WikiEngine engine, Collection pages) {
        log.debug((Object)("Initializing new ReferenceManager with " + pages.size() + " initial pages."));
        this.m_refersTo = new HashMap();
        this.m_referredBy = new HashMap();
        this.m_engine = engine;
        this.buildKeyLists(pages);
    }

    public synchronized void updateReferences(String page, Collection references) {
        Collection oldRefTo = (Collection)this.m_refersTo.get(page);
        this.m_refersTo.remove(page);
        this.m_refersTo.put(page, references);
        if (!this.m_referredBy.containsKey(page)) {
            this.m_referredBy.put(page, new HashSet());
        }
        this.cleanReferredBy(page, oldRefTo, references);
        Iterator it = references.iterator();
        while (it.hasNext()) {
            String referredPageName = (String)it.next();
            this.updateReferredBy(referredPageName, page);
        }
    }

    private void cleanReferredBy(String referrer, Collection oldReferred, Collection newReferred) {
        if (oldReferred == null) {
            return;
        }
        Iterator it = oldReferred.iterator();
        while (it.hasNext()) {
            String referredPage = (String)it.next();
            HashSet oldRefBy = (HashSet)this.m_referredBy.get(referredPage);
            if (oldRefBy != null) {
                oldRefBy.remove(referrer);
            }
            if (oldRefBy != null && !oldRefBy.isEmpty() || this.m_engine.pageExists(referredPage)) continue;
            this.m_referredBy.remove(referredPage);
        }
    }

    private synchronized void buildKeyLists(Collection pages) {
        this.m_refersTo.clear();
        this.m_referredBy.clear();
        if (pages == null) {
            return;
        }
        Iterator it = pages.iterator();
        try {
            while (it.hasNext()) {
                WikiPage page = (WikiPage)it.next();
                this.m_referredBy.put(page.getName(), new HashSet());
                this.m_refersTo.put(page.getName(), null);
            }
        }
        catch (ClassCastException e) {
            log.fatal((Object)"Invalid collection entry in ReferenceManager.buildKeyLists().", (Throwable)e);
        }
    }

    private void updateReferredBy(String page, String referrer) {
        if (page.equals(referrer)) {
            return;
        }
        HashSet<String> referrers = (HashSet<String>)this.m_referredBy.get(page);
        if (referrers == null) {
            referrers = new HashSet<String>();
            this.m_referredBy.put(page, referrers);
        }
        referrers.add(referrer);
    }

    public synchronized Collection findUnreferenced() {
        ArrayList<String> unref = new ArrayList<String>();
        Set keys = this.m_referredBy.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            HashSet refs = (HashSet)this.m_referredBy.get(key);
            if (refs != null && !refs.isEmpty()) continue;
            unref.add(key);
        }
        return unref;
    }

    public synchronized Collection findUncreated() {
        HashSet<String> uncreated = new HashSet<String>();
        Collection allReferences = this.m_refersTo.values();
        Iterator it = allReferences.iterator();
        while (it.hasNext()) {
            Collection refs = (Collection)it.next();
            if (refs == null) continue;
            Iterator rit = refs.iterator();
            while (rit.hasNext()) {
                String aReference = (String)rit.next();
                if (this.m_engine.pageExists(aReference)) continue;
                uncreated.add(aReference);
            }
        }
        return uncreated;
    }

    public synchronized Collection findReferrers(String pagename) {
        HashSet refs = (HashSet)this.m_referredBy.get(pagename);
        if (refs == null || refs.isEmpty()) {
            return null;
        }
        return refs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

