/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Properties;

public class TextUtil {
    static final String HEX_DIGITS = "0123456789ABCDEF";
    private static final int EOI = 0;
    private static final int LOWER = 1;
    private static final int UPPER = 2;
    private static final int DIGIT = 3;
    private static final int OTHER = 4;

    protected static String urlEncode(byte[] rs) {
        StringBuffer result = new StringBuffer();
        block4: for (int i = 0; i < rs.length; ++i) {
            char c = (char)rs[i];
            switch (c) {
                case '*': 
                case '-': 
                case '.': 
                case '_': {
                    result.append(c);
                    continue block4;
                }
                case ' ': {
                    result.append('+');
                    continue block4;
                }
                default: {
                    if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                        result.append(c);
                        continue block4;
                    }
                    result.append('%');
                    result.append(HEX_DIGITS.charAt((c & 0xF0) >> 4));
                    result.append(HEX_DIGITS.charAt(c & 0xF));
                }
            }
        }
        return result.toString();
    }

    protected static String urlDecode(byte[] bytes) throws UnsupportedEncodingException, IllegalArgumentException {
        if (bytes == null) {
            return null;
        }
        byte[] decodeBytes = new byte[bytes.length];
        int decodedByteCount = 0;
        try {
            block8: for (int count = 0; count < bytes.length; ++count) {
                switch (bytes[count]) {
                    case 43: {
                        decodeBytes[decodedByteCount++] = 32;
                        continue block8;
                    }
                    case 37: {
                        decodeBytes[decodedByteCount++] = (byte)((HEX_DIGITS.indexOf(bytes[++count]) << 4) + HEX_DIGITS.indexOf(bytes[++count]));
                        continue block8;
                    }
                    default: {
                        decodeBytes[decodedByteCount++] = bytes[count];
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException ae) {
            throw new IllegalArgumentException("Malformed UTF-8 string?");
        }
        String processedPageName = null;
        try {
            processedPageName = new String(decodeBytes, 0, decodedByteCount, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedEncodingException("UTF-8 encoding not supported on this platform");
        }
        return processedPageName.toString();
    }

    public static String urlEncodeUTF8(String text) {
        byte[] rs = new byte[]{};
        try {
            rs = text.getBytes("UTF-8");
            return TextUtil.urlEncode(rs);
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(text);
        }
    }

    public static String urlDecodeUTF8(String utf8) {
        String rs = null;
        try {
            rs = TextUtil.urlDecode(utf8.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            rs = URLDecoder.decode(utf8);
        }
        return rs;
    }

    public static String urlEncode(String data, String encoding) {
        if ("UTF-8".equals(encoding)) {
            return TextUtil.urlEncodeUTF8(data);
        }
        return TextUtil.urlEncode(data.getBytes());
    }

    public static String urlDecode(String data, String encoding) throws UnsupportedEncodingException, IllegalArgumentException {
        if ("UTF-8".equals(encoding)) {
            return TextUtil.urlDecodeUTF8(data);
        }
        return TextUtil.urlDecode(data.getBytes());
    }

    public static String replaceEntities(String src) {
        src = TextUtil.replaceString(src, "<", "&lt;");
        src = TextUtil.replaceString(src, ">", "&gt;");
        src = TextUtil.replaceString(src, "\"", "&quot;");
        return src;
    }

    public static String replaceString(String orig, String src, String dest) {
        int start;
        if (orig == null) {
            return null;
        }
        StringBuffer res = new StringBuffer();
        int end = 0;
        int last = 0;
        while ((start = orig.indexOf(src, end)) != -1) {
            res.append(orig.substring(last, start));
            res.append(dest);
            end = start + src.length();
            last = start + src.length();
        }
        res.append(orig.substring(end));
        return res.toString();
    }

    public static String replaceString(String orig, int start, int end, String text) {
        if (orig == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(orig);
        buf.replace(start, end, text);
        return buf.toString();
    }

    public static int parseIntParameter(String value, int defvalue) {
        int val = defvalue;
        try {
            val = Integer.parseInt(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    public static int getIntegerProperty(Properties props, String key, int defVal) {
        String val = props.getProperty(key);
        return TextUtil.parseIntParameter(val, defVal);
    }

    public static boolean getBooleanProperty(Properties props, String key, boolean defval) {
        String val = props.getProperty(key);
        if (val == null) {
            return defval;
        }
        return TextUtil.isPositive(val);
    }

    public static boolean isPositive(String val) {
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true") || val.equalsIgnoreCase("on") || val.equalsIgnoreCase("yes");
    }

    public static String normalizePostData(String postData) {
        StringBuffer sb = new StringBuffer();
        block4: for (int i = 0; i < postData.length(); ++i) {
            switch (postData.charAt(i)) {
                case '\n': {
                    sb.append("\r\n");
                    continue block4;
                }
                case '\r': {
                    sb.append("\r\n");
                    if (i >= postData.length() - 1 || postData.charAt(i + 1) != '\n') continue block4;
                    ++i;
                    continue block4;
                }
                default: {
                    sb.append(postData.charAt(i));
                }
            }
        }
        if (sb.length() < 2 || !sb.substring(sb.length() - 2).equals("\r\n")) {
            sb.append("\r\n");
        }
        return sb.toString();
    }

    private static int getCharKind(int c) {
        if (c == -1) {
            return 0;
        }
        char ch = (char)c;
        if (Character.isLowerCase(ch)) {
            return 1;
        }
        if (Character.isUpperCase(ch)) {
            return 2;
        }
        if (Character.isDigit(ch)) {
            return 3;
        }
        return 4;
    }

    public static String beautifyString(String s) {
        StringBuffer result = new StringBuffer();
        if (s == null || s.length() == 0) {
            return "";
        }
        int cur = s.charAt(0);
        int curKind = TextUtil.getCharKind(cur);
        int prevKind = 1;
        int nextKind = -1;
        int next = -1;
        int nextPos = 1;
        while (curKind != 0) {
            next = nextPos < s.length() ? (int)s.charAt(nextPos++) : -1;
            nextKind = TextUtil.getCharKind(next);
            if (prevKind == 2 && curKind == 2 && nextKind == 1) {
                result.append(' ');
                result.append((char)cur);
            } else {
                result.append((char)cur);
                if (curKind == 2 && nextKind == 3 || curKind == 1 && (nextKind == 3 || nextKind == 2) || curKind == 3 && (nextKind == 2 || nextKind == 1)) {
                    result.append(' ');
                }
            }
            prevKind = curKind;
            cur = next;
            curKind = nextKind;
        }
        return result.toString();
    }
}

