/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.StringTransmutator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.VariableManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.acl.AccessControlList;
import com.ecyrd.jspwiki.acl.AclEntryImpl;
import com.ecyrd.jspwiki.acl.AclImpl;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.permissions.WikiPermission;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.PluginManager;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class TranslatorReader
extends Reader {
    public static final int READ = 0;
    public static final int EDIT = 1;
    private static final int EMPTY = 2;
    private static final int LOCAL = 3;
    private static final int LOCALREF = 4;
    private static final int IMAGE = 5;
    private static final int EXTERNAL = 6;
    private static final int INTERWIKI = 7;
    private static final int IMAGELINK = 8;
    private static final int IMAGEWIKILINK = 9;
    public static final int ATTACHMENT = 10;
    private static final int ATTACHMENTIMAGE = 11;
    private static final int PUSHBACK_BUFFER_SIZE = 8;
    private PushbackReader m_in;
    private StringReader m_data = new StringReader("");
    private static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$TranslatorReader == null ? (class$com$ecyrd$jspwiki$TranslatorReader = TranslatorReader.class$("com.ecyrd.jspwiki.TranslatorReader")) : class$com$ecyrd$jspwiki$TranslatorReader));
    private boolean m_isbold = false;
    private boolean m_isitalic = false;
    private boolean m_isTypedText = false;
    private boolean m_istable = false;
    private boolean m_isPre = false;
    private boolean m_isPreSpan = false;
    private boolean m_isEscaping = false;
    private boolean m_isdefinition = false;
    private int m_listlevel = 0;
    private int m_numlistlevel = 0;
    private boolean m_isOpenParagraph = false;
    private String m_closeTag = null;
    private WikiEngine m_engine;
    private WikiContext m_context;
    private ArrayList m_localLinkMutatorChain = new ArrayList();
    private ArrayList m_externalLinkMutatorChain = new ArrayList();
    private ArrayList m_attachmentLinkMutatorChain = new ArrayList();
    private ArrayList m_inlineImagePatterns;
    private PatternMatcher m_inlineMatcher = new Perl5Matcher();
    private ArrayList m_linkMutators = new ArrayList();
    public static final String PROP_INLINEIMAGEPTRN = "jspwiki.translatorReader.inlinePattern";
    public static final String PROP_CAMELCASELINKS = "jspwiki.translatorReader.camelCaseLinks";
    public static final String PROP_PLAINURIS = "jspwiki.translatorReader.plainUris";
    public static final String PROP_USEOUTLINKIMAGE = "jspwiki.translatorReader.useOutlinkImage";
    public static final String PROP_ALLOWHTML = "jspwiki.translatorReader.allowHTML";
    private boolean m_camelCaseLinks = false;
    private boolean m_plainUris = false;
    private boolean m_useOutlinkImage = true;
    private boolean m_allowHTML = false;
    private PatternMatcher m_matcher = new Perl5Matcher();
    private PatternCompiler m_compiler = new Perl5Compiler();
    private Pattern m_camelCasePtrn;
    private HTMLRenderer m_renderer = new HTMLRenderer();
    public static final String DEFAULT_INLINEPATTERN = "*.png";
    private static final String WORD_SEPARATORS = ",.|;+=&()";
    private boolean m_parseAccessRules = true;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$TranslatorReader;

    public TranslatorReader(WikiContext context, Reader in) {
        GlobCompiler compiler = new GlobCompiler();
        ArrayList<Pattern> compiledpatterns = new ArrayList<Pattern>();
        this.m_in = new PushbackReader(new BufferedReader(in), 8);
        this.m_engine = context.getEngine();
        this.m_context = context;
        Collection ptrns = TranslatorReader.getImagePatterns(this.m_engine);
        Iterator i = ptrns.iterator();
        while (i.hasNext()) {
            try {
                compiledpatterns.add(compiler.compile((String)i.next()));
            }
            catch (MalformedPatternException e) {
                log.error((Object)"Malformed pattern in properties: ", (Throwable)e);
            }
        }
        this.m_inlineImagePatterns = compiledpatterns;
        try {
            this.m_camelCasePtrn = this.m_compiler.compile("^([[:^alnum:]]*|\\~)([[:upper:]]+[[:lower:]]+[[:upper:]]+[[:alnum:]]*)[[:^alnum:]]*$");
        }
        catch (MalformedPatternException e) {
            log.fatal((Object)"Internal error: Someone put in a faulty pattern.", (Throwable)e);
            throw new InternalWikiException("Faulty camelcasepattern in TranslatorReader");
        }
        Properties props = this.m_engine.getWikiProperties();
        String cclinks = (String)this.m_context.getPage().getAttribute(PROP_CAMELCASELINKS);
        this.m_camelCaseLinks = cclinks != null ? TextUtil.isPositive(cclinks) : TextUtil.getBooleanProperty(props, PROP_CAMELCASELINKS, this.m_camelCaseLinks);
        this.m_plainUris = TextUtil.getBooleanProperty(props, PROP_PLAINURIS, this.m_plainUris);
        this.m_useOutlinkImage = TextUtil.getBooleanProperty(props, PROP_USEOUTLINKIMAGE, this.m_useOutlinkImage);
        this.m_allowHTML = TextUtil.getBooleanProperty(props, PROP_ALLOWHTML, this.m_allowHTML);
    }

    public void addLinkTransmutator(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_linkMutators.add(mutator);
        }
    }

    public void addLocalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_localLinkMutatorChain.add(mutator);
        }
    }

    public void addExternalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_externalLinkMutatorChain.add(mutator);
        }
    }

    public void addAttachmentLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_attachmentLinkMutatorChain.add(mutator);
        }
    }

    public void disableAccessRules() {
        this.m_parseAccessRules = false;
    }

    protected static Collection getImagePatterns(WikiEngine engine) {
        Properties props = engine.getWikiProperties();
        ArrayList<String> ptrnlist = new ArrayList<String>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(PROP_INLINEIMAGEPTRN)) continue;
            String ptrn = props.getProperty(name);
            ptrnlist.add(ptrn);
        }
        if (ptrnlist.size() == 0) {
            ptrnlist.add(DEFAULT_INLINEPATTERN);
        }
        return ptrnlist;
    }

    private String linkExists(String page) {
        try {
            return this.m_engine.getFinalPageName(page);
        }
        catch (ProviderException e) {
            log.warn((Object)"TranslatorReader got a faulty page name!", (Throwable)e);
            return page;
        }
    }

    private String callMutatorChain(Collection list, String text) {
        if (list == null || list.size() == 0) {
            return text;
        }
        Iterator i = list.iterator();
        while (i.hasNext()) {
            StringTransmutator m = (StringTransmutator)i.next();
            text = m.mutate(this.m_context, text);
        }
        return text;
    }

    public String makeLink(int type, String link, String text) {
        if (text == null) {
            text = link;
        }
        text = this.callMutatorChain(this.m_linkMutators, text);
        return this.m_renderer.makeLink(type, link, text);
    }

    public static String cleanLink(String link) {
        StringBuffer clean = new StringBuffer();
        if (link == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(link, " -");
        while (st.hasMoreTokens()) {
            StringBuffer component = new StringBuffer(st.nextToken());
            component.setCharAt(0, Character.toUpperCase(component.charAt(0)));
            clean.append(component.toString());
        }
        for (int i = 0; i < clean.length(); ++i) {
            if (Character.isLetterOrDigit(clean.charAt(i)) || clean.charAt(i) == '_' || clean.charAt(i) == '.') continue;
            clean.deleteCharAt(i);
            --i;
        }
        return clean.toString();
    }

    private boolean isExternalLink(String link) {
        return link.startsWith("http:") || link.startsWith("ftp:") || link.startsWith("https:") || link.startsWith("mailto:") || link.startsWith("news:") || link.startsWith("file:");
    }

    private static boolean isAccessRule(String link) {
        return link.startsWith("{ALLOW") || link.startsWith("{DENY");
    }

    private static boolean isMemberList(String link) {
        return link.startsWith("{MEMBERS");
    }

    private boolean isImageLink(String link) {
        Iterator i = this.m_inlineImagePatterns.iterator();
        while (i.hasNext()) {
            if (!this.m_inlineMatcher.matches(link, (Pattern)i.next())) continue;
            return true;
        }
        return false;
    }

    private static boolean isMetadata(String link) {
        return link.startsWith("{SET");
    }

    private boolean isNumber(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() > 1 && s.charAt(0) == '-') {
            s = s.substring(1);
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private String checkForCamelCaseLink(String word) {
        PatternMatcherInput input = new PatternMatcherInput(word);
        if (this.m_matcher.contains(input, this.m_camelCasePtrn)) {
            MatchResult res = this.m_matcher.getMatch();
            int start = res.beginOffset(2);
            int end = res.endOffset(2);
            String link = res.group(2);
            if (res.group(1) != null && (res.group(1).equals("~") || res.group(1).indexOf(91) != -1)) {
                return null;
            }
            return link;
        }
        return null;
    }

    private String makeCamelCaseLink(String wikiname) {
        this.callMutatorChain(this.m_localLinkMutatorChain, wikiname);
        String matchedLink = this.linkExists(wikiname);
        String link = matchedLink != null ? this.makeLink(0, matchedLink, wikiname) : this.makeLink(1, wikiname, wikiname);
        return link;
    }

    private String makeDirectURILink(String url) {
        String last = "";
        if (url.endsWith(",") || url.endsWith(".")) {
            last = url.substring(url.length() - 1);
            url = url.substring(0, url.length() - 1);
        }
        this.callMutatorChain(this.m_externalLinkMutatorChain, url);
        String result = this.isImageLink(url) ? this.handleImageLink(url, url, false) : this.makeLink(6, url, url) + this.outlinkImage();
        result = result + last;
        return result;
    }

    private String handleImageLink(String reallink, String link, boolean hasLinkText) {
        String possiblePage = TranslatorReader.cleanLink(link);
        String res = "";
        if (this.isExternalLink(link) && hasLinkText) {
            res = this.makeLink(8, reallink, link);
        } else {
            String matchedLink = this.linkExists(possiblePage);
            if (matchedLink != null && hasLinkText) {
                this.callMutatorChain(this.m_localLinkMutatorChain, possiblePage);
                res = this.makeLink(9, reallink, link);
            } else {
                res = this.makeLink(5, reallink, link);
            }
        }
        return res;
    }

    private final String outlinkImage() {
        if (this.m_useOutlinkImage) {
            return "<img class=\"outlink\" src=\"" + this.m_engine.getBaseURL() + "images/out.png\" alt=\"\" />";
        }
        return "";
    }

    private String handleMemberList(String memberLine) {
        if (!this.m_parseAccessRules) {
            return "";
        }
        log.debug((Object)("Parsing member list: " + memberLine));
        UserManager mgr = this.m_context.getEngine().getUserManager();
        WikiPage page = this.m_context.getPage();
        StringTokenizer tok = new StringTokenizer(memberLine, ", {}");
        tok.nextToken();
        ArrayList<String> members = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String uid = tok.nextToken();
            log.debug((Object)("  Adding member: " + uid));
            members.add(uid);
        }
        page.setAttribute("_members", members);
        return "";
    }

    private String handleAccessRule(String ruleLine) {
        if (!this.m_parseAccessRules) {
            return "";
        }
        WikiPage page = this.m_context.getPage();
        AccessControlList acl = page.getAcl();
        UserManager mgr = this.m_context.getEngine().getUserManager();
        if (acl == null) {
            acl = new AclImpl();
        }
        if (ruleLine.startsWith("{")) {
            ruleLine = ruleLine.substring(1);
        }
        if (ruleLine.endsWith("}")) {
            ruleLine = ruleLine.substring(0, ruleLine.length() - 1);
        }
        log.debug((Object)("page=" + page.getName() + ", ACL = " + ruleLine));
        try {
            StringTokenizer fieldToks = new StringTokenizer(ruleLine);
            String policy = fieldToks.nextToken();
            String chain = fieldToks.nextToken();
            while (fieldToks.hasMoreTokens()) {
                AclEntry oldEntry;
                String roleOrPerm = fieldToks.nextToken(",").trim();
                boolean isNegative = true;
                Principal principal = mgr.getPrincipal(roleOrPerm);
                if (policy.equals("ALLOW")) {
                    isNegative = false;
                }
                if ((oldEntry = acl.getEntry(principal, isNegative)) != null) {
                    log.debug((Object)("Adding to old acl list: " + principal + ", " + chain));
                    oldEntry.addPermission((Permission)WikiPermission.newInstance(chain));
                    continue;
                }
                log.debug((Object)("Adding new acl entry for " + chain));
                AclEntryImpl entry = new AclEntryImpl();
                entry.setPrincipal(principal);
                if (isNegative) {
                    entry.setNegativePermissions();
                }
                entry.addPermission(WikiPermission.newInstance(chain));
                acl.addEntry(principal, entry);
            }
            page.setAcl(acl);
            log.debug((Object)acl.toString());
        }
        catch (NoSuchElementException nsee) {
            log.warn((Object)("Invalid access rule: " + ruleLine + " - defaults will be used."));
            return this.m_renderer.makeError("Invalid access rule: " + ruleLine);
        }
        catch (NotOwnerException noe) {
            throw new InternalWikiException("Someone has implemented access control on access control lists without telling me.");
        }
        catch (IllegalArgumentException iae) {
            return this.m_renderer.makeError("Invalid permission type: " + ruleLine);
        }
        return "";
    }

    private String handleMetadata(String link) {
        try {
            String args = link.substring(link.indexOf(32), link.length() - 1);
            String name = args.substring(0, args.indexOf(61));
            String val = args.substring(args.indexOf(61) + 1, args.length());
            name = name.trim();
            val = val.trim();
            if (name.length() > 0 && val.length() > 0) {
                this.m_context.getPage().setAttribute(name, val);
            }
        }
        catch (Exception e) {
            this.m_renderer.makeError(" Invalid SET found: " + link);
        }
        return "";
    }

    private String handleHyperlinks(String link) {
        String reallink;
        StringBuffer sb = new StringBuffer();
        if (TranslatorReader.isMemberList(link)) {
            return this.handleMemberList(link);
        }
        if (TranslatorReader.isAccessRule(link)) {
            return this.handleAccessRule(link);
        }
        if (TranslatorReader.isMetadata(link)) {
            return this.handleMetadata(link);
        }
        if (PluginManager.isPluginLink(link)) {
            String included;
            try {
                included = this.m_engine.getPluginManager().execute(this.m_context, link);
            }
            catch (PluginException e) {
                log.error((Object)"Failed to insert plugin", (Throwable)e);
                log.error((Object)"Root cause:", e.getRootThrowable());
                included = this.m_renderer.makeError("Plugin insertion failed: " + e.getMessage());
            }
            sb.append(included);
            return sb.toString();
        }
        int cutpoint = (link = TextUtil.replaceEntities(link)).indexOf(124);
        if (cutpoint != -1) {
            reallink = link.substring(cutpoint + 1).trim();
            link = link.substring(0, cutpoint);
        } else {
            reallink = link.trim();
        }
        int interwikipoint = -1;
        if (VariableManager.isVariableLink(link)) {
            String value;
            try {
                value = this.m_engine.getVariableManager().parseAndGetValue(this.m_context, link);
            }
            catch (NoSuchVariableException e) {
                value = this.m_renderer.makeError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                value = this.m_renderer.makeError(e.getMessage());
            }
            sb.append(value);
        } else if (this.isExternalLink(reallink)) {
            this.callMutatorChain(this.m_externalLinkMutatorChain, reallink);
            if (this.isImageLink(reallink)) {
                sb.append(this.handleImageLink(reallink, link, cutpoint != -1));
            } else {
                sb.append(this.makeLink(6, reallink, link));
                sb.append(this.outlinkImage());
            }
        } else {
            interwikipoint = reallink.indexOf(":");
            if (interwikipoint != -1) {
                String extWiki = reallink.substring(0, interwikipoint);
                String wikiPage = reallink.substring(interwikipoint + 1);
                String urlReference = this.m_engine.getInterWikiURL(extWiki);
                if (urlReference != null) {
                    urlReference = TextUtil.replaceString(urlReference, "%s", wikiPage);
                    this.callMutatorChain(this.m_externalLinkMutatorChain, urlReference);
                    sb.append(this.makeLink(7, urlReference, link));
                    if (this.isExternalLink(urlReference)) {
                        sb.append(this.outlinkImage());
                    }
                } else {
                    sb.append(link + " " + this.m_renderer.makeError("No InterWiki reference defined in properties for Wiki called '" + extWiki + "'!)"));
                }
            } else if (reallink.startsWith("#")) {
                sb.append(this.makeLink(3, reallink, link));
            } else if (this.isNumber(reallink)) {
                sb.append(this.makeLink(4, reallink, link));
            } else {
                String attachment = this.findAttachment(reallink);
                if (attachment != null) {
                    this.callMutatorChain(this.m_attachmentLinkMutatorChain, attachment);
                    if (this.isImageLink(reallink)) {
                        attachment = this.m_engine.getAttachmentURL(attachment);
                        sb.append(this.handleImageLink(attachment, link, cutpoint != -1));
                    } else {
                        sb.append(this.makeLink(10, attachment, link));
                    }
                } else {
                    reallink = TranslatorReader.cleanLink(reallink);
                    this.callMutatorChain(this.m_localLinkMutatorChain, reallink);
                    String matchedLink = this.linkExists(reallink);
                    if (matchedLink != null) {
                        sb.append(this.makeLink(0, matchedLink, link));
                    } else {
                        sb.append(this.makeLink(1, reallink, link));
                    }
                }
            }
        }
        return sb.toString();
    }

    private String findAttachment(String link) {
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        WikiPage currentPage = this.m_context.getPage();
        Attachment att = null;
        try {
            att = mgr.getAttachmentInfo(this.m_context, link);
        }
        catch (ProviderException e) {
            log.warn((Object)"Finding attachments failed: ", (Throwable)e);
            return null;
        }
        if (att != null) {
            return att.getName();
        }
        if (link.indexOf(47) != -1) {
            return link;
        }
        return null;
    }

    private String closeAll() {
        StringBuffer buf = new StringBuffer();
        if (this.m_isbold) {
            buf.append("</b>");
            this.m_isbold = false;
        }
        if (this.m_isitalic) {
            buf.append("</i>");
            this.m_isitalic = false;
        }
        if (this.m_isTypedText) {
            buf.append("</tt>");
            this.m_isTypedText = false;
        }
        while (this.m_listlevel > 0) {
            buf.append("</ul>\n");
            --this.m_listlevel;
        }
        while (this.m_numlistlevel > 0) {
            buf.append("</ol>\n");
            --this.m_numlistlevel;
        }
        if (this.m_isPre) {
            buf.append("</pre>\n");
            this.m_isEscaping = false;
            this.m_isPre = false;
        }
        if (this.m_isPreSpan) {
            buf.append("</span>");
            this.m_isEscaping = false;
            this.m_isPreSpan = false;
        }
        if (this.m_istable) {
            buf.append("</table>");
            this.m_istable = false;
        }
        if (this.m_isOpenParagraph) {
            buf.append("</p>");
            this.m_isOpenParagraph = false;
        }
        return buf.toString();
    }

    private int countChar(String line, int startPos, char c) {
        int count = 0;
        while (startPos + count < line.length() && line.charAt(count + startPos) == c) {
            ++count;
        }
        return count;
    }

    private String repeatChar(char c, int n) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }

    private int nextToken() throws IOException {
        return this.m_in.read();
    }

    private void pushBack(int c) throws IOException {
        if (c != -1) {
            this.m_in.unread(c);
        }
    }

    private String handleBackslash() throws IOException {
        int ch = this.nextToken();
        if (ch == 92) {
            int ch2 = this.nextToken();
            if (ch2 == 92) {
                return "<br clear=\"all\" />";
            }
            this.pushBack(ch2);
            return "<br />";
        }
        this.pushBack(ch);
        return "\\";
    }

    private String handleUnderscore() throws IOException {
        int ch = this.nextToken();
        String res = "_";
        if (ch == 95) {
            res = this.m_isbold ? "</b>" : "<b>";
            this.m_isbold = !this.m_isbold;
        } else {
            this.pushBack(ch);
        }
        return res;
    }

    private String handleApostrophe() throws IOException {
        int ch = this.nextToken();
        String res = "'";
        if (ch == 39) {
            res = this.m_isitalic ? "</i>" : "<i>";
            this.m_isitalic = !this.m_isitalic;
        } else {
            this.m_in.unread(ch);
        }
        return res;
    }

    private String handleOpenbrace(boolean isBlock) throws IOException {
        int ch = this.nextToken();
        String res = "{";
        if (ch == 123) {
            int ch2 = this.nextToken();
            if (ch2 == 123) {
                if (isBlock) {
                    res = "<pre>";
                    this.m_isPre = true;
                } else {
                    res = "<span style=\"font-family:monospace; whitespace:pre;\">";
                    this.m_isPreSpan = true;
                }
                this.m_isEscaping = true;
            } else {
                this.pushBack(ch2);
                res = "<tt>";
                this.m_isTypedText = true;
            }
        } else {
            this.pushBack(ch);
        }
        return res;
    }

    private String handleClosebrace() throws IOException {
        String res = "}";
        int ch2 = this.nextToken();
        if (ch2 == 125) {
            int ch3 = this.nextToken();
            if (ch3 == 125) {
                if (this.m_isPre) {
                    this.m_isPre = false;
                    this.m_isEscaping = false;
                    res = "</pre>";
                } else if (this.m_isPreSpan) {
                    this.m_isPreSpan = false;
                    this.m_isEscaping = false;
                    res = "</span>";
                } else {
                    res = "}}}";
                }
            } else {
                this.pushBack(ch3);
                if (!this.m_isEscaping) {
                    res = "</tt>";
                    this.m_isTypedText = false;
                } else {
                    this.pushBack(ch2);
                }
            }
        } else {
            this.pushBack(ch2);
        }
        return res;
    }

    private String handleDash() throws IOException {
        int ch = this.nextToken();
        if (ch == 45) {
            int ch2 = this.nextToken();
            if (ch2 == 45) {
                int ch3 = this.nextToken();
                if (ch3 == 45) {
                    while ((ch = this.nextToken()) == 45) {
                    }
                    this.pushBack(ch);
                    return "<hr />";
                }
                this.pushBack(ch3);
            }
            this.pushBack(ch2);
        }
        this.pushBack(ch);
        return "-";
    }

    private String handleHeading() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextToken();
        if (ch == 33) {
            int ch2 = this.nextToken();
            if (ch2 == 33) {
                buf.append("<h2>");
                this.m_closeTag = "</h2>";
            } else {
                buf.append("<h3>");
                this.m_closeTag = "</h3>";
                this.pushBack(ch2);
            }
        } else {
            buf.append("<h4>");
            this.m_closeTag = "</h4>";
            this.pushBack(ch);
        }
        return buf.toString();
    }

    private StringBuffer readUntilEOL() throws IOException {
        int ch;
        StringBuffer buf = new StringBuffer();
        while ((ch = this.nextToken()) != -1 && ch != 10) {
            buf.append((char)ch);
        }
        return buf;
    }

    private int countChars(PushbackReader in, char c) throws IOException {
        int ch;
        int count = 0;
        while ((ch = in.read()) != -1) {
            if ((char)ch == c) {
                ++count;
                continue;
            }
            in.unread(ch);
            break;
        }
        return count;
    }

    private String handleUnorderedList() throws IOException {
        int numBullets;
        StringBuffer buf = new StringBuffer();
        if (this.m_listlevel > 0) {
            buf.append("</li>\n");
        }
        if ((numBullets = this.countChars(this.m_in, '*') + 1) > this.m_listlevel) {
            while (this.m_listlevel < numBullets) {
                buf.append("<ul>\n");
                ++this.m_listlevel;
            }
        } else if (numBullets < this.m_listlevel) {
            while (this.m_listlevel > numBullets) {
                buf.append("</ul>\n");
                --this.m_listlevel;
            }
        }
        buf.append("<li>");
        return buf.toString();
    }

    private String handleOrderedList() throws IOException {
        int numBullets;
        StringBuffer buf = new StringBuffer();
        if (this.m_numlistlevel > 0) {
            buf.append("</li>\n");
        }
        if ((numBullets = this.countChars(this.m_in, '#') + 1) > this.m_numlistlevel) {
            while (this.m_numlistlevel < numBullets) {
                buf.append("<ol>\n");
                ++this.m_numlistlevel;
            }
        } else if (numBullets < this.m_numlistlevel) {
            while (this.m_numlistlevel > numBullets) {
                buf.append("</ol>\n");
                --this.m_numlistlevel;
            }
        }
        buf.append("<li>");
        return buf.toString();
    }

    private String handleDefinitionList() throws IOException {
        if (!this.m_isdefinition) {
            this.m_isdefinition = true;
            this.m_closeTag = "</dd>\n</dl>";
            return "<dl>\n<dt>";
        }
        return ";";
    }

    private String handleOpenbracket() throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        boolean isPlugin = false;
        while ((ch = this.nextToken()) == 91) {
            sb.append((char)ch);
        }
        if (ch == 123) {
            isPlugin = true;
        }
        this.pushBack(ch);
        if (sb.length() > 0) {
            return sb.toString();
        }
        ch = this.nextToken();
        while (ch != -1 && (ch != 93 || isPlugin && sb.charAt(sb.length() - 1) != '}')) {
            sb.append((char)ch);
            ch = this.nextToken();
        }
        if (ch == -1) {
            log.info((Object)"Warning: unterminated link detected!");
            return sb.toString();
        }
        return this.handleHyperlinks(sb.toString());
    }

    private String readUntil(String endChars) throws IOException {
        StringBuffer sb = new StringBuffer();
        int ch = this.nextToken();
        while (ch != -1) {
            if (ch == 92) {
                ch = this.nextToken();
                if (ch == -1) {
                    break;
                }
            } else if (endChars.indexOf((char)ch) != -1) {
                this.pushBack(ch);
                break;
            }
            sb.append((char)ch);
            ch = this.nextToken();
        }
        return sb.toString();
    }

    private String handleDiv(boolean newLine) throws IOException {
        int ch = this.nextToken();
        if (ch == 37) {
            StringBuffer sb = new StringBuffer();
            String style = null;
            String clazz = null;
            ch = this.nextToken();
            if (ch == 40) {
                style = this.readUntil(")");
                this.nextToken();
            } else if (Character.isLetter((char)ch)) {
                this.pushBack(ch);
                clazz = this.readUntil(" \t\n\r");
            } else {
                sb.append("\n</div>\n");
                return sb.toString();
            }
            sb.append("<div");
            sb.append(style != null ? " style=\"" + style + "\"" : "");
            sb.append(clazz != null ? " class=\"" + clazz + "\"" : "");
            sb.append(">");
            return sb.toString();
        }
        this.pushBack(ch);
        return "%";
    }

    private String handleBar(boolean newLine) throws IOException {
        int ch;
        StringBuffer sb = new StringBuffer();
        if (!this.m_istable && !newLine) {
            return "|";
        }
        if (newLine) {
            if (!this.m_istable) {
                sb.append("<table class=\"wikitable\" border=\"1\">\n");
                this.m_istable = true;
            }
            sb.append("<tr>");
            this.m_closeTag = "</td></tr>";
        }
        if ((ch = this.nextToken()) == 124) {
            if (!newLine) {
                sb.append("</th>");
            }
            sb.append("<th>");
            this.m_closeTag = "</th></tr>";
        } else {
            if (!newLine) {
                sb.append("</td>");
            }
            sb.append("<td>");
            this.pushBack(ch);
        }
        return sb.toString();
    }

    private String handleTilde() throws IOException {
        int ch = this.nextToken();
        if (ch == 124) {
            return "|";
        }
        if (Character.isUpperCase((char)ch)) {
            return String.valueOf((char)ch);
        }
        if (ch == 126) {
            return "~";
        }
        this.pushBack(ch);
        return "~";
    }

    private void fillBuffer() throws IOException {
        StringBuffer buf = new StringBuffer();
        StringBuffer word = null;
        int previousCh = -2;
        int start = 0;
        boolean quitReading = false;
        boolean newLine = true;
        while (!quitReading) {
            int ch = this.nextToken();
            String s = null;
            if (this.m_isEscaping) {
                if (ch == 125) {
                    buf.append(this.handleClosebrace());
                    continue;
                }
                if (ch == 60) {
                    buf.append("&lt;");
                    continue;
                }
                if (ch == 62) {
                    buf.append("&gt;");
                    continue;
                }
                if (ch == 38) {
                    buf.append("&amp;");
                    continue;
                }
                if (ch == -1) {
                    quitReading = true;
                    continue;
                }
                buf.append((char)ch);
                continue;
            }
            if (this.m_camelCaseLinks) {
                if (word == null && (Character.isWhitespace((char)previousCh) || WORD_SEPARATORS.indexOf((char)previousCh) != -1 || newLine) && !Character.isWhitespace((char)ch)) {
                    word = new StringBuffer();
                }
                if (word != null) {
                    if (Character.isWhitespace((char)ch) || ch == -1 || WORD_SEPARATORS.indexOf((char)ch) != -1) {
                        String potentialLink = word.toString();
                        String camelCase = this.checkForCamelCaseLink(potentialLink);
                        if (camelCase != null) {
                            start = buf.toString().lastIndexOf(camelCase);
                            buf.replace(start, start + camelCase.length(), this.makeCamelCaseLink(camelCase));
                        } else if (this.isExternalLink(potentialLink)) {
                            start = buf.toString().lastIndexOf(potentialLink);
                            String link = this.readUntil(" \t()[]{}!\"'");
                            link = potentialLink + (char)ch + link;
                            buf.replace(start, start + potentialLink.length(), this.makeDirectURILink(link));
                            ch = this.nextToken();
                        }
                        word = null;
                    } else {
                        word.append((char)ch);
                    }
                }
                previousCh = ch;
            }
            if (newLine && ch != 42 && ch != 32 && this.m_listlevel > 0) {
                buf.append("</li>\n");
                while (this.m_listlevel > 0) {
                    buf.append("</ul>\n");
                    --this.m_listlevel;
                }
            }
            if (newLine && ch != 35 && ch != 32 && this.m_numlistlevel > 0) {
                buf.append("</li>\n");
                while (this.m_numlistlevel > 0) {
                    buf.append("</ol>\n");
                    --this.m_numlistlevel;
                }
            }
            if (newLine && ch != 124 && this.m_istable) {
                buf.append("</table>\n");
                this.m_istable = false;
                this.m_closeTag = null;
            }
            switch (ch) {
                case 13: {
                    s = null;
                    break;
                }
                case 10: {
                    if (this.m_closeTag != null) {
                        buf.append(this.m_closeTag);
                        this.m_closeTag = null;
                    }
                    this.m_isdefinition = false;
                    if (newLine) {
                        if (this.m_isOpenParagraph) {
                            buf.append("</p>");
                        }
                        buf.append("<p>\n");
                        this.m_isOpenParagraph = true;
                        break;
                    }
                    buf.append("\n");
                    newLine = true;
                    break;
                }
                case 92: {
                    s = this.handleBackslash();
                    break;
                }
                case 95: {
                    s = this.handleUnderscore();
                    break;
                }
                case 39: {
                    s = this.handleApostrophe();
                    break;
                }
                case 123: {
                    s = this.handleOpenbrace(newLine);
                    break;
                }
                case 125: {
                    s = this.handleClosebrace();
                    break;
                }
                case 45: {
                    s = this.handleDash();
                    break;
                }
                case 33: {
                    if (newLine) {
                        s = this.handleHeading();
                        break;
                    }
                    s = "!";
                    break;
                }
                case 59: {
                    if (newLine) {
                        s = this.handleDefinitionList();
                        break;
                    }
                    s = ";";
                    break;
                }
                case 58: {
                    if (this.m_isdefinition) {
                        s = "</dt><dd>";
                        this.m_isdefinition = false;
                        break;
                    }
                    s = ":";
                    break;
                }
                case 91: {
                    s = this.handleOpenbracket();
                    break;
                }
                case 42: {
                    if (newLine) {
                        s = this.handleUnorderedList();
                        break;
                    }
                    s = "*";
                    break;
                }
                case 35: {
                    if (newLine) {
                        s = this.handleOrderedList();
                        break;
                    }
                    s = "#";
                    break;
                }
                case 124: {
                    s = this.handleBar(newLine);
                    break;
                }
                case 60: {
                    s = this.m_allowHTML ? "<" : "&lt;";
                    break;
                }
                case 62: {
                    s = this.m_allowHTML ? ">" : "&gt;";
                    break;
                }
                case 34: {
                    s = this.m_allowHTML ? "\"" : "&quot;";
                    break;
                }
                case 126: {
                    s = this.handleTilde();
                    break;
                }
                case 37: {
                    s = this.handleDiv(newLine);
                    break;
                }
                case -1: {
                    if (this.m_closeTag != null) {
                        buf.append(this.m_closeTag);
                        this.m_closeTag = null;
                    }
                    quitReading = true;
                    break;
                }
                default: {
                    buf.append((char)ch);
                    newLine = false;
                }
            }
            if (s == null) continue;
            buf.append(s);
            newLine = false;
        }
        this.m_data = new StringReader(buf.toString());
    }

    public int read() throws IOException {
        int val = this.m_data.read();
        if (val == -1) {
            this.fillBuffer();
            val = this.m_data.read();
            if (val == -1) {
                this.m_data = new StringReader(this.closeAll());
                val = this.m_data.read();
            }
        }
        return val;
    }

    public int read(char[] buf, int off, int len) throws IOException {
        return this.m_data.read(buf, off, len);
    }

    public boolean ready() throws IOException {
        log.debug((Object)("ready ? " + this.m_data.ready()));
        if (!this.m_data.ready()) {
            this.fillBuffer();
        }
        return this.m_data.ready();
    }

    public void close() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HTMLRenderer {
        private HTMLRenderer() {
        }

        public String makeLink(int type, String link, String text) {
            String result;
            String encodedlink;
            if (text == null) {
                text = link;
            }
            if ((encodedlink = TranslatorReader.this.m_engine.encodeName(link)).length() == 0) {
                type = 2;
            }
            switch (type) {
                case 0: {
                    result = "<a class=\"wikipage\" href=\"" + TranslatorReader.this.m_engine.getViewURL(link) + "\">" + text + "</a>";
                    break;
                }
                case 1: {
                    result = "<u>" + text + "</u><a href=\"" + TranslatorReader.this.m_engine.getEditURL(link) + "\">?</a>";
                    break;
                }
                case 2: {
                    result = "<u>" + text + "</u>";
                    break;
                }
                case 4: {
                    result = "<a class=\"footnoteref\" href=\"#ref-" + TranslatorReader.this.m_context.getPage().getName() + "-" + link + "\">[" + text + "]</a>";
                    break;
                }
                case 3: {
                    result = "<a class=\"footnote\" name=\"ref-" + TranslatorReader.this.m_context.getPage().getName() + "-" + link.substring(1) + "\">[" + text + "]</a>";
                    break;
                }
                case 5: {
                    result = "<img class=\"inline\" src=\"" + link + "\" alt=\"" + text + "\" />";
                    break;
                }
                case 8: {
                    result = "<a href=\"" + text + "\"><img class=\"inline\" src=\"" + link + "\" /></a>";
                    break;
                }
                case 9: {
                    String pagelink = TranslatorReader.this.m_engine.getViewURL(text);
                    result = "<a class=\"wikipage\" href=\"" + pagelink + "\"><img class=\"inline\" src=\"" + link + "\" alt=\"" + text + "\" /></a>";
                    break;
                }
                case 6: {
                    result = "<a class=\"external\" href=\"" + link + "\">" + text + "</a>";
                    break;
                }
                case 7: {
                    result = "<a class=\"interwiki\" href=\"" + link + "\">" + text + "</a>";
                    break;
                }
                case 10: {
                    String attlink = TranslatorReader.this.m_engine.getAttachmentURL(link);
                    result = "<a class=\"attachment\" href=\"" + attlink + "\">" + text + "</a>" + "<a href=\"" + TranslatorReader.this.m_engine.getBaseURL() + "PageInfo.jsp?page=" + encodedlink + "\"><img src=\"images/attachment_small.png\" border=\"0\" /></a>";
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public String makeError(String error) {
            return "<span class=\"error\">" + error + "</span>";
        }
    }
}

