/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.NoSuchVariableException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.auth.UserProfile;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Category;

public class VariableManager {
    private static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$VariableManager == null ? (class$com$ecyrd$jspwiki$VariableManager = VariableManager.class$("com.ecyrd.jspwiki.VariableManager")) : class$com$ecyrd$jspwiki$VariableManager));
    static /* synthetic */ Class class$com$ecyrd$jspwiki$VariableManager;

    public VariableManager(Properties props) {
    }

    public static boolean isVariableLink(String link) {
        return link.startsWith("{$");
    }

    public String parseAndGetValue(WikiContext context, String link) throws IllegalArgumentException, NoSuchVariableException {
        if (!link.startsWith("{$")) {
            throw new IllegalArgumentException("Link does not start with {$");
        }
        if (!link.endsWith("}")) {
            throw new IllegalArgumentException("Link does not end with }");
        }
        String varName = link.substring(2, link.length() - 1);
        return this.getValue(context, varName.trim());
    }

    public String expandVariables(WikiContext context, String source) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) == '{') {
                if (i < source.length() - 2 && source.charAt(i + 1) == '$') {
                    String value;
                    int end = source.indexOf(125, i);
                    if (end == -1) continue;
                    String varname = source.substring(i + 2, end);
                    try {
                        value = this.getValue(context, varname);
                    }
                    catch (NoSuchVariableException e) {
                        value = e.getMessage();
                    }
                    catch (IllegalArgumentException e) {
                        value = e.getMessage();
                    }
                    result.append(value);
                    i = end;
                    continue;
                }
                result.append('{');
                continue;
            }
            result.append(source.charAt(i));
        }
        return result.toString();
    }

    public String getValue(WikiContext context, String varName) throws IllegalArgumentException, NoSuchVariableException {
        if (varName == null) {
            throw new IllegalArgumentException("Null variable name.");
        }
        if (varName.length() == 0) {
            throw new IllegalArgumentException("Zero length variable name.");
        }
        String name = varName.toLowerCase();
        String res = "";
        if (name.equals("pagename")) {
            res = context.getPage().getName();
        } else if (name.equals("applicationname")) {
            res = context.getEngine().getApplicationName();
        } else if (name.equals("jspwikiversion")) {
            res = "2.1.53-cvs";
        } else if (name.equals("encoding")) {
            res = context.getEngine().getContentEncoding();
        } else if (name.equals("totalpages")) {
            res = Integer.toString(context.getEngine().getPageCount());
        } else if (name.equals("pageprovider")) {
            res = context.getEngine().getCurrentProvider();
        } else if (name.equals("pageproviderdescription")) {
            res = context.getEngine().getCurrentProviderInfo();
        } else if (name.equals("interwikilinks")) {
            Iterator i = context.getEngine().getAllInterWikiLinks().iterator();
            while (i.hasNext()) {
                String link = (String)i.next();
                res = res + link + " --&gt; " + context.getEngine().getInterWikiURL(link) + "<br />\n";
            }
        } else if (name.equals("inlinedimages")) {
            Iterator i = context.getEngine().getAllInlinedImagePatterns().iterator();
            while (i.hasNext()) {
                String ptrn = (String)i.next();
                res = res + ptrn + "<br />\n";
            }
        } else if (name.equals("pluginpath")) {
            res = context.getEngine().getPluginSearchPath();
            res = res == null ? "-" : res;
        } else if (name.equals("baseurl")) {
            res = context.getEngine().getBaseURL();
        } else {
            Properties props;
            if (name.equals("uptime")) {
                Date now = new Date();
                long secondsRunning = (now.getTime() - context.getEngine().getStartTime().getTime()) / 1000L;
                long seconds = secondsRunning % 60L;
                long minutes = (secondsRunning /= 60L) % 60L;
                long hours = (secondsRunning /= 60L) % 24L;
                long days = secondsRunning /= 24L;
                return days + "d, " + hours + "h " + minutes + "m " + seconds + "s";
            }
            if (name.equals("loginstatus")) {
                UserProfile wup = context.getCurrentUser();
                int status = wup != null ? wup.getLoginStatus() : 0;
                switch (status) {
                    case 0: {
                        return "unknown (not logged in)";
                    }
                    case 1: {
                        return "named (cookie)";
                    }
                    case 2: {
                        return "validated (container)";
                    }
                    case 3: {
                        return "validated (password)";
                    }
                }
                return "ILLEGAL STATUS!";
            }
            if (name.equals("username")) {
                UserProfile wup = context.getCurrentUser();
                return wup != null ? wup.getName() : "not logged in";
            }
            if (context.getVariable(name) != null) {
                return context.getVariable(name).toString();
            }
            if (varName.startsWith("jspwiki.") && (res = (props = context.getEngine().getWikiProperties()).getProperty(varName)) != null) {
                return res;
            }
            throw new NoSuchVariableException("No variable " + varName + " defined.");
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

