/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.auth.UserProfile;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class WikiContext
implements Cloneable {
    WikiPage m_page;
    WikiEngine m_engine;
    String m_requestContext = "view";
    String m_template = "default";
    Map m_variableMap = new HashMap();
    HttpServletRequest m_request = null;
    UserProfile m_currentUser;
    public static final String VIEW = "view";
    public static final String EDIT = "edit";
    public static final String LOGIN = "login";
    public static final String DIFF = "diff";
    public static final String INFO = "info";
    public static final String PREVIEW = "preview";
    public static final String CONFLICT = "conflict";
    public static final String ERROR = "error";
    public static final String UPLOAD = "upload";
    public static final String COMMENT = "comment";
    public static final String FIND = "find";
    public static final String PREFS = "prefs";

    private WikiContext(WikiEngine engine, String pagename) {
        this.m_page = new WikiPage(pagename);
        this.m_engine = engine;
    }

    public WikiContext(WikiEngine engine, WikiPage page) {
        this.m_page = page;
        this.m_engine = engine;
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public WikiPage getPage() {
        return this.m_page;
    }

    public void setPage(WikiPage page) {
        this.m_page = page;
    }

    public String getRequestContext() {
        return this.m_requestContext;
    }

    public void setRequestContext(String arg) {
        this.m_requestContext = arg;
    }

    public Object getVariable(String key) {
        return this.m_variableMap.get(key);
    }

    public void setVariable(String key, Object data) {
        this.m_variableMap.put(key, data);
    }

    public String getHttpParameter(String paramName) {
        String result = null;
        if (this.m_request != null) {
            result = this.m_engine.safeGetParameter((ServletRequest)this.m_request, paramName);
        }
        return result;
    }

    public void setHttpRequest(HttpServletRequest req) {
        this.m_request = req;
    }

    public HttpServletRequest getHttpRequest() {
        return this.m_request;
    }

    public void setTemplate(String dir) {
        this.m_template = dir;
    }

    public String getTemplate() {
        return this.m_template;
    }

    public void setCurrentUser(UserProfile wup) {
        this.m_currentUser = wup;
    }

    public UserProfile getCurrentUser() {
        return this.m_currentUser;
    }

    public Object clone() {
        WikiContext copy = new WikiContext(this.m_engine, this.m_page);
        copy.m_requestContext = this.m_requestContext;
        copy.m_template = this.m_template;
        copy.m_variableMap = this.m_variableMap;
        copy.m_request = this.m_request;
        copy.m_currentUser = this.m_currentUser;
        return copy;
    }
}

