/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki;

import com.ecyrd.jspwiki.DifferenceEngine;
import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.LinkCollector;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.PageTimeComparator;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.ReferenceManager;
import com.ecyrd.jspwiki.StringTransmutator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.TranslatorReader;
import com.ecyrd.jspwiki.VariableManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.auth.AuthorizationManager;
import com.ecyrd.jspwiki.auth.UserManager;
import com.ecyrd.jspwiki.auth.UserProfile;
import com.ecyrd.jspwiki.filters.PageFilter;
import com.ecyrd.jspwiki.plugin.PluginManager;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.rss.RSSGenerator;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.ecyrd.jspwiki.util.PriorityList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;

public class WikiEngine {
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$WikiEngine == null ? (class$com$ecyrd$jspwiki$WikiEngine = WikiEngine.class$("com.ecyrd.jspwiki.WikiEngine")) : class$com$ecyrd$jspwiki$WikiEngine));
    private static boolean c_configured = false;
    private Properties m_properties;
    public static final String PARAM_PROPERTYFILE = "jspwiki.propertyfile";
    public static final String PROP_INTERWIKIREF = "jspwiki.interWikiRef.";
    public static final String PROP_STOREUSERNAME = "jspwiki.storeUserName";
    public static final String PROP_ENCODING = "jspwiki.encoding";
    public static final String PROP_BASEURL = "jspwiki.baseURL";
    public static final String PROP_BEAUTIFYTITLE = "jspwiki.breakTitleWithSpaces";
    public static final String PREFS_COOKIE_NAME = "JSPWikiUserProfile";
    public static final String PROP_MATCHPLURALS = "jspwiki.translatorReader.matchEnglishPlurals";
    public static final String PROP_TEMPLATEDIR = "jspwiki.templateDir";
    public static final String PROP_FRONTPAGE = "jspwiki.frontPage";
    public static final String DEFAULT_PROPERTYFILE = "/WEB-INF/jspwiki.properties";
    private static Hashtable c_engines = new Hashtable();
    private boolean m_saveUserInfo = true;
    private boolean m_useUTF8 = true;
    private boolean m_matchEnglishPlurals = true;
    private String m_baseURL;
    private String m_rootPath = System.getProperty("user.dir");
    private ReferenceManager m_referenceManager = null;
    private PluginManager m_pluginManager;
    private VariableManager m_variableManager;
    private AttachmentManager m_attachmentManager = null;
    private PageManager m_pageManager = null;
    private AuthorizationManager m_authorizationManager = null;
    private UserManager m_userManager = null;
    private DifferenceEngine m_differenceEngine;
    private RSSGenerator m_rssGenerator;
    private String m_rssURL;
    private ServletContext m_servletContext = null;
    private boolean m_beautifyTitle = false;
    private String m_templateDir;
    private String m_frontPage;
    private Date m_startTime;
    private PriorityList m_pageFilters = new PriorityList();
    private boolean m_isConfigured = false;
    private boolean m_started = false;
    private Thread m_thread = null;
    public static final String PROP_PAGEFILTER = "jspwiki.pageFilter.";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$WikiEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ServletContext context) {
        InputStream propertyStream = null;
        String propertyFile = context.getInitParameter(PARAM_PROPERTYFILE);
        this.m_servletContext = context;
        try {
            if (propertyFile == null) {
                context.log("No jspwiki.propertyfile defined for this context, using default from /WEB-INF/jspwiki.properties");
                propertyStream = context.getResourceAsStream(DEFAULT_PROPERTYFILE);
            } else {
                context.log("Reading properties from " + propertyFile + " instead of default.");
                propertyStream = new FileInputStream(new File(propertyFile));
            }
            if (propertyStream == null) {
                throw new WikiException("Property file cannot be found!" + propertyFile);
            }
            Properties props = new Properties();
            this.m_rootPath = context.getRealPath("/");
            props.load(propertyStream);
            this.m_started = true;
            this.initialize(props);
            log.info((Object)("Root path for this Wiki is: '" + this.m_rootPath + "'"));
        }
        catch (Exception e) {
            context.log("JSPWiki: Unable to load and setup properties from jspwiki.properties. " + e.getMessage());
        }
        finally {
            try {
                propertyStream.close();
            }
            catch (IOException e) {
                context.log("Unable to close property stream - something must be seriously wrong.");
            }
        }
    }

    public void stop() {
        this.m_started = false;
        this.m_thread.interrupt();
        this.m_pageManager.stop();
    }

    public static synchronized WikiEngine getInstance(ServletConfig config) throws InternalWikiException {
        return WikiEngine.getInstance(config.getServletContext());
    }

    public static synchronized WikiEngine getInstance(ServletContext context) {
        String appid = context.getInitParameter("WIKI_ID");
        context.log("Application " + appid + " requests WikiEngine.");
        WikiEngine engine = (WikiEngine)c_engines.get(appid);
        if (engine == null) {
            context.log(" Assigning new log to " + appid);
            try {
                engine = new WikiEngine();
            }
            catch (Exception e) {
                context.log("ERROR: Failed to create a Wiki engine: " + e.getMessage());
                throw new InternalWikiException("No wiki engine, check logs.");
            }
            c_engines.put(appid, engine);
        }
        return engine;
    }

    public WikiEngine(Properties properties) throws WikiException {
        this.initialize(properties);
    }

    protected WikiEngine() throws WikiException {
    }

    private void initialize(Properties props) throws WikiException {
        this.m_startTime = new Date();
        this.m_properties = props;
        if (!c_configured) {
            if (props.getProperty("log4j.rootCategory") != null) {
                PropertyConfigurator.configure((Properties)props);
            }
            c_configured = true;
        }
        log.info((Object)"*******************************************");
        log.info((Object)"JSPWiki 2.1.53-cvs starting. Whee!");
        log.debug((Object)"Configuring WikiEngine...");
        this.m_saveUserInfo = TextUtil.getBooleanProperty(props, PROP_STOREUSERNAME, this.m_saveUserInfo);
        this.m_useUTF8 = "UTF-8".equals(props.getProperty(PROP_ENCODING, "ISO-8859-1"));
        this.m_baseURL = props.getProperty(PROP_BASEURL, "");
        this.m_beautifyTitle = TextUtil.getBooleanProperty(props, PROP_BEAUTIFYTITLE, this.m_beautifyTitle);
        this.m_matchEnglishPlurals = TextUtil.getBooleanProperty(props, PROP_MATCHPLURALS, this.m_matchEnglishPlurals);
        this.m_templateDir = props.getProperty(PROP_TEMPLATEDIR, "default");
        this.m_frontPage = props.getProperty(PROP_FRONTPAGE, "Main");
        try {
            this.m_pageManager = new PageManager(this, props);
            this.m_pluginManager = new PluginManager(props);
            this.m_differenceEngine = new DifferenceEngine(props, this.getContentEncoding());
            this.m_attachmentManager = new AttachmentManager(this, props);
            this.m_variableManager = new VariableManager(props);
            this.m_authorizationManager = new AuthorizationManager(this, props);
            this.m_userManager = new UserManager(this, props);
            this.initPageFilters(props);
            this.initReferenceManager();
        }
        catch (Exception e) {
            log.error((Object)"Failed to start managers.", (Throwable)e);
            throw new WikiException("Failed to start managers: " + e.getMessage());
        }
        try {
            if (TextUtil.getBooleanProperty(props, "jspwiki.rss.generate", false)) {
                this.m_rssGenerator = new RSSGenerator(this, props);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to start RSS generator - JSPWiki will still work, but there will be no RSS feed.", (Throwable)e);
        }
        if (this.m_rssGenerator != null) {
            this.m_thread = new RSSThread();
            this.m_thread.setPriority(1);
            this.m_thread.start();
        }
        this.m_pageManager.start();
        log.info((Object)"WikiEngine configured.");
        this.m_isConfigured = true;
    }

    private void initReferenceManager() {
        this.m_pluginManager.enablePlugins(false);
        long start = System.currentTimeMillis();
        log.info((Object)"Starting cross reference scan of WikiPages");
        try {
            Collection pages = this.m_pageManager.getAllPages();
            pages.addAll(this.m_attachmentManager.getAllAttachments());
            if (this.m_referenceManager == null) {
                this.m_referenceManager = new ReferenceManager(this, pages);
            }
            Iterator it = pages.iterator();
            while (it.hasNext()) {
                WikiPage page = (WikiPage)it.next();
                if (page instanceof Attachment) continue;
                String content = this.m_pageManager.getPageText(page.getName(), -1);
                Collection links = this.scanWikiLinks(page, content);
                Collection attachments = this.m_attachmentManager.listAttachments(page);
                Iterator atti = attachments.iterator();
                while (atti.hasNext()) {
                    links.add(((Attachment)atti.next()).getName());
                }
                this.m_referenceManager.updateReferences(page.getName(), links);
            }
        }
        catch (ProviderException e) {
            log.fatal((Object)"PageProvider is unable to list pages: ", (Throwable)e);
        }
        log.info((Object)("Cross reference scan done (" + (System.currentTimeMillis() - start) + " ms)"));
        this.m_pluginManager.enablePlugins(true);
    }

    public void addPageFilter(PageFilter f, int priority) {
        this.m_pageFilters.add(f, priority);
    }

    private void initPageFilters(Properties props) {
        Enumeration<?> enumeration = props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            if (!name.startsWith(PROP_PAGEFILTER)) continue;
            String className = props.getProperty(name);
            try {
                String pr = name.substring(PROP_PAGEFILTER.length());
                int priority = Integer.parseInt(pr);
                Class cl = ClassUtil.findClass("com.ecyrd.jspwiki.filters", className);
                PageFilter filter = (PageFilter)cl.newInstance();
                filter.initialize(props);
                this.addPageFilter(filter, priority);
                log.info((Object)("Added page filter " + cl.getName() + " with priority " + priority));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Priority must be an integer: " + name));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Unable to find the filter class: " + className));
            }
            catch (InstantiationException e) {
                log.error((Object)("Cannot create filter class: " + className));
            }
            catch (IllegalAccessException e) {
                log.error((Object)("You are not allowed to access class: " + className));
            }
            catch (ClassCastException e) {
                log.error((Object)("Suggested class is not a PageFilter: " + className));
            }
        }
    }

    public static String getRequiredProperty(Properties props, String key) throws NoRequiredPropertyException {
        String value = props.getProperty(key);
        if (value == null) {
            throw new NoRequiredPropertyException("Required property not found", key);
        }
        return value;
    }

    public Properties getWikiProperties() {
        return this.m_properties;
    }

    public String getPluginSearchPath() {
        return this.m_properties.getProperty("jspwiki.plugin.searchPath");
    }

    public String getTemplateDir() {
        return this.m_templateDir;
    }

    public String getBaseURL() {
        return this.m_baseURL;
    }

    public Date getStartTime() {
        return this.m_startTime;
    }

    public String getViewURL(String pageName) {
        if (pageName == null) {
            return this.m_baseURL + "Wiki.jsp";
        }
        return this.m_baseURL + "Wiki.jsp?page=" + this.encodeName(pageName);
    }

    public String getEditURL(String pageName) {
        return this.m_baseURL + "Edit.jsp?page=" + this.encodeName(pageName);
    }

    public String getAttachmentURL(String attName) {
        return this.m_baseURL + "attach?page=" + this.encodeName(attName);
    }

    public String getFrontPage() {
        return this.m_frontPage;
    }

    public ServletContext getServletContext() {
        return this.m_servletContext;
    }

    public String safeGetParameter(ServletRequest request, String name) {
        try {
            String res = request.getParameter(name);
            if (res != null) {
                res = new String(res.getBytes("ISO-8859-1"), this.getContentEncoding());
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"Unsupported encoding", (Throwable)e);
            return "";
        }
    }

    public String safeGetQueryString(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        try {
            int pos1;
            String res = request.getQueryString();
            if (res != null && (pos1 = (res = new String(res.getBytes("ISO-8859-1"), this.getContentEncoding())).indexOf("page=")) >= 0) {
                String tmpRes = res.substring(0, pos1);
                int pos2 = res.indexOf("&", pos1) + 1;
                if (pos2 > 0 && pos2 < res.length()) {
                    tmpRes = tmpRes + res.substring(pos2);
                }
                res = tmpRes;
            }
            return res;
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"Unsupported encoding", (Throwable)e);
            return "";
        }
    }

    public String getInterWikiURL(String wikiName) {
        return this.m_properties.getProperty(PROP_INTERWIKIREF + wikiName);
    }

    public Collection getAllInterWikiLinks() {
        Vector<String> v = new Vector<String>();
        Enumeration<?> i = this.m_properties.propertyNames();
        while (i.hasMoreElements()) {
            String prop = (String)i.nextElement();
            if (!prop.startsWith(PROP_INTERWIKIREF)) continue;
            v.add(prop.substring(prop.lastIndexOf(".") + 1));
        }
        return v;
    }

    public Collection getAllInlinedImagePatterns() {
        return TranslatorReader.getImagePatterns(this);
    }

    public String getSpecialPageReference(String original) {
        String propname = "jspwiki.specialPage." + original;
        String specialpage = this.m_properties.getProperty(propname);
        return specialpage;
    }

    public String getApplicationName() {
        String appName = this.m_properties.getProperty("jspwiki.applicationName");
        if (appName == null) {
            return "JSPWiki";
        }
        return appName;
    }

    public String beautifyTitle(String title) {
        if (this.m_beautifyTitle) {
            return TextUtil.beautifyString(title);
        }
        return title;
    }

    public boolean pageExists(String page) {
        Attachment att = null;
        try {
            if (this.getSpecialPageReference(page) != null) {
                return true;
            }
            if (this.getFinalPageName(page) != null) {
                return true;
            }
            att = this.getAttachmentManager().getAttachmentInfo((WikiContext)null, page);
        }
        catch (ProviderException e) {
            log.debug((Object)"pageExists() failed to find attachments", (Throwable)e);
        }
        return att != null;
    }

    public boolean pageExists(String page, int version) throws ProviderException {
        if (this.getSpecialPageReference(page) != null) {
            return true;
        }
        String finalName = this.getFinalPageName(page);
        WikiPage p = null;
        if (finalName != null) {
            p = this.m_pageManager.getPageInfo(finalName, version);
        }
        if (p == null) {
            try {
                p = this.getAttachmentManager().getAttachmentInfo(null, page, version);
            }
            catch (ProviderException e) {
                log.debug((Object)"pageExists() failed to find attachments", (Throwable)e);
            }
        }
        return p != null;
    }

    public boolean pageExists(WikiPage page) throws ProviderException {
        if (page != null) {
            return this.pageExists(page.getName(), page.getVersion());
        }
        return false;
    }

    public String getFinalPageName(String page) throws ProviderException {
        boolean isThere = this.simplePageExists(page);
        if (!isThere && this.m_matchEnglishPlurals) {
            page = page.endsWith("s") ? page.substring(0, page.length() - 1) : page + "s";
            isThere = this.simplePageExists(page);
        }
        return isThere ? page : null;
    }

    private boolean simplePageExists(String page) throws ProviderException {
        if (this.getSpecialPageReference(page) != null) {
            return true;
        }
        return this.m_pageManager.pageExists(page);
    }

    public String encodeName(String pagename) {
        if (this.m_useUTF8) {
            return TextUtil.urlEncodeUTF8(pagename);
        }
        return URLEncoder.encode(pagename);
    }

    public String decodeName(String pagerequest) {
        if (this.m_useUTF8) {
            return TextUtil.urlDecodeUTF8(pagerequest);
        }
        return URLDecoder.decode(pagerequest);
    }

    public String getContentEncoding() {
        if (this.m_useUTF8) {
            return "UTF-8";
        }
        return "ISO-8859-1";
    }

    public String getText(String page) {
        return this.getText(page, -1);
    }

    public String getText(String page, int version) {
        String result = this.getPureText(page, version);
        result = TextUtil.replaceString(result, "&", "&amp;");
        result = TextUtil.replaceEntities(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPureText(String page, int version) {
        String result = null;
        try {
            result = this.m_pageManager.getPageText(page, version);
        }
        catch (ProviderException e) {
        }
        finally {
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    public String getPureText(WikiPage page) {
        return this.getPureText(page.getName(), page.getVersion());
    }

    public String getText(WikiContext context, WikiPage page) {
        return this.getText(page.getName(), page.getVersion());
    }

    public String getHTML(WikiContext context, WikiPage page) {
        String pagedata = null;
        pagedata = this.getPureText(page.getName(), page.getVersion());
        String res = this.textToHTML(context, pagedata);
        return res;
    }

    public String getHTML(String page) {
        return this.getHTML(page, -1);
    }

    public String getHTML(String pagename, int version) {
        WikiPage page = new WikiPage(pagename);
        page.setVersion(version);
        WikiContext context = new WikiContext(this, page);
        String res = this.getHTML(context, page);
        return res;
    }

    public String textToHTML(WikiContext context, String pagedata) {
        return this.textToHTML(context, pagedata, null, null);
    }

    protected Collection scanWikiLinks(WikiPage page, String pagedata) {
        LinkCollector localCollector = new LinkCollector();
        this.textToHTML(new WikiContext(this, page), pagedata, localCollector, null, localCollector, false);
        return localCollector.getLinks();
    }

    public String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, null, true);
    }

    public String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook) {
        return this.textToHTML(context, pagedata, localLinkHook, extLinkHook, attLinkHook, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String textToHTML(WikiContext context, String pagedata, StringTransmutator localLinkHook, StringTransmutator extLinkHook, StringTransmutator attLinkHook, boolean parseAccessRules) {
        String result;
        block13: {
            result = "";
            if (pagedata == null) {
                log.error((Object)"NULL pagedata to textToHTML()");
                return null;
            }
            TranslatorReader in = null;
            Object links = null;
            pagedata = this.doPreTranslateFiltering(context, pagedata);
            in = new TranslatorReader(context, new StringReader(pagedata));
            in.addLocalLinkHook(localLinkHook);
            in.addExternalLinkHook(extLinkHook);
            in.addAttachmentLinkHook(attLinkHook);
            if (!parseAccessRules) {
                in.disableAccessRules();
            }
            result = FileUtil.readContents(in);
            result = this.doPostTranslateFiltering(context, result);
            Object var12_10 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block13;
            }
            catch (Exception e2) {
                log.fatal((Object)"Closing failed", (Throwable)e2);
            }
            break block13;
            {
                catch (IOException e) {
                    log.error((Object)"Failed to scan page data: ", (Throwable)e);
                    Object var12_11 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block13;
                    }
                    catch (Exception e2) {
                        log.fatal((Object)"Closing failed", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    log.fatal((Object)"Closing failed", (Throwable)e2);
                }
                throw throwable;
            }
        }
        return result;
    }

    public void updateReferences(WikiPage page) {
        String pageData = this.getPureText(page.getName(), -1);
        this.m_referenceManager.updateReferences(page.getName(), this.scanWikiLinks(page, pageData));
    }

    private String doPreTranslateFiltering(WikiContext context, String pageData) {
        Iterator i = this.m_pageFilters.iterator();
        while (i.hasNext()) {
            PageFilter f = (PageFilter)i.next();
            pageData = f.preTranslate(context, pageData);
        }
        return pageData;
    }

    private String doPostTranslateFiltering(WikiContext context, String pageData) {
        Iterator i = this.m_pageFilters.iterator();
        while (i.hasNext()) {
            PageFilter f = (PageFilter)i.next();
            pageData = f.postTranslate(context, pageData);
        }
        return pageData;
    }

    private String doPreSaveFiltering(WikiContext context, String pageData) {
        Iterator i = this.m_pageFilters.iterator();
        while (i.hasNext()) {
            PageFilter f = (PageFilter)i.next();
            pageData = f.preSave(context, pageData);
        }
        return pageData;
    }

    private void doPostSaveFiltering(WikiContext context, String pageData) {
        Iterator i = this.m_pageFilters.iterator();
        while (i.hasNext()) {
            PageFilter f = (PageFilter)i.next();
            f.postSave(context, pageData);
        }
    }

    public void saveText(WikiContext context, String text) {
        UserProfile wup;
        WikiPage page = context.getPage();
        if (page.getAuthor() == null && (wup = context.getCurrentUser()) != null) {
            page.setAuthor(wup.getName());
        }
        text = TextUtil.normalizePostData(text);
        text = this.doPreSaveFiltering(context, text);
        this.m_referenceManager.updateReferences(page.getName(), this.scanWikiLinks(page, text));
        try {
            this.m_pageManager.putPageText(page, text);
            this.doPostSaveFiltering(context, text);
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to put page", (Throwable)e);
        }
    }

    public int getPageCount() {
        return this.m_pageManager.getTotalPageCount();
    }

    public String getCurrentProvider() {
        return this.m_pageManager.getProvider().getClass().getName();
    }

    public String getCurrentProviderInfo() {
        return this.m_pageManager.getProviderDescription();
    }

    public Collection getRecentChanges() {
        try {
            Collection pages = this.m_pageManager.getAllPages();
            Collection atts = this.m_attachmentManager.getAllAttachments();
            TreeSet sortedPages = new TreeSet(new PageTimeComparator());
            sortedPages.addAll(pages);
            sortedPages.addAll(atts);
            return sortedPages;
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to fetch all pages: ", (Throwable)e);
            return null;
        }
    }

    public Collection findPages(String query) {
        StringTokenizer st = new StringTokenizer(query, " \t,");
        QueryItem[] items = new QueryItem[st.countTokens()];
        int word = 0;
        log.debug((Object)("Expecting " + items.length + " items"));
        while (st.hasMoreTokens()) {
            log.debug((Object)("Item " + word));
            String token = st.nextToken().toLowerCase();
            items[word] = new QueryItem();
            switch (token.charAt(0)) {
                case '+': {
                    items[word].type = 1;
                    token = token.substring(1);
                    log.debug((Object)("Required word: " + token));
                    break;
                }
                case '-': {
                    items[word].type = -1;
                    token = token.substring(1);
                    log.debug((Object)("Forbidden word: " + token));
                    break;
                }
                default: {
                    items[word].type = 0;
                    log.debug((Object)("Requested word: " + token));
                }
            }
            items[word++].word = token;
        }
        Collection results = this.m_pageManager.findPages(items);
        return results;
    }

    public WikiPage getPage(String pagereq) {
        return this.getPage(pagereq, -1);
    }

    public WikiPage getPage(String pagereq, int version) {
        try {
            WikiPage p = this.m_pageManager.getPageInfo(pagereq, version);
            if (p == null) {
                p = this.m_attachmentManager.getAttachmentInfo((WikiContext)null, pagereq);
            }
            return p;
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to fetch page info", (Throwable)e);
            return null;
        }
    }

    public List getVersionHistory(String page) {
        List c = null;
        try {
            c = this.m_pageManager.getVersionHistory(page);
            if (c == null) {
                c = this.m_attachmentManager.getVersionHistory(page);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"FIXME");
        }
        return c;
    }

    public String getDiff(String page, int version1, int version2) {
        String page1 = this.getPureText(page, version1);
        String page2 = this.getPureText(page, version2);
        if (version1 == -1) {
            page1 = "";
        }
        String diff = this.m_differenceEngine.makeDiff(page1, page2);
        diff = TextUtil.replaceEntities(diff);
        try {
            if (diff.length() > 0) {
                diff = this.m_differenceEngine.colorizeDiff(diff);
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to colorize diff result.", (Throwable)e);
        }
        return diff;
    }

    public ReferenceManager getReferenceManager() {
        return this.m_referenceManager;
    }

    public PluginManager getPluginManager() {
        return this.m_pluginManager;
    }

    public VariableManager getVariableManager() {
        return this.m_variableManager;
    }

    public PageManager getPageManager() {
        return this.m_pageManager;
    }

    public AttachmentManager getAttachmentManager() {
        return this.m_attachmentManager;
    }

    public AuthorizationManager getAuthorizationManager() {
        return this.m_authorizationManager;
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public WikiContext createContext(HttpServletRequest request, String requestContext) {
        WikiPage wikipage;
        if (!this.m_isConfigured) {
            throw new InternalWikiException("WikiEngine has not been properly started.  It is likely that the configuration is faulty.  Please check all logs for the possible reason.");
        }
        String pagereq = this.safeGetParameter((ServletRequest)request, "page");
        String template = this.safeGetParameter((ServletRequest)request, "skin");
        if (pagereq == null || pagereq.length() == 0) {
            pagereq = this.getFrontPage();
        }
        int version = -1;
        String rev = request.getParameter("version");
        if (rev != null) {
            version = Integer.parseInt(rev);
        }
        if ((wikipage = this.getPage(pagereq, version)) == null) {
            wikipage = new WikiPage(pagereq);
        }
        if (template == null && ((template = (String)wikipage.getAttribute(PROP_TEMPLATEDIR)) == null || template.length() == 0)) {
            template = this.getTemplateDir();
        }
        WikiContext context = new WikiContext(this, wikipage);
        context.setRequestContext(requestContext);
        context.setHttpRequest(request);
        context.setTemplate(template);
        UserProfile user = this.getUserManager().getUserProfile(request);
        context.setCurrentUser(user);
        return context;
    }

    public String getGlobalRSSURL() {
        if (this.m_rssURL != null) {
            return this.getBaseURL() + this.m_rssURL;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Category access$100() {
        return log;
    }

    static /* synthetic */ Properties access$200(WikiEngine x0) {
        return x0.m_properties;
    }

    static /* synthetic */ boolean access$300(WikiEngine x0) {
        return x0.m_started;
    }

    static /* synthetic */ RSSGenerator access$400(WikiEngine x0) {
        return x0.m_rssGenerator;
    }

    static /* synthetic */ String access$500(WikiEngine x0) {
        return x0.m_rootPath;
    }

    static /* synthetic */ String access$602(WikiEngine x0, String x1) {
        x0.m_rssURL = x1;
        return x0.m_rssURL;
    }

    private class RSSThread
    extends Thread {
        private RSSThread() {
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

