/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.acl;

import com.ecyrd.jspwiki.auth.permissions.WikiPermission;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AclEntryImpl
implements AclEntry {
    private Principal m_principal;
    private boolean m_negative = false;
    private Vector m_permissions = new Vector();

    public boolean setPrincipal(Principal user) {
        if (this.m_principal != null) {
            return false;
        }
        this.m_principal = user;
        return true;
    }

    public Principal getPrincipal() {
        return this.m_principal;
    }

    public void setNegativePermissions() {
        this.m_negative = true;
    }

    public boolean isNegative() {
        return this.m_negative;
    }

    private Permission findPermission(WikiPermission p) {
        Iterator i = this.m_permissions.iterator();
        while (i.hasNext()) {
            WikiPermission pp = (WikiPermission)i.next();
            if (!pp.implies(p)) continue;
            return pp;
        }
        return null;
    }

    public boolean addPermission(Permission permission) {
        if (this.findPermission((WikiPermission)permission) != null) {
            return true;
        }
        this.m_permissions.add(permission);
        return false;
    }

    public boolean removePermission(Permission permission) {
        Permission p = this.findPermission((WikiPermission)permission);
        if (p != null) {
            this.m_permissions.remove(p);
            return true;
        }
        return false;
    }

    public boolean checkPermission(Permission permission) {
        return this.findPermission((WikiPermission)permission) != null;
    }

    public Enumeration permissions() {
        return this.m_permissions.elements();
    }

    public Object clone() {
        AclEntryImpl aei = new AclEntryImpl();
        aei.setPrincipal(this.m_principal);
        aei.m_permissions = (Vector)this.m_permissions.clone();
        aei.m_negative = this.m_negative;
        return aei;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AclEntry: [User=" + this.getPrincipal().getName());
        sb.append(this.m_negative ? " DENY " : " ALLOW ");
        Iterator i = this.m_permissions.iterator();
        while (i.hasNext()) {
            Permission pp = (Permission)i.next();
            sb.append(pp.toString());
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

