/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.acl;

import com.ecyrd.jspwiki.acl.AccessControlList;
import java.security.Principal;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class AclImpl
implements AccessControlList {
    private Vector m_entries = new Vector();
    private String m_name = null;

    public boolean addOwner(Principal caller, Principal owner) {
        return false;
    }

    public boolean deleteOwner(Principal caller, Principal owner) {
        return false;
    }

    public boolean isOwner(Principal owner) {
        return true;
    }

    public void setName(Principal caller, String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    private boolean hasEntry(AclEntry entry) {
        Iterator i = this.m_entries.iterator();
        while (i.hasNext()) {
            AclEntry e = (AclEntry)i.next();
            if (!e.getPrincipal().getName().equals(entry.getPrincipal().getName()) || e.isNegative() != entry.isNegative()) continue;
            return true;
        }
        return false;
    }

    public boolean addEntry(Principal caller, AclEntry entry) {
        if (this.hasEntry(entry)) {
            return false;
        }
        this.m_entries.add(entry);
        return true;
    }

    public boolean removeEntry(Principal caller, AclEntry entry) {
        return this.m_entries.remove(entry);
    }

    public Enumeration getPermissions(Principal user) {
        Vector perms = new Vector();
        Iterator i = this.m_entries.iterator();
        while (i.hasNext()) {
            AclEntry ae = (AclEntry)i.next();
            if (!ae.getPrincipal().getName().equals(user.getName())) continue;
            Enumeration enumeration = ae.permissions();
            while (enumeration.hasMoreElements()) {
                perms.add(enumeration.nextElement());
            }
        }
        return perms.elements();
    }

    public Enumeration entries() {
        return this.m_entries.elements();
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        int res = this.findPermission(principal, permission);
        return res == 1;
    }

    public AclEntry getEntry(Principal principal, boolean isNegative) {
        Enumeration e = this.m_entries.elements();
        while (e.hasMoreElements()) {
            AclEntry entry = (AclEntry)e.nextElement();
            if (!entry.getPrincipal().getName().equals(principal.getName()) || entry.isNegative() != isNegative) continue;
            return entry;
        }
        return null;
    }

    public int findPermission(Principal principal, Permission permission) {
        AclEntry entry;
        boolean posEntry = false;
        Enumeration e = this.m_entries.elements();
        while (e.hasMoreElements()) {
            entry = (AclEntry)e.nextElement();
            if (!entry.getPrincipal().getName().equals(principal.getName()) || !entry.checkPermission(permission)) continue;
            if (entry.isNegative()) {
                return -1;
            }
            posEntry = true;
        }
        if (posEntry) {
            return 1;
        }
        e = this.m_entries.elements();
        while (e.hasMoreElements()) {
            Group entryGroup;
            entry = (AclEntry)e.nextElement();
            if (!(entry.getPrincipal() instanceof Group) || !(entryGroup = (Group)entry.getPrincipal()).isMember(principal) || !entry.checkPermission(permission)) continue;
            if (entry.isNegative()) {
                return -1;
            }
            posEntry = true;
        }
        if (posEntry) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            AclEntry entry = (AclEntry)enumeration.nextElement();
            Principal pal = entry.getPrincipal();
            if (pal != null) {
                sb.append("  user = " + pal.getName() + ": ");
            } else {
                sb.append("  user = null: ");
            }
            if (entry.isNegative()) {
                sb.append("NEG");
            }
            sb.append("(");
            Enumeration perms = entry.permissions();
            while (perms.hasMoreElements()) {
                Permission perm = (Permission)perms.nextElement();
                sb.append(perm.toString());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }
}

