/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.attachment;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Category;

public class AttachmentManager {
    public static final String PROP_PROVIDER = "jspwiki.attachmentProvider";
    static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$attachment$AttachmentManager == null ? (class$com$ecyrd$jspwiki$attachment$AttachmentManager = AttachmentManager.class$("com.ecyrd.jspwiki.attachment.AttachmentManager")) : class$com$ecyrd$jspwiki$attachment$AttachmentManager));
    private WikiAttachmentProvider m_provider;
    private WikiEngine m_engine;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$attachment$AttachmentManager;

    public AttachmentManager(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        String classname = props.getProperty(PROP_PROVIDER);
        if (classname == null) {
            log.info((Object)"No attachment provider defined - disabling attachment support.");
            return;
        }
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiAttachmentProvider)providerclass.newInstance();
            this.m_provider.initialize(props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"Attachment provider class not found", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Attachment provider could not be created", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"You may not access the attachment provider class", (Throwable)e);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Attachment provider did not find a property that it needed: " + e.getMessage()), (Throwable)e);
            this.m_provider = null;
        }
        catch (IOException e) {
            log.error((Object)"Attachment provider reports IO error", (Throwable)e);
            this.m_provider = null;
        }
    }

    public boolean attachmentsEnabled() {
        return this.m_provider != null;
    }

    public Attachment getAttachmentInfo(String name) throws ProviderException {
        return this.getAttachmentInfo(name, -1);
    }

    public Attachment getAttachmentInfo(String name, int version) throws ProviderException {
        if (name == null) {
            return null;
        }
        return this.getAttachmentInfo(null, name, version);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname) throws ProviderException {
        return this.getAttachmentInfo(context, attachmentname, -1);
    }

    public Attachment getAttachmentInfo(WikiContext context, String attachmentname, int version) throws ProviderException {
        int cutpt;
        if (this.m_provider == null) {
            return null;
        }
        WikiPage currentPage = null;
        if (context != null) {
            currentPage = context.getPage();
        }
        if ((cutpt = attachmentname.lastIndexOf(47)) != -1) {
            currentPage = new WikiPage(attachmentname.substring(0, cutpt));
            attachmentname = attachmentname.substring(cutpt + 1);
        }
        if (currentPage == null) {
            return null;
        }
        return this.m_provider.getAttachmentInfo(currentPage, attachmentname, version);
    }

    public Collection listAttachments(WikiPage wikipage) throws ProviderException {
        if (this.m_provider == null) {
            return new ArrayList();
        }
        return this.m_provider.listAttachments(wikipage);
    }

    public boolean hasAttachments(WikiPage wikipage) {
        try {
            return this.listAttachments(wikipage).size() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public InputStream getAttachmentStream(Attachment att) throws IOException, ProviderException {
        if (this.m_provider == null) {
            return null;
        }
        return this.m_provider.getAttachmentData(att);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAttachment(Attachment att, File source) throws IOException, ProviderException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(source);
            this.storeAttachment(att, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void storeAttachment(Attachment att, InputStream in) throws IOException, ProviderException {
        if (this.m_provider == null) {
            return;
        }
        this.m_provider.putAttachmentData(att, in);
        this.m_engine.getReferenceManager().updateReferences(att.getName(), new Vector());
        this.m_engine.updateReferences(new WikiPage(att.getParentName()));
    }

    public List getVersionHistory(String attachmentName) throws ProviderException {
        if (this.m_provider == null) {
            return null;
        }
        Attachment att = this.getAttachmentInfo((WikiContext)null, attachmentName);
        if (att != null) {
            return this.m_provider.getVersionHistory(att);
        }
        return null;
    }

    public Collection getAllAttachments() throws ProviderException {
        if (this.attachmentsEnabled()) {
            return this.m_provider.listAllChanged(new Date(0L));
        }
        return new ArrayList();
    }

    public WikiAttachmentProvider getCurrentProvider() {
        return this.m_provider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

