/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.attachment;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.auth.UserProfile;
import com.ecyrd.jspwiki.providers.ProviderException;
import http.utils.multipartrequest.MultipartRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class AttachmentServlet
extends HttpServlet {
    private WikiEngine m_engine;
    private Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$attachment$AttachmentServlet == null ? (class$com$ecyrd$jspwiki$attachment$AttachmentServlet = AttachmentServlet.class$("com.ecyrd.jspwiki.attachment.AttachmentServlet")) : class$com$ecyrd$jspwiki$attachment$AttachmentServlet));
    public static final String HDR_VERSION = "version";
    public static final String HDR_NAME = "page";
    private String m_tmpDir;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$attachment$AttachmentServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = WikiEngine.getInstance(config);
        Properties props = this.m_engine.getWikiProperties();
        this.m_tmpDir = System.getProperty("java.io.tmpdir");
        this.log.debug((Object)("UploadServlet initialized. Using " + this.m_tmpDir + " for temporary storage."));
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String page = this.m_engine.safeGetParameter((ServletRequest)req, HDR_NAME);
        String version = this.m_engine.safeGetParameter((ServletRequest)req, HDR_VERSION);
        String nextPage = this.m_engine.safeGetParameter((ServletRequest)req, "nextpage");
        String msg = "An error occurred. Ouch.";
        int ver = -1;
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        if (page == null) {
            msg = "Invalid attachment name.";
        } else {
            try {
                Attachment att;
                if (version != null) {
                    ver = Integer.parseInt(version);
                }
                if ((att = mgr.getAttachmentInfo(page, ver)) != null) {
                    String mimetype = this.getServletConfig().getServletContext().getMimeType(att.getFileName().toLowerCase());
                    if (mimetype == null) {
                        mimetype = "application/binary";
                    }
                    res.setContentType(mimetype);
                    res.setHeader("Content-Disposition", "inline; filename=" + att.getFileName() + ";");
                    if (att.getSize() >= 0L) {
                        res.setContentLength((int)att.getSize());
                    }
                    ServletOutputStream out = res.getOutputStream();
                    InputStream in = mgr.getAttachmentStream(att);
                    int read = 0;
                    byte[] buffer = new byte[8192];
                    while ((read = in.read(buffer)) > -1) {
                        out.write(buffer, 0, read);
                    }
                    in.close();
                    out.close();
                    msg = "Attachment " + att.getFileName() + " sent to " + req.getRemoteUser() + " on " + req.getRemoteHost();
                    this.log.debug((Object)msg);
                    if (nextPage != null) {
                        res.sendRedirect(nextPage);
                    }
                    return;
                }
                msg = "Attachment '" + page + "', version " + ver + " does not exist.";
            }
            catch (ProviderException pe) {
                msg = "Provider error: " + pe.getMessage();
            }
            catch (NumberFormatException nfe) {
                msg = "Invalid version number (" + version + ")";
            }
            catch (IOException ioe) {
                msg = "Error: " + ioe.getMessage();
            }
        }
        this.log.info((Object)msg);
        if (nextPage != null) {
            res.sendRedirect(nextPage);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nextPage = this.upload(req);
        this.log.debug((Object)("Forwarding to " + nextPage));
        res.sendRedirect(nextPage);
    }

    protected String upload(HttpServletRequest req) {
        String msg = "";
        String attName = "(unknown)";
        String nextPage = "Error.jsp";
        try {
            MultipartRequest multi = new MultipartRequest(null, req.getContentType(), req.getContentLength(), (InputStream)req.getInputStream(), this.m_tmpDir, Integer.MAX_VALUE, this.m_engine.getContentEncoding());
            nextPage = multi.getURLParameter("nextpage");
            String wikipage = multi.getURLParameter(HDR_NAME);
            WikiContext context = this.m_engine.createContext(req, "upload");
            UserProfile user = context.getCurrentUser();
            Enumeration files = multi.getFileParameterNames();
            while (files.hasMoreElements()) {
                String part = (String)files.nextElement();
                File f = multi.getFile(part);
                AttachmentManager mgr = this.m_engine.getAttachmentManager();
                String filename = multi.getFileSystemName(part);
                if (filename == null || filename.trim().length() == 0) {
                    this.log.error((Object)"Empty file name given.");
                    return nextPage;
                }
                InputStream in = f != null ? new FileInputStream(f) : multi.getFileContents(part);
                if (in == null) {
                    this.log.error((Object)"File could not be opened.");
                    return nextPage;
                }
                Attachment att = mgr.getAttachmentInfo(wikipage);
                if (att == null) {
                    att = new Attachment(wikipage, filename);
                }
                if (user != null) {
                    att.setAuthor(user.getName());
                }
                this.m_engine.getAttachmentManager().storeAttachment(att, in);
                this.log.info((Object)("User " + user + " uploaded attachment to " + wikipage + " called " + filename + ", size " + multi.getFileSize(part)));
                f.delete();
            }
        }
        catch (ProviderException e) {
            msg = "Upload failed because the provider failed: " + e.getMessage();
            this.log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
        }
        catch (IOException e) {
            msg = "Upload failure: " + e.getMessage();
            this.log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
        }
        return nextPage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

