/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.acl.AccessControlList;
import com.ecyrd.jspwiki.acl.AclEntryImpl;
import com.ecyrd.jspwiki.acl.AclImpl;
import com.ecyrd.jspwiki.auth.AllGroup;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.PageAuthorizer;
import com.ecyrd.jspwiki.auth.UserProfile;
import com.ecyrd.jspwiki.auth.WikiAuthorizer;
import com.ecyrd.jspwiki.auth.permissions.EditPermission;
import com.ecyrd.jspwiki.auth.permissions.ViewPermission;
import com.ecyrd.jspwiki.auth.permissions.WikiPermission;
import java.security.Principal;
import java.security.acl.NotOwnerException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;

public class AuthorizationManager {
    public static final String PROP_STRICTLOGINS = "jspwiki.policy.strictLogins";
    static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$auth$AuthorizationManager == null ? (class$com$ecyrd$jspwiki$auth$AuthorizationManager = AuthorizationManager.class$("com.ecyrd.jspwiki.auth.AuthorizationManager")) : class$com$ecyrd$jspwiki$auth$AuthorizationManager));
    private WikiAuthorizer m_authorizer;
    private AccessControlList m_defaultPermissions;
    private boolean m_strictLogins = false;
    private WikiEngine m_engine;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$auth$AuthorizationManager;

    public AuthorizationManager(WikiEngine engine, Properties properties) {
        this.m_engine = engine;
        this.m_authorizer = new PageAuthorizer();
        this.m_authorizer.initialize(engine, properties);
        this.m_strictLogins = TextUtil.getBooleanProperty(properties, PROP_STRICTLOGINS, false);
        AclEntryImpl ae = new AclEntryImpl();
        AllGroup allGroup = new AllGroup();
        allGroup.setName("All");
        ae.setPrincipal(allGroup);
        ae.addPermission(new ViewPermission());
        ae.addPermission(new EditPermission());
        try {
            this.m_defaultPermissions = new AclImpl();
            this.m_defaultPermissions.addEntry(null, ae);
        }
        catch (NotOwnerException e) {
            throw new InternalWikiException("Nobody told me that owners were in use");
        }
    }

    public boolean strictLogins() {
        return this.m_strictLogins;
    }

    public boolean checkPermission(WikiPage page, UserProfile wup, String permission) {
        return this.checkPermission(page, wup, WikiPermission.newInstance(permission));
    }

    public boolean checkPermission(WikiPage page, UserProfile wup, WikiPermission permission) {
        int res = 0;
        AccessControlList acl = page.getAcl();
        if (acl == null) {
            log.debug((Object)"No ACL, querying from authorizer");
            acl = this.m_authorizer.getPermissions(page);
        }
        if (acl != null) {
            log.debug((Object)("ACL for this page is: " + acl));
            log.debug((Object)("Checking for wup: " + wup));
            log.debug((Object)("Permission: " + permission));
            res = acl.findPermission(wup, permission);
            if (res == 0) {
                log.debug((Object)"Checking groups...");
                try {
                    List list = this.m_engine.getUserManager().getGroupsForPrincipal(wup);
                    Iterator i = list.iterator();
                    while (i.hasNext() && (res = acl.findPermission((Principal)i.next(), permission)) == 0) {
                    }
                }
                catch (NoSuchPrincipalException e) {
                    log.warn((Object)"Internal trouble: No principal defined for requested user.", (Throwable)e);
                }
            }
        }
        if (res == 0) {
            log.debug((Object)("Page defines no permissions for " + wup.getName() + ", checking defaults."));
            acl = this.m_authorizer.getDefaultPermissions();
            if (acl != null) {
                res = acl.findPermission(wup, permission);
            }
        }
        if (res == 0) {
            log.debug((Object)"No defaults exist, falling back to hardcoded permissions.");
            res = this.m_defaultPermissions.findPermission(wup, permission);
        }
        log.debug((Object)("Permission " + permission + " for user " + wup + " is " + res));
        if (res == 0) {
            throw new InternalWikiException("No default policy has been defined!");
        }
        return res == 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

