/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.TranslatorReader;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.auth.AllGroup;
import com.ecyrd.jspwiki.auth.KnownGroup;
import com.ecyrd.jspwiki.auth.NamedGroup;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.UndefinedPrincipal;
import com.ecyrd.jspwiki.auth.UserDatabase;
import com.ecyrd.jspwiki.auth.UserProfile;
import com.ecyrd.jspwiki.auth.WikiAuthenticator;
import com.ecyrd.jspwiki.auth.WikiGroup;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Category;

public class UserManager {
    static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$auth$UserManager == null ? (class$com$ecyrd$jspwiki$auth$UserManager = UserManager.class$("com.ecyrd.jspwiki.auth.UserManager")) : class$com$ecyrd$jspwiki$auth$UserManager));
    public static final String WIKIUSER = "currentUser";
    public static final String PROP_STOREIPADDRESS = "jspwiki.storeIPAddress";
    public static final String PROP_AUTHENTICATOR = "jspwiki.authenticator";
    public static final String PROP_USERDATABASE = "jspwiki.userdatabase";
    private boolean m_storeIPAddress = true;
    private HashMap m_groups = new HashMap();
    public static final String GROUP_GUEST = "Guest";
    public static final String GROUP_NAMEDGUEST = "NamedGuest";
    public static final String GROUP_KNOWNPERSON = "KnownPerson";
    private WikiAuthenticator m_authenticator;
    private UserDatabase m_database;
    private WikiEngine m_engine;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$auth$UserManager;

    public UserManager(WikiEngine engine, Properties props) throws WikiException {
        String dbClassName;
        this.m_engine = engine;
        this.m_storeIPAddress = TextUtil.getBooleanProperty(props, PROP_STOREIPADDRESS, this.m_storeIPAddress);
        AllGroup all = new AllGroup();
        all.setName("All");
        this.m_groups.put(GROUP_GUEST, new AllGroup());
        this.m_groups.put(GROUP_NAMEDGUEST, new NamedGroup());
        this.m_groups.put(GROUP_KNOWNPERSON, new KnownGroup());
        String authClassName = props.getProperty(PROP_AUTHENTICATOR);
        if (authClassName != null) {
            try {
                Class authenticatorClass = ClassUtil.findClass("com.ecyrd.jspwiki.auth.modules", authClassName);
                this.m_authenticator = (WikiAuthenticator)authenticatorClass.newInstance();
                this.m_authenticator.initialize(props);
                log.info((Object)("Initialized " + authClassName + " for authentication."));
            }
            catch (ClassNotFoundException e) {
                log.fatal((Object)("Authenticator " + authClassName + " cannot be found"), (Throwable)e);
                throw new WikiException("Authenticator cannot be found");
            }
            catch (InstantiationException e) {
                log.fatal((Object)("Authenticator " + authClassName + " cannot be created"), (Throwable)e);
                throw new WikiException("Authenticator cannot be created");
            }
            catch (IllegalAccessException e) {
                log.fatal((Object)"You are not allowed to access this authenticator class", (Throwable)e);
                throw new WikiException("You are not allowed to access this authenticator class");
            }
        }
        if ((dbClassName = props.getProperty(PROP_USERDATABASE)) == null) {
            dbClassName = "com.ecyrd.jspwiki.auth.modules.WikiDatabase";
        }
        try {
            Class dbClass = ClassUtil.findClass("com.ecyrd.jspwiki.auth.modules", dbClassName);
            this.m_database = (UserDatabase)dbClass.newInstance();
            this.m_database.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)("UserDatabase " + dbClassName + " cannot be found"), (Throwable)e);
            throw new WikiException("UserDatabase cannot be found");
        }
        catch (InstantiationException e) {
            log.fatal((Object)("UserDatabase " + dbClassName + " cannot be created"), (Throwable)e);
            throw new WikiException("UserDatabase cannot be created");
        }
        catch (IllegalAccessException e) {
            log.fatal((Object)"You are not allowed to access this user database class", (Throwable)e);
            throw new WikiException("You are not allowed to access this user database class");
        }
    }

    public UserProfile getUserProfile(String name) {
        UserProfile wup = new UserProfile();
        wup.setName(name);
        return wup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikiGroup getWikiGroup(String name) {
        WikiGroup group;
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            group = (WikiGroup)this.m_groups.get(name);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGroupsForPrincipal(Principal user) throws NoSuchPrincipalException {
        ArrayList<WikiGroup> list = this.m_database.getGroupsForPrincipal(user);
        if (list == null) {
            list = new ArrayList<WikiGroup>();
        }
        HashMap hashMap = this.m_groups;
        synchronized (hashMap) {
            Iterator i = this.m_groups.values().iterator();
            while (i.hasNext()) {
                WikiGroup g = (WikiGroup)i.next();
                if (!g.isMember(user)) continue;
                log.debug((Object)("User " + user.getName() + " is a member of " + g.getName()));
                list.add(g);
            }
        }
        return list;
    }

    public Principal getPrincipal(String name) {
        UndefinedPrincipal p = null;
        if (p == null) {
            p = new UndefinedPrincipal(name);
        }
        return p;
    }

    public boolean login(String username, String password, HttpSession session) {
        if (this.m_authenticator == null) {
            return false;
        }
        if (session == null) {
            log.error((Object)"No session provided, cannot log in.");
            return false;
        }
        UserProfile wup = this.getUserProfile(username);
        wup.setPassword(password);
        boolean isValid = this.m_authenticator.authenticate(wup);
        if (isValid) {
            wup.setLoginStatus(3);
            session.setAttribute(WIKIUSER, (Object)wup);
            log.info((Object)("Logged in user " + username));
        } else {
            log.info((Object)("Username " + username + " attempted to log in with the wrong password."));
        }
        return isValid;
    }

    public void logout(HttpSession session) {
        if (session != null) {
            UserProfile wup = (UserProfile)session.getAttribute(WIKIUSER);
            if (wup != null) {
                log.info((Object)("logged out user " + wup.getName()));
                wup.setLoginStatus(0);
            }
            session.invalidate();
        }
    }

    public UserProfile getUserProfile(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        UserProfile wup = (UserProfile)session.getAttribute(WIKIUSER);
        if (wup != null) {
            return wup;
        }
        wup = this.limitedLogin(request);
        if (wup != null) {
            return wup;
        }
        log.error((Object)"Unable to get a default UserProfile!");
        return null;
    }

    protected UserProfile limitedLogin(HttpServletRequest request) {
        UserProfile wup = null;
        Object role = null;
        String uid = request.getRemoteUser();
        if (uid != null) {
            wup = this.getUserProfile(uid);
            wup.setLoginStatus(2);
            HttpSession session = request.getSession(true);
            session.setAttribute(WIKIUSER, (Object)wup);
        } else {
            uid = this.retrieveCookieValue(request, "JSPWikiUserProfile");
            log.debug((Object)("Stored username=" + uid));
            if (uid != null) {
                wup = UserProfile.parseStringRepresentation(uid);
                log.debug((Object)("wup=" + wup));
                wup.setLoginStatus(1);
            } else {
                if (this.m_storeIPAddress) {
                    uid = request.getRemoteAddr();
                }
                if (uid == null) {
                    uid = "unknown";
                }
                wup = this.getUserProfile(uid);
                wup.setLoginStatus(0);
            }
        }
        return wup;
    }

    private String retrieveCookieValue(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(cookieName)) continue;
                return cookies[i].getValue();
            }
        }
        return null;
    }

    public void setUserCookie(HttpServletResponse response, String name) {
        UserProfile profile = this.getUserProfile(TranslatorReader.cleanLink(name));
        Cookie prefs = new Cookie("JSPWikiUserProfile", profile.getStringRepresentation());
        prefs.setMaxAge(86486400);
        response.addCookie(prefs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

