/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth;

import com.ecyrd.jspwiki.auth.WikiPrincipal;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class WikiGroup
extends WikiPrincipal
implements Group {
    private Vector m_members = new Vector();

    public WikiGroup() {
    }

    public WikiGroup(String name) {
        this.setName(name);
    }

    public boolean addMember(Principal user) {
        if (this.isMember(user)) {
            return false;
        }
        this.m_members.add(user);
        return true;
    }

    public boolean removeMember(Principal user) {
        if ((user = this.findMember(user.getName())) == null) {
            return false;
        }
        this.m_members.remove(user);
        return true;
    }

    private Principal findMember(String name) {
        Iterator i = this.m_members.iterator();
        while (i.hasNext()) {
            Principal member = (Principal)i.next();
            if (!member.getName().equals(name)) continue;
            return member;
        }
        return null;
    }

    public boolean isMember(Principal principal) {
        return this.findMember(principal.getName()) != null;
    }

    public Enumeration members() {
        return this.m_members.elements();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WikiGroup)) {
            return false;
        }
        WikiGroup g = (WikiGroup)o;
        if (g.m_members.size() != this.m_members.size()) {
            return false;
        }
        if (this.getName() != null && !this.getName().equals(g.getName())) {
            return false;
        }
        if (this.getName() == null && g.getName() != null) {
            return false;
        }
        Iterator i = this.m_members.iterator();
        while (i.hasNext()) {
            if (g.isMember((Principal)i.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[Group: " + this.getName() + ", members=");
        Iterator i = this.m_members.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

