/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.auth.modules;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.auth.NoSuchPrincipalException;
import com.ecyrd.jspwiki.auth.UndefinedPrincipal;
import com.ecyrd.jspwiki.auth.UserDatabase;
import com.ecyrd.jspwiki.auth.WikiGroup;
import com.ecyrd.jspwiki.filters.BasicPageFilter;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;

public class WikiDatabase
implements UserDatabase {
    private WikiEngine m_engine;
    static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$auth$modules$WikiDatabase == null ? (class$com$ecyrd$jspwiki$auth$modules$WikiDatabase = WikiDatabase.class$("com.ecyrd.jspwiki.auth.modules.WikiDatabase")) : class$com$ecyrd$jspwiki$auth$modules$WikiDatabase));
    private HashMap m_principals = new HashMap();
    static /* synthetic */ Class class$com$ecyrd$jspwiki$auth$modules$WikiDatabase;

    public void initialize(WikiEngine engine, Properties props) {
        this.m_engine = engine;
        this.m_engine.addPageFilter(new SaveFilter(), 1000000);
        this.initUserDatabase();
    }

    public List getGroupsForPrincipal(Principal p) throws NoSuchPrincipalException {
        ArrayList memberList = new ArrayList();
        log.debug((Object)("Finding groups for " + p.getName()));
        Iterator i = this.m_principals.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof WikiGroup) {
                log.debug((Object)("  Checking group: " + o));
                if (!((WikiGroup)o).isMember(p)) continue;
                log.debug((Object)"     Is member");
                memberList.add(o);
                continue;
            }
            log.debug((Object)("  Found strange object: " + o.getClass()));
        }
        return memberList;
    }

    private void updateGroup(String groupName, List memberList) {
        WikiGroup group = (WikiGroup)this.m_principals.get(groupName);
        if (group == null && memberList == null) {
            log.debug((Object)"No previous group, and no memberList.  Doing nothing.");
            return;
        }
        if (group == null && memberList != null) {
            log.debug((Object)("Adding new group: " + groupName));
            group = new WikiGroup();
            group.setName(groupName);
        }
        if (group != null && memberList == null) {
            log.debug((Object)("Detected removed group: " + groupName));
            this.m_principals.remove(groupName);
            return;
        }
        Iterator j = memberList.iterator();
        while (j.hasNext()) {
            UndefinedPrincipal udp = new UndefinedPrincipal((String)j.next());
            group.addMember(udp);
            log.debug((Object)("** Added member: " + udp.getName()));
        }
        this.m_principals.put(groupName, group);
    }

    private void initUserDatabase() {
        log.info((Object)"Initializing user database from wiki pages...");
        try {
            Collection allPages = this.m_engine.getPageManager().getAllPages();
            this.m_principals.clear();
            Iterator i = allPages.iterator();
            while (i.hasNext()) {
                WikiPage p = (WikiPage)i.next();
                List memberList = (List)p.getAttribute("_members");
                if (memberList == null) continue;
                this.updateGroup(p.getName(), memberList);
            }
        }
        catch (ProviderException e) {
            log.fatal((Object)"Cannot start database", (Throwable)e);
        }
    }

    public Principal getPrincipal(String name) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SaveFilter
    extends BasicPageFilter {
        public void postSave(WikiContext context, String content) {
            WikiPage p = context.getPage();
            log.debug((Object)("Skimming through page " + p.getName() + " to see if there are new users..."));
            WikiDatabase.this.m_engine.textToHTML(context, content);
            List members = (List)p.getAttribute("_members");
            WikiDatabase.this.updateGroup(p.getName(), members);
        }
    }
}

