/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.util.Map;

public class Image
implements WikiPlugin {
    public static final String PARAM_SRC = "src";
    public static final String PARAM_ALIGN = "align";
    public static final String PARAM_HEIGHT = "height";
    public static final String PARAM_WIDTH = "width";
    public static final String PARAM_ALT = "alt";
    public static final String PARAM_CAPTION = "caption";
    public static final String PARAM_LINK = "link";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_CLASS = "class";
    public static final String PARAM_BORDER = "border";

    private static final String getCleanParameter(Map params, String paramId) {
        return TextUtil.replaceEntities((String)params.get(paramId));
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String src = Image.getCleanParameter(params, PARAM_SRC);
        String align = Image.getCleanParameter(params, PARAM_ALIGN);
        String ht = Image.getCleanParameter(params, PARAM_HEIGHT);
        String wt = Image.getCleanParameter(params, PARAM_WIDTH);
        String alt = Image.getCleanParameter(params, PARAM_ALT);
        String caption = Image.getCleanParameter(params, PARAM_CAPTION);
        String link = Image.getCleanParameter(params, PARAM_LINK);
        String style = Image.getCleanParameter(params, PARAM_STYLE);
        String cssclass = Image.getCleanParameter(params, PARAM_CLASS);
        String border = Image.getCleanParameter(params, PARAM_BORDER);
        if (src == null) {
            throw new PluginException("Parameter 'src' is required for Image plugin");
        }
        if (cssclass == null) {
            cssclass = "imageplugin";
        }
        try {
            AttachmentManager mgr = engine.getAttachmentManager();
            Attachment att = mgr.getAttachmentInfo(context, src);
            if (att != null) {
                src = engine.getAttachmentURL(att.getName());
            }
        }
        catch (ProviderException e) {
            throw new PluginException("Attachment info failed: " + e.getMessage());
        }
        StringBuffer result = new StringBuffer();
        result.append("<table border=\"0\" class=\"" + cssclass + "\"");
        if (align != null) {
            result.append(" align=\"" + align + "\"");
        }
        if (style != null) {
            result.append(" style=\"" + style + "\"");
        }
        result.append(">\n");
        if (caption != null) {
            result.append("<caption align=bottom>" + TextUtil.replaceEntities(caption) + "</caption>\n");
        }
        result.append("<tr><td>");
        if (link != null) {
            result.append("<a href=\"" + link + "\">");
        }
        result.append("<img src=\"" + src + "\"");
        if (ht != null) {
            result.append(" height=\"" + ht + "\"");
        }
        if (wt != null) {
            result.append(" width=\"" + wt + "\"");
        }
        if (alt != null) {
            result.append(" alt=\"" + alt + "\"");
        }
        if (border != null) {
            result.append(" border=\"" + border + "\"");
        }
        result.append(" />");
        if (link != null) {
            result.append("</a>");
        }
        result.append("</td></tr>\n");
        result.append("</table>\n");
        return result.toString();
    }
}

