/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.util.ClassUtil;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Category;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class PluginManager {
    private static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$plugin$PluginManager == null ? (class$com$ecyrd$jspwiki$plugin$PluginManager = PluginManager.class$("com.ecyrd.jspwiki.plugin.PluginManager")) : class$com$ecyrd$jspwiki$plugin$PluginManager));
    public static final String DEFAULT_PACKAGE = "com.ecyrd.jspwiki.plugin";
    public static final String PROP_SEARCHPATH = "jspwiki.plugin.searchPath";
    public static final String PARAM_BODY = "_body";
    Vector m_searchPath = new Vector();
    Pattern m_pluginPattern;
    private boolean m_pluginsEnabled = true;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$plugin$PluginManager;

    public PluginManager(Properties props) {
        String packageNames = props.getProperty(PROP_SEARCHPATH);
        if (packageNames != null) {
            StringTokenizer tok = new StringTokenizer(packageNames, ",");
            while (tok.hasMoreTokens()) {
                this.m_searchPath.add(tok.nextToken());
            }
        }
        this.m_searchPath.add(DEFAULT_PACKAGE);
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_pluginPattern = compiler.compile("\\{?(INSERT)?\\s*([\\w\\._]+)[ \\t]*(WHERE)?[ \\t]*");
        }
        catch (MalformedPatternException e) {
            log.fatal((Object)"Internal error: someone messed with pluginmanager patterns.", (Throwable)e);
            throw new InternalWikiException("PluginManager patterns are broken");
        }
    }

    public void enablePlugins(boolean enabled) {
        this.m_pluginsEnabled = enabled;
    }

    public boolean pluginsEnabled() {
        return this.m_pluginsEnabled;
    }

    public static boolean isPluginLink(String link) {
        return link.startsWith("{INSERT") || link.startsWith("{") && !link.startsWith("{$");
    }

    private Class findPluginClass(String classname) throws ClassNotFoundException {
        return ClassUtil.findClass(this.m_searchPath, classname);
    }

    public String execute(WikiContext context, String classname, Map params) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        try {
            WikiPlugin plugin;
            Class pluginClass = this.findPluginClass(classname);
            try {
                plugin = (WikiPlugin)pluginClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new PluginException("Cannot instantiate plugin " + classname, e);
            }
            catch (IllegalAccessException e) {
                throw new PluginException("Not allowed to access plugin " + classname, e);
            }
            catch (Exception e) {
                throw new PluginException("Instantiation of plugin " + classname + " failed.", e);
            }
            try {
                return plugin.execute(context, params);
            }
            catch (PluginException e) {
                throw (PluginException)e.fillInStackTrace();
            }
            catch (Exception e) {
                log.warn((Object)"Plugin failed while executing:", (Throwable)e);
                throw new PluginException("Plugin failed", e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new PluginException("Could not find plugin " + classname, e);
        }
        catch (ClassCastException e) {
            throw new PluginException("Class " + classname + " is not a Wiki plugin.", e);
        }
    }

    public Map parseArgs(String argstring) throws IOException {
        HashMap<String, String> arglist = new HashMap<String, String>();
        StringReader in = new StringReader(argstring);
        StreamTokenizer tok = new StreamTokenizer(in);
        String param = null;
        String value = null;
        tok.eolIsSignificant(true);
        boolean potentialEmptyLine = false;
        boolean quit = false;
        while (!quit) {
            String s;
            int type = tok.nextToken();
            switch (type) {
                case -1: {
                    quit = true;
                    s = null;
                    break;
                }
                case -3: {
                    s = tok.sval;
                    potentialEmptyLine = false;
                    break;
                }
                case 10: {
                    quit = potentialEmptyLine;
                    potentialEmptyLine = true;
                    s = null;
                    break;
                }
                case -2: {
                    s = Integer.toString(new Double(tok.nval).intValue());
                    potentialEmptyLine = false;
                    break;
                }
                case 39: {
                    s = tok.sval;
                    break;
                }
                default: {
                    s = null;
                }
            }
            if (s == null) continue;
            if (param == null) {
                param = s;
                continue;
            }
            value = s;
            arglist.put(param, value);
            param = null;
        }
        if (potentialEmptyLine) {
            StringWriter out = new StringWriter();
            FileUtil.copyContents(in, out);
            String bodyContent = out.toString();
            if (bodyContent != null) {
                arglist.put(PARAM_BODY, bodyContent);
            }
        }
        return arglist;
    }

    public String execute(WikiContext context, String commandline) throws PluginException {
        if (!this.m_pluginsEnabled) {
            return "";
        }
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            if (matcher.contains(commandline, this.m_pluginPattern)) {
                MatchResult res = matcher.getMatch();
                String plugin = res.group(2);
                String args = commandline.substring(res.endOffset(0), commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0));
                Map arglist = this.parseArgs(args);
                return this.execute(context, plugin, arglist);
            }
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(msg);
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(msg);
        }
        return commandline;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

