/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.TranslatorReader;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;

public class RecentChangesPlugin
implements WikiPlugin {
    private static final int DEFAULT_DAYS = 36500;
    private static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$plugin$RecentChangesPlugin == null ? (class$com$ecyrd$jspwiki$plugin$RecentChangesPlugin = RecentChangesPlugin.class$("com.ecyrd.jspwiki.plugin.RecentChangesPlugin")) : class$com$ecyrd$jspwiki$plugin$RecentChangesPlugin));
    static /* synthetic */ Class class$com$ecyrd$jspwiki$plugin$RecentChangesPlugin;

    private boolean isSameDay(Date a, Date b) {
        Calendar aa = Calendar.getInstance();
        aa.setTime(a);
        Calendar bb = Calendar.getInstance();
        bb.setTime(b);
        return aa.get(1) == bb.get(1) && aa.get(6) == bb.get(6);
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        int since = TextUtil.parseIntParameter((String)params.get("since"), 36500);
        int spacing = 4;
        boolean showAuthor = true;
        WikiEngine engine = context.getEngine();
        String format = (String)params.get("format");
        if ("compact".equals(params.get("format"))) {
            spacing = 0;
            showAuthor = false;
        }
        GregorianCalendar sincedate = new GregorianCalendar();
        ((Calendar)sincedate).add(5, -since);
        log.debug((Object)("Calculating recent changes from " + sincedate.getTime()));
        Collection changes = engine.getRecentChanges();
        StringWriter out = new StringWriter();
        TranslatorReader linkProcessor = new TranslatorReader(context, new StringReader(""));
        if (changes != null) {
            WikiPage pageref;
            Date lastmod;
            Date olddate = new Date(0L);
            SimpleDateFormat fmt = new SimpleDateFormat("dd.MM.yyyy");
            SimpleDateFormat tfmt = new SimpleDateFormat("HH:mm:ss");
            out.write("<table border=\"0\" cellpadding=\"" + spacing + "\">\n");
            Iterator i = changes.iterator();
            while (i.hasNext() && !(lastmod = (pageref = (WikiPage)i.next()).getLastModified()).before(sincedate.getTime())) {
                if (!this.isSameDay(lastmod, olddate)) {
                    out.write("<tr>\n");
                    out.write("  <td colspan=\"2\"><b>" + fmt.format(lastmod) + "</b></td>\n");
                    out.write("</tr>\n");
                    olddate = lastmod;
                }
                String pageurl = engine.encodeName(pageref.getName());
                String link = linkProcessor.makeLink(pageref instanceof Attachment ? 10 : 0, pageref.getName(), pageref.getName());
                out.write("<tr>\n");
                out.write("<td width=\"30%\">" + link + "</td>\n");
                if (pageref instanceof Attachment) {
                    out.write("<td>" + tfmt.format(lastmod) + "</td>");
                } else {
                    out.write("<td><a href=\"" + engine.getBaseURL() + "Diff.jsp?page=" + pageurl + "&amp;r1=-1\">" + tfmt.format(lastmod) + "</a></td>\n");
                }
                if (showAuthor) {
                    String author = pageref.getAuthor();
                    if (author != null) {
                        if (engine.pageExists(author)) {
                            author = linkProcessor.makeLink(0, author, author);
                        }
                    } else {
                        author = "unknown";
                    }
                    out.write("<td>" + author + "</td>");
                }
                out.write("</tr>\n");
            }
            out.write("</table>\n");
        }
        return out.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

