/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.attachment.AttachmentManager;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class VotePlugin
implements WikiPlugin {
    static Logger log = Logger.getLogger((Class)(class$com$ecyrd$jspwiki$plugin$VotePlugin == null ? (class$com$ecyrd$jspwiki$plugin$VotePlugin = VotePlugin.class$("com.ecyrd.jspwiki.plugin.VotePlugin")) : class$com$ecyrd$jspwiki$plugin$VotePlugin));
    public static String ATTACHMENT_NAME = "VotePlugin.properties";
    public static String VAR_VOTES = "VotePlugin.votes";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$plugin$VotePlugin;

    public int vote(WikiContext context, int vote) {
        Properties props = this.getVotes(context);
        if (vote > 0) {
            int nVotes = this.getYesVotes(context);
            this.putVotes(context, "yes", ++nVotes);
            return nVotes;
        }
        if (vote < 0) {
            int nVotes = this.getNoVotes(context);
            this.putVotes(context, "no", ++nVotes);
            return nVotes;
        }
        return -1;
    }

    private void putVotes(WikiContext context, String yesno, int nVotes) {
        WikiEngine engine = context.getEngine();
        WikiPage page = context.getPage();
        Properties props = this.getVotes(context);
        props.setProperty(yesno, Integer.toString(nVotes));
        page.setAttribute(VAR_VOTES, props);
        this.storeAttachment(context, props);
    }

    private void storeAttachment(WikiContext context, Properties props) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            props.store(out, "JSPWiki Votes plugin stores its votes here.  Don't modify!");
            out.close();
            AttachmentManager attmgr = context.getEngine().getAttachmentManager();
            Attachment att = this.findAttachment(context);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            attmgr.storeAttachment(att, in);
            ((InputStream)in).close();
        }
        catch (Exception ex) {
            log.error((Object)"Unable to write properties", (Throwable)ex);
        }
    }

    private Attachment findAttachment(WikiContext context) throws ProviderException {
        Attachment att = context.getEngine().getAttachmentManager().getAttachmentInfo(context, ATTACHMENT_NAME);
        if (att == null) {
            att = new Attachment(context.getPage().getName(), ATTACHMENT_NAME);
        }
        return att;
    }

    private Properties getVotes(WikiContext context) {
        WikiPage page = context.getPage();
        Properties props = (Properties)page.getAttribute(VAR_VOTES);
        if (props == null) {
            props = new Properties();
            AttachmentManager attmgr = context.getEngine().getAttachmentManager();
            try {
                Attachment att = attmgr.getAttachmentInfo(context, ATTACHMENT_NAME);
                if (att != null) {
                    props.load(attmgr.getAttachmentStream(att));
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to load attachment ", (Throwable)e);
            }
        }
        return props;
    }

    private int getYesVotes(WikiContext context) {
        Properties props = this.getVotes(context);
        return TextUtil.getIntegerProperty(props, "yes", 0);
    }

    private int getNoVotes(WikiContext context) {
        Properties props = this.getVotes(context);
        return TextUtil.getIntegerProperty(props, "no", 0);
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String posneg = (String)params.get("value");
        if (TextUtil.isPositive(posneg)) {
            return Integer.toString(this.getYesVotes(context));
        }
        return Integer.toString(this.getNoVotes(context));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

