/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.PageLock;
import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WeblogPlugin;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;

public class WeblogEntryPlugin
implements WikiPlugin {
    private static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$plugin$WeblogEntryPlugin == null ? (class$com$ecyrd$jspwiki$plugin$WeblogEntryPlugin = WeblogEntryPlugin.class$("com.ecyrd.jspwiki.plugin.WeblogEntryPlugin")) : class$com$ecyrd$jspwiki$plugin$WeblogEntryPlugin));
    public static final int MAX_BLOG_ENTRIES = 10000;
    public static final String PARAM_ENTRYTEXT = "entrytext";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$plugin$WeblogEntryPlugin;

    public String getNewEntryPage(WikiEngine engine, String blogName) throws ProviderException {
        SimpleDateFormat fmt = new SimpleDateFormat("ddMMyy");
        String today = fmt.format(new Date());
        int entryNum = this.findFreeEntry(engine.getPageManager(), blogName, today);
        String blogPage = WeblogPlugin.makeEntryPage(blogName, today, "" + entryNum);
        return blogPage;
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        String weblogName = context.getPage().getName();
        WikiEngine engine = context.getEngine();
        StringBuffer sb = new StringBuffer();
        String entryText = (String)params.get(PARAM_ENTRYTEXT);
        if (entryText == null) {
            entryText = "New entry";
        }
        try {
            String blogPage = this.getNewEntryPage(engine, weblogName);
            sb.append("<a href=\"" + engine.getBaseURL() + "NewBlogEntry.jsp?page=" + engine.encodeName(weblogName) + "\">" + entryText + "</a>");
        }
        catch (ProviderException e) {
            log.error((Object)"Could not locate blog entries", (Throwable)e);
            throw new PluginException("Could not locate blog entries: " + e.getMessage());
        }
        return sb.toString();
    }

    private int findFreeEntry(PageManager mgr, String baseName, String date) throws ProviderException {
        WikiPage page;
        PageLock lock;
        int idx;
        Collection everyone = mgr.getAllPages();
        int max = 0;
        String startString = WeblogPlugin.makeEntryPage(baseName, date, "");
        Iterator i = everyone.iterator();
        while (i.hasNext()) {
            WikiPage p = (WikiPage)i.next();
            if (!p.getName().startsWith(startString)) continue;
            try {
                String probableId = p.getName().substring(startString.length());
                int id = Integer.parseInt(probableId);
                if (id <= max) continue;
                max = id;
            }
            catch (NumberFormatException e) {
                log.debug((Object)("Was not a log entry: " + p.getName()));
            }
        }
        for (idx = max + 1; idx < 10000 && (lock = mgr.getCurrentLock(page = new WikiPage(WeblogPlugin.makeEntryPage(baseName, date, Integer.toString(idx))))) != null; ++idx) {
        }
        return idx;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

