/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.plugin;

import com.ecyrd.jspwiki.PageManager;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.plugin.PluginException;
import com.ecyrd.jspwiki.plugin.WikiPlugin;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Category;

public class WeblogPlugin
implements WikiPlugin {
    private static Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$plugin$WeblogPlugin == null ? (class$com$ecyrd$jspwiki$plugin$WeblogPlugin = WeblogPlugin.class$("com.ecyrd.jspwiki.plugin.WeblogPlugin")) : class$com$ecyrd$jspwiki$plugin$WeblogPlugin));
    public static final int DEFAULT_DAYS = 7;
    public static final String DEFAULT_PAGEFORMAT = "%p_blogentry_";
    public static final String DEFAULT_DATEFORMAT = "ddMMyy";
    public static final String PARAM_STARTDATE = "startDate";
    public static final String PARAM_DAYS = "days";
    public static final String PARAM_ALLOWCOMMENTS = "allowComments";
    public static final String PARAM_MAXENTRIES = "maxEntries";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$plugin$WeblogPlugin;

    public static String makeEntryPage(String pageName, String date, String entryNum) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName) + date + "_" + entryNum;
    }

    public static String makeEntryPage(String pageName) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName);
    }

    public static String makeEntryPage(String pageName, String date) {
        return TextUtil.replaceString(DEFAULT_PAGEFORMAT, "%p", pageName) + date;
    }

    public String execute(WikiContext context, Map params) throws PluginException {
        String weblogName = context.getPage().getName();
        WikiEngine engine = context.getEngine();
        String startDay = null;
        boolean hasComments = false;
        String days = context.getHttpParameter("weblog.days");
        if (days == null) {
            days = (String)params.get(PARAM_DAYS);
        }
        int numDays = TextUtil.parseIntParameter(days, 7);
        startDay = (String)params.get(PARAM_STARTDATE);
        if (startDay == null) {
            startDay = context.getHttpParameter("weblog.startDate");
        }
        if (TextUtil.isPositive((String)params.get(PARAM_ALLOWCOMMENTS))) {
            hasComments = true;
        }
        int maxEntries = TextUtil.parseIntParameter((String)params.get(PARAM_MAXENTRIES), Integer.MAX_VALUE);
        Calendar startTime = Calendar.getInstance();
        Calendar stopTime = Calendar.getInstance();
        if (startDay != null) {
            SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATEFORMAT);
            try {
                Date d = fmt.parse(startDay);
                startTime.setTime(d);
                stopTime.setTime(d);
            }
            catch (ParseException e) {
                return "Illegal time format: " + startDay;
            }
        }
        startTime.add(5, -numDays);
        startTime.set(10, 0);
        startTime.set(12, 0);
        startTime.set(13, 0);
        stopTime.set(10, 23);
        stopTime.set(12, 59);
        stopTime.set(13, 59);
        StringBuffer sb = new StringBuffer();
        try {
            List blogEntries = this.findBlogEntries(engine.getPageManager(), weblogName, startTime.getTime(), stopTime.getTime());
            Collections.sort(blogEntries, new PageDateComparator());
            SimpleDateFormat entryDateFmt = new SimpleDateFormat("dd-MMM-yyyy HH:mm");
            sb.append("<div class=\"weblog\">\n");
            Iterator i = blogEntries.iterator();
            while (i.hasNext() && maxEntries-- > 0) {
                WikiPage p = (WikiPage)i.next();
                sb.append("<div class=\"weblogentry\">\n");
                sb.append("<div class=\"weblogentryheading\">\n");
                Date entryDate = p.getLastModified();
                sb.append(entryDateFmt.format(entryDate));
                sb.append("</div>\n");
                sb.append("<div class=\"weblogentrybody\">\n");
                WikiContext entryCtx = new WikiContext(engine, p);
                sb.append(engine.getHTML(entryCtx, engine.getPage(p.getName())));
                sb.append("</div>\n");
                sb.append("<div class=\"weblogentryfooter\">\n");
                String author = p.getAuthor();
                if (author != null) {
                    if (engine.pageExists(author)) {
                        author = "<a href=\"" + engine.getViewURL(author) + "\">" + author + "</a>";
                    }
                } else {
                    author = "AnonymousCoward";
                }
                sb.append("By " + author + "&nbsp;&nbsp;");
                sb.append("<a href=\"" + engine.getViewURL(p.getName()) + "\">Permalink</a>");
                String commentPageName = TextUtil.replaceString(p.getName(), "blogentry", "comments");
                if (hasComments) {
                    int numComments = this.guessNumberOfComments(engine, commentPageName);
                    sb.append("&nbsp;&nbsp;");
                    sb.append("<a target=\"_blank\" href=\"" + engine.getBaseURL() + "Comment.jsp?page=" + engine.encodeName(commentPageName) + "&nc=" + numComments + "\">Comments? (" + numComments + ")</a>");
                }
                sb.append("</div>\n");
                sb.append("</div>\n");
            }
            sb.append("</div>\n");
        }
        catch (ProviderException e) {
            log.error((Object)"Could not locate blog entries", (Throwable)e);
            throw new PluginException("Could not locate blog entries: " + e.getMessage());
        }
        return sb.toString();
    }

    private int guessNumberOfComments(WikiEngine engine, String commentpage) throws ProviderException {
        String pagedata = engine.getPureText(commentpage, -1);
        int tags = 0;
        int start = 0;
        while ((start = pagedata.indexOf("----", start)) != -1) {
            ++tags;
            start += 4;
        }
        return pagedata.length() > 0 ? tags + 1 : 0;
    }

    public List findBlogEntries(PageManager mgr, String baseName, Date start, Date end) throws ProviderException {
        Collection everyone = mgr.getAllPages();
        ArrayList<WikiPage> result = new ArrayList<WikiPage>();
        baseName = WeblogPlugin.makeEntryPage(baseName);
        SimpleDateFormat fmt = new SimpleDateFormat(DEFAULT_DATEFORMAT);
        Iterator i = everyone.iterator();
        while (i.hasNext()) {
            WikiPage p = (WikiPage)i.next();
            String pageName = p.getName();
            if (!pageName.startsWith(baseName)) continue;
            try {
                String creationDate;
                Date pageDay;
                int secondScore;
                int firstScore = pageName.indexOf(95, baseName.length() - 1);
                if (firstScore == -1 || firstScore + 1 >= pageName.length() || (secondScore = pageName.indexOf(95, firstScore + 1)) == -1 || (pageDay = fmt.parse(creationDate = pageName.substring(firstScore + 1, secondScore))) == null || !pageDay.after(start) || !pageDay.before(end)) continue;
                WikiPage firstVersion = mgr.getPageInfo(pageName, 1);
                result.add(firstVersion);
            }
            catch (Exception e) {
                log.debug((Object)("Page name :" + pageName + " was suspected as a blog entry but it isn't because of parsing errors"), (Throwable)e);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PageDateComparator
    implements Comparator {
        private PageDateComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            WikiPage page1 = (WikiPage)o1;
            WikiPage page2 = (WikiPage)o2;
            return page2.getLastModified().compareTo(page1.getLastModified());
        }
    }
}

