/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.InternalWikiException;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.SearchMatcher;
import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.SearchResultComparator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Category;

public abstract class AbstractFileProvider
implements WikiPageProvider {
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$providers$AbstractFileProvider == null ? (class$com$ecyrd$jspwiki$providers$AbstractFileProvider = AbstractFileProvider.class$("com.ecyrd.jspwiki.providers.AbstractFileProvider")) : class$com$ecyrd$jspwiki$providers$AbstractFileProvider));
    private String m_pageDirectory = "/tmp/";
    protected String m_encoding;
    public static final String PROP_PAGEDIR = "jspwiki.fileSystemProvider.pageDir";
    public static final String FILE_EXT = ".txt";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$providers$AbstractFileProvider;

    public void initialize(Properties properties) throws NoRequiredPropertyException, IOException {
        log.debug((Object)"Initing FileSystemProvider");
        this.m_pageDirectory = WikiEngine.getRequiredProperty(properties, PROP_PAGEDIR);
        File f = new File(this.m_pageDirectory);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            throw new IOException("Page directory is not a directory: " + this.m_pageDirectory);
        }
        this.m_encoding = properties.getProperty("jspwiki.encoding", DEFAULT_ENCODING);
        log.info((Object)("Wikipages are read from '" + this.m_pageDirectory + "'"));
    }

    String getPageDirectory() {
        return this.m_pageDirectory;
    }

    protected String mangleName(String pagename) {
        if ("UTF-8".equalsIgnoreCase(this.m_encoding)) {
            return TextUtil.urlEncodeUTF8(pagename);
        }
        return URLEncoder.encode(pagename);
    }

    protected String unmangleName(String filename) {
        if ("UTF-8".equalsIgnoreCase(this.m_encoding)) {
            return TextUtil.urlDecodeUTF8(filename);
        }
        return URLDecoder.decode(filename);
    }

    protected File findPage(String page) {
        return new File(this.m_pageDirectory, this.mangleName(page) + FILE_EXT);
    }

    public boolean pageExists(String page) {
        File pagefile = this.findPage(page);
        return pagefile.exists();
    }

    public String getPageText(String page, int version) throws ProviderException {
        return this.getPageText(page);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String getPageText(String page) {
        String result;
        block11: {
            block12: {
                File pagedata;
                block13: {
                    result = null;
                    FileInputStream in = null;
                    pagedata = this.findPage(page);
                    if (!pagedata.exists()) break block12;
                    if (!pagedata.canRead()) break block13;
                    in = new FileInputStream(pagedata);
                    result = FileUtil.readContents(in, this.m_encoding);
                    Object var7_5 = null;
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                        break block11;
                    }
                    catch (Exception e2) {
                        log.fatal((Object)"Closing failed", (Throwable)e2);
                    }
                    break block11;
                    {
                        catch (IOException e) {
                            log.error((Object)"Failed to read", (Throwable)e);
                            Object var7_6 = null;
                            try {
                                if (in != null) {
                                    ((InputStream)in).close();
                                }
                                break block11;
                            }
                            catch (Exception e2) {
                                log.fatal((Object)"Closing failed", (Throwable)e2);
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        try {
                            if (in != null) {
                                ((InputStream)in).close();
                            }
                        }
                        catch (Exception e2) {
                            log.fatal((Object)"Closing failed", (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                log.warn((Object)("Failed to read page '" + page + "' from '" + pagedata.getAbsolutePath() + "', possibly a permissions problem"));
                break block11;
            }
            log.info((Object)("New page '" + page + "'"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPageText(WikiPage page, String text) {
        File file = this.findPage(page.getName());
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.m_encoding));
            out.print(text);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public Collection getAllPages() throws ProviderException {
        log.debug((Object)"Getting all pages...");
        ArrayList<WikiPage> set = new ArrayList<WikiPage>();
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        if (wikipages == null) {
            log.error((Object)("Wikipages directory '" + this.m_pageDirectory + "' does not exist! Please check " + PROP_PAGEDIR + " in jspwiki.properties."));
            throw new InternalWikiException("Page directory does not exist");
        }
        for (int i = 0; i < wikipages.length; ++i) {
            int cutpoint;
            String wikiname = wikipages[i].getName();
            WikiPage page = this.getPageInfo(this.unmangleName(wikiname.substring(0, cutpoint = wikiname.lastIndexOf(FILE_EXT))), -1);
            if (page == null) {
                log.error((Object)("Page " + wikiname + " was found in directory listing, but could not be located individually."));
                continue;
            }
            set.add(page);
        }
        return set;
    }

    public Collection getAllChangedSince(Date date) {
        return new ArrayList();
    }

    public int getPageCount() {
        File wikipagedir = new File(this.m_pageDirectory);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        return wikipages.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Collection findPages(QueryItem[] query) {
        File wikipagedir = new File(this.m_pageDirectory);
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(query);
        File[] wikipages = wikipagedir.listFiles(new WikiFileFilter());
        for (int i = 0; i < wikipages.length; ++i) {
            String filename;
            FileInputStream input;
            block10: {
                input = null;
                filename = wikipages[i].getName();
                int cutpoint = filename.lastIndexOf(FILE_EXT);
                String wikiname = filename.substring(0, cutpoint);
                wikiname = this.unmangleName(wikiname);
                input = new FileInputStream(wikipages[i]);
                String pagetext = FileUtil.readContents(input, this.m_encoding);
                SearchResult comparison = matcher.matchPageContent(wikiname, pagetext);
                if (comparison == null) break block10;
                res.add(comparison);
            }
            Object var14_14 = null;
            try {
                if (input == null) continue;
                input.close();
            }
            catch (IOException e2) {}
            continue;
            {
                catch (IOException e) {
                    log.error((Object)("Failed to read " + filename), (Throwable)e);
                    var14_14 = null;
                    try {
                        if (input == null) continue;
                        input.close();
                    }
                    catch (IOException e2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var14_14 = null;
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return res;
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        File file = this.findPage(page);
        if (!file.exists()) {
            return null;
        }
        WikiPage p = new WikiPage(page);
        p.setLastModified(new Date(file.lastModified()));
        return p;
    }

    public List getVersionHistory(String page) throws ProviderException {
        ArrayList<WikiPage> list = new ArrayList<WikiPage>();
        list.add(this.getPageInfo(page, -1));
        return list;
    }

    public String getProviderInfo() {
        return "";
    }

    public void deleteVersion(String pageName, int version) {
    }

    public void deletePage(String pageName) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class WikiFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(AbstractFileProvider.FILE_EXT);
        }
    }
}

