/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.PageTimeComparator;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.attachment.Attachment;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiAttachmentProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;

public class BasicAttachmentProvider
implements WikiAttachmentProvider {
    private String m_storageDir;
    public static final String PROP_STORAGEDIR = "jspwiki.basicAttachmentProvider.storageDir";
    public static final String PROPERTY_FILE = "attachment.properties";
    public static final String DIR_EXTENSION = "-att";
    public static final String ATTDIR_EXTENSION = "-dir";
    static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$providers$BasicAttachmentProvider == null ? (class$com$ecyrd$jspwiki$providers$BasicAttachmentProvider = BasicAttachmentProvider.class$("com.ecyrd.jspwiki.providers.BasicAttachmentProvider")) : class$com$ecyrd$jspwiki$providers$BasicAttachmentProvider));
    static /* synthetic */ Class class$com$ecyrd$jspwiki$providers$BasicAttachmentProvider;

    public void initialize(Properties properties) throws NoRequiredPropertyException, IOException {
        this.m_storageDir = WikiEngine.getRequiredProperty(properties, PROP_STORAGEDIR);
        File f = new File(this.m_storageDir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    private File findPageDir(String wikipage) throws ProviderException {
        File f = new File(this.m_storageDir, (wikipage = BasicAttachmentProvider.mangleName(wikipage)) + DIR_EXTENSION);
        if (f.exists() && !f.isDirectory()) {
            throw new ProviderException("Storage dir '" + f.getAbsolutePath() + "' is not a directory!");
        }
        return f;
    }

    private static String mangleName(String wikiname) {
        String res = TextUtil.urlEncodeUTF8(wikiname);
        return res;
    }

    private static String unmangleName(String filename) {
        return TextUtil.urlDecodeUTF8(filename);
    }

    private File findAttachmentDir(Attachment att) throws ProviderException {
        File f = new File(this.findPageDir(att.getParentName()), BasicAttachmentProvider.mangleName(att.getFileName() + ATTDIR_EXTENSION));
        if (!f.exists()) {
            File oldf = new File(this.findPageDir(att.getParentName()), BasicAttachmentProvider.mangleName(att.getFileName()));
            if (oldf.exists()) {
                f = oldf;
            } else {
                oldf = new File(this.findPageDir(att.getParentName()), att.getFileName());
                if (oldf.exists()) {
                    f = oldf;
                }
            }
        }
        return f;
    }

    private int findLatestVersion(Attachment att) throws ProviderException {
        File attDir = this.findAttachmentDir(att);
        String[] pages = attDir.list(new AttachmentVersionFilter());
        if (pages == null) {
            return 0;
        }
        int version = 0;
        for (int i = 0; i < pages.length; ++i) {
            int cutpoint = pages[i].indexOf(46);
            String pageNum = cutpoint > 0 ? pages[i].substring(0, cutpoint) : pages[i];
            try {
                int res = Integer.parseInt(pageNum);
                if (res <= version) continue;
                version = res;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return version;
    }

    protected static String getFileExtension(String filename) {
        String fileExt = "bin";
        int dot = filename.lastIndexOf(46);
        if (dot >= 0 && dot < filename.length() - 1) {
            fileExt = BasicAttachmentProvider.mangleName(filename.substring(dot + 1));
        }
        return fileExt;
    }

    private void putPageProperties(Attachment att, Properties properties) throws IOException, ProviderException {
        File attDir = this.findAttachmentDir(att);
        File propertyFile = new File(attDir, PROPERTY_FILE);
        FileOutputStream out = new FileOutputStream(propertyFile);
        properties.store(out, " JSPWiki page properties for " + att.getName() + ". DO NOT MODIFY!");
        ((OutputStream)out).close();
    }

    private Properties getPageProperties(Attachment att) throws IOException, ProviderException {
        Properties props = new Properties();
        File propertyFile = new File(this.findAttachmentDir(att), PROPERTY_FILE);
        if (propertyFile != null && propertyFile.exists()) {
            FileInputStream in = new FileInputStream(propertyFile);
            props.load(in);
            ((InputStream)in).close();
        }
        return props;
    }

    public void putAttachmentData(Attachment att, InputStream data) throws ProviderException, IOException {
        OutputStream out = null;
        File attDir = this.findAttachmentDir(att);
        if (!attDir.exists()) {
            attDir.mkdirs();
        }
        int latestVersion = this.findLatestVersion(att);
        try {
            int versionNumber = latestVersion + 1;
            File newfile = new File(attDir, versionNumber + "." + BasicAttachmentProvider.getFileExtension(att.getFileName()));
            log.info((Object)("Uploading attachment " + att.getFileName() + " to page " + att.getParentName()));
            log.info((Object)("Saving attachment contents to " + newfile.getAbsolutePath()));
            out = new FileOutputStream(newfile);
            FileUtil.copyContents(data, out);
            out.close();
            Properties props = this.getPageProperties(att);
            String author = att.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            props.setProperty(versionNumber + ".author", author);
            this.putPageProperties(att, props);
        }
        catch (IOException e) {
            log.error((Object)"Could not save attachment data: ", (Throwable)e);
            throw (IOException)e.fillInStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String getProviderInfo() {
        return "";
    }

    private File findFile(File dir, Attachment att) throws FileNotFoundException, ProviderException {
        int version = att.getVersion();
        if (version == -1) {
            version = this.findLatestVersion(att);
        }
        String ext = BasicAttachmentProvider.getFileExtension(att.getFileName());
        File f = new File(dir, version + "." + ext);
        if (!f.exists()) {
            File fOld;
            if ("bin".equals(ext) && (fOld = new File(dir, version + ".")).exists()) {
                f = fOld;
            }
            if (!f.exists()) {
                throw new FileNotFoundException("No such file: " + f.getAbsolutePath() + " exists.");
            }
        }
        return f;
    }

    public InputStream getAttachmentData(Attachment att) throws IOException, ProviderException {
        File attDir = this.findAttachmentDir(att);
        File f = this.findFile(attDir, att);
        return new FileInputStream(f);
    }

    public Collection listAttachments(WikiPage page) throws ProviderException {
        String[] attachments;
        ArrayList<Attachment> result = new ArrayList<Attachment>();
        File dir = this.findPageDir(page.getName());
        if (dir != null && (attachments = dir.list()) != null) {
            for (int i = 0; i < attachments.length; ++i) {
                Attachment att;
                File f = new File(dir, attachments[i]);
                if (!f.isDirectory()) continue;
                String attachmentName = BasicAttachmentProvider.unmangleName(attachments[i]);
                if (attachmentName.endsWith(ATTDIR_EXTENSION)) {
                    attachmentName = attachmentName.substring(0, attachmentName.length() - ATTDIR_EXTENSION.length());
                }
                if ((att = this.getAttachmentInfo(page, attachmentName, -1)) == null) {
                    throw new ProviderException("Attachment disappeared while reading information: if you did not touch the repository, there is a serious bug somewhere. Attachment = " + attachments[i] + ", decoded = " + attachmentName);
                }
                result.add(att);
            }
        }
        return result;
    }

    public Collection findAttachments(QueryItem[] query) {
        return null;
    }

    public List listAllChanged(Date timestamp) throws ProviderException {
        File attDir = new File(this.m_storageDir);
        if (!attDir.exists()) {
            throw new ProviderException("Specified attachment directory " + this.m_storageDir + " does not exist!");
        }
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        String[] pagesWithAttachments = attDir.list(new AttachmentFilter());
        for (int i = 0; i < pagesWithAttachments.length; ++i) {
            String pageId = BasicAttachmentProvider.unmangleName(pagesWithAttachments[i]);
            pageId = pageId.substring(0, pageId.length() - DIR_EXTENSION.length());
            Collection c = this.listAttachments(new WikiPage(pageId));
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Attachment att = (Attachment)it.next();
                if (!att.getLastModified().after(timestamp)) continue;
                list.add(att);
            }
        }
        Collections.sort(list, new PageTimeComparator());
        return list;
    }

    public Attachment getAttachmentInfo(WikiPage page, String name, int version) throws ProviderException {
        Attachment att = new Attachment(page.getName(), name);
        File dir = this.findAttachmentDir(att);
        if (!dir.exists()) {
            return null;
        }
        if (version == -1) {
            version = this.findLatestVersion(att);
        }
        att.setVersion(version);
        try {
            Properties props = this.getPageProperties(att);
            att.setAuthor(props.getProperty(version + ".author"));
            File f = this.findFile(dir, att);
            att.setSize(f.length());
            att.setLastModified(new Date(f.lastModified()));
        }
        catch (IOException e) {
            log.error((Object)"Can't read page properties", (Throwable)e);
            throw new ProviderException("Cannot read page properties: " + e.getMessage());
        }
        return att;
    }

    public List getVersionHistory(Attachment att) {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        try {
            int latest;
            for (int i = latest = this.findLatestVersion(att); i >= 1; --i) {
                Attachment a = this.getAttachmentInfo(new WikiPage(att.getParentName()), att.getFileName(), i);
                if (a == null) continue;
                list.add(a);
            }
        }
        catch (ProviderException e) {
            log.error((Object)("Getting version history failed for page: " + att), (Throwable)e);
        }
        return list;
    }

    public void deleteVersion(Attachment att) throws ProviderException {
    }

    public void deleteAttachment(Attachment att) throws ProviderException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class AttachmentVersionFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return !name.equals(BasicAttachmentProvider.PROPERTY_FILE);
        }
    }

    public class AttachmentFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(BasicAttachmentProvider.DIR_EXTENSION);
        }
    }
}

