/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.SearchMatcher;
import com.ecyrd.jspwiki.SearchResult;
import com.ecyrd.jspwiki.SearchResultComparator;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.RepositoryModifiedException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import com.ecyrd.jspwiki.util.ClassUtil;
import com.opensymphony.module.oscache.base.Cache;
import com.opensymphony.module.oscache.base.NeedsRefreshException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class CachingProvider
implements WikiPageProvider {
    private static final Logger log = Logger.getLogger((Class)(class$com$ecyrd$jspwiki$providers$CachingProvider == null ? (class$com$ecyrd$jspwiki$providers$CachingProvider = CachingProvider.class$("com.ecyrd.jspwiki.providers.CachingProvider")) : class$com$ecyrd$jspwiki$providers$CachingProvider));
    private WikiPageProvider m_provider;
    private HashMap m_cache = new HashMap();
    private Cache m_textCache;
    private long m_cacheMisses = 0L;
    private long m_cacheHits = 0L;
    private int m_milliSecondsBetweenChecks = 30000;
    private int m_refreshPeriod = 86400;
    public static final String PROP_CACHECHECKINTERVAL = "jspwiki.cachingProvider.cacheCheckInterval";
    public static final String PROP_CACHECAPACITY = "jspwiki.cachingProvider.capacity";
    private static final int DEFAULT_CACHECAPACITY = 200;
    private boolean m_gotall = false;
    static /* synthetic */ Class class$com$ecyrd$jspwiki$providers$CachingProvider;

    public void initialize(Properties properties) throws NoRequiredPropertyException, IOException {
        log.debug((Object)"Initing CachingProvider");
        this.m_milliSecondsBetweenChecks = TextUtil.getIntegerProperty(properties, PROP_CACHECHECKINTERVAL, this.m_milliSecondsBetweenChecks);
        log.debug((Object)("Cache consistency checks every " + this.m_milliSecondsBetweenChecks + " ms"));
        int capacity = TextUtil.getIntegerProperty(properties, PROP_CACHECAPACITY, 200);
        log.debug((Object)("Cache capacity " + capacity + " pages."));
        this.m_textCache = new Cache(true, false, "com.opensymphony.module.oscache.base.algorithm.LRUCache", capacity);
        String classname = WikiEngine.getRequiredProperty(properties, "jspwiki.pageProvider");
        try {
            Class providerclass = ClassUtil.findClass("com.ecyrd.jspwiki.providers", classname);
            this.m_provider = (WikiPageProvider)providerclass.newInstance();
            log.debug((Object)("Initializing real provider class " + this.m_provider));
            this.m_provider.initialize(properties);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("no provider class");
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("faulty provider class");
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class " + classname), (Throwable)e);
            throw new IllegalArgumentException("illegal provider class");
        }
    }

    public boolean pageExists(String page) {
        CacheItem item = (CacheItem)this.m_cache.get(page);
        if (this.checkIfPageChanged(item)) {
            try {
                this.revalidatePage(item.m_page);
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
            return this.m_provider.pageExists(page);
        }
        if (item != null) {
            return true;
        }
        return this.m_provider.pageExists(page);
    }

    public String getPageText(String page, int version) throws ProviderException {
        String result = null;
        if (version == -1) {
            if (this.pageExists(page)) {
                result = this.getTextFromCache(page);
            }
        } else {
            CacheItem item = (CacheItem)this.m_cache.get(page);
            result = item != null && item.m_page.getVersion() == version ? this.getTextFromCache(page) : this.m_provider.getPageText(page, version);
        }
        return result;
    }

    private boolean checkIfPageChanged(CacheItem item) {
        if (item == null) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - item.m_lastChecked > (long)this.m_milliSecondsBetweenChecks) {
            try {
                WikiPage cached = item.m_page;
                WikiPage current = this.m_provider.getPageInfo(cached.getName(), -1);
                if (current == null) {
                    log.debug((Object)("Page " + cached.getName() + " has been removed externally."));
                    return true;
                }
                item.m_lastChecked = currentTime;
                long epsilon = 1000L;
                Date curDate = current.getLastModified();
                Date cacDate = cached.getLastModified();
                if (curDate != null && cacDate != null && curDate.getTime() - cacDate.getTime() > epsilon) {
                    log.debug((Object)("Page " + current.getName() + " has been externally modified, refreshing contents."));
                    return true;
                }
            }
            catch (ProviderException e) {
                log.error((Object)"While checking cache, got error: ", (Throwable)e);
            }
        }
        return false;
    }

    private synchronized void revalidatePage(WikiPage page) throws ProviderException {
        this.m_cache.remove(page.getName());
        this.m_textCache.flushEntry(page.getName());
        this.addPage(page.getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTextFromCache(String page) throws ProviderException {
        String text;
        CacheItem item;
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            item = (CacheItem)this.m_cache.get(page);
        }
        if (this.checkIfPageChanged(item)) {
            this.revalidatePage(item.m_page);
            throw new RepositoryModifiedException(page);
        }
        if (item == null) {
            text = this.m_provider.getPageText(page, -1);
            this.addPage(page, text);
            ++this.m_cacheMisses;
            return text;
        }
        try {
            text = (String)this.m_textCache.getFromCache(page, this.m_refreshPeriod);
        }
        catch (NeedsRefreshException e) {
            text = this.m_provider.getPageText(page, -1);
            this.m_textCache.putInCache(page, (Object)text);
            ++this.m_cacheMisses;
            return text;
        }
        ++this.m_cacheHits;
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPageText(WikiPage page, String text) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_provider.putPageText(page, text);
            this.revalidatePage(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAllPages() throws ProviderException {
        ArrayList<WikiPage> all;
        if (!this.m_gotall) {
            all = this.m_provider.getAllPages();
            CachingProvider cachingProvider = this;
            synchronized (cachingProvider) {
                Iterator i = all.iterator();
                while (i.hasNext()) {
                    CacheItem item = new CacheItem();
                    item.m_page = (WikiPage)i.next();
                    this.m_cache.put(item.m_page.getName(), item);
                }
                this.m_gotall = true;
            }
        } else {
            all = new ArrayList<WikiPage>();
            Iterator i = this.m_cache.values().iterator();
            while (i.hasNext()) {
                all.add(((CacheItem)i.next()).m_page);
            }
        }
        return all;
    }

    private synchronized CacheItem addPage(String pageName, String text) throws ProviderException {
        CacheItem item = null;
        WikiPage newpage = this.m_provider.getPageInfo(pageName, -1);
        if (newpage != null) {
            item = new CacheItem();
            item.m_page = newpage;
            if (text != null) {
                this.m_textCache.putInCache(pageName, (Object)text);
            }
            this.m_cache.put(pageName, item);
        }
        return item;
    }

    public Collection getAllChangedSince(Date date) {
        return this.m_provider.getAllChangedSince(date);
    }

    public int getPageCount() throws ProviderException {
        return this.m_provider.getPageCount();
    }

    public Collection findPages(QueryItem[] query) {
        TreeSet<SearchResult> res = new TreeSet<SearchResult>(new SearchResultComparator());
        SearchMatcher matcher = new SearchMatcher(query);
        Collection allPages = null;
        try {
            allPages = this.getAllPages();
        }
        catch (ProviderException pe) {
            log.error((Object)"Unable to retrieve page list", (Throwable)pe);
            return null;
        }
        Iterator it = allPages.iterator();
        while (it.hasNext()) {
            try {
                String pageContent;
                WikiPage page = (WikiPage)it.next();
                String pageName = page.getName();
                SearchResult comparison = matcher.matchPageContent(pageName, pageContent = this.getTextFromCache(pageName));
                if (comparison == null) continue;
                res.add(comparison);
            }
            catch (RepositoryModifiedException rme) {
            }
            catch (ProviderException pe) {
                log.error((Object)"Unable to retrieve page from cache", (Throwable)pe);
            }
            catch (IOException ioe) {
                log.error((Object)"Failed to search page", (Throwable)ioe);
            }
        }
        return res;
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        int latestcached;
        CacheItem item = (CacheItem)this.m_cache.get(page);
        int n = latestcached = item != null ? item.m_page.getVersion() : Integer.MIN_VALUE;
        if (version == -1 || version == latestcached) {
            if (item == null && (item = this.addPage(page, null)) == null) {
                return null;
            }
            return item.m_page;
        }
        return this.m_provider.getPageInfo(page, version);
    }

    public List getVersionHistory(String page) throws ProviderException {
        return this.m_provider.getVersionHistory(page);
    }

    public synchronized String getProviderInfo() {
        boolean cachedPages = false;
        long totalSize = 0L;
        return "Real provider: " + this.m_provider.getClass().getName() + "<br />Cache misses: " + this.m_cacheMisses + "<br />Cache hits: " + this.m_cacheHits + "<br />Cache consistency checks: " + this.m_milliSecondsBetweenChecks + "ms";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersion(String pageName, int version) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            int latestcached;
            CacheItem item = (CacheItem)this.m_cache.get(pageName);
            int n = latestcached = item != null ? item.m_page.getVersion() : Integer.MIN_VALUE;
            if (version == -1 || version == latestcached) {
                this.m_cache.remove(pageName);
            }
            this.m_provider.deleteVersion(pageName, version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePage(String pageName) throws ProviderException {
        CachingProvider cachingProvider = this;
        synchronized (cachingProvider) {
            this.m_cache.remove(pageName);
            this.m_provider.deletePage(pageName);
        }
    }

    public WikiPageProvider getRealProvider() {
        return this.m_provider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CacheItem {
        WikiPage m_page;
        long m_lastChecked = 0L;

        private CacheItem() {
        }
    }
}

