/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.AbstractFileProvider;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.log4j.Category;

public class FileSystemProvider
extends AbstractFileProvider {
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$providers$FileSystemProvider == null ? (class$com$ecyrd$jspwiki$providers$FileSystemProvider = FileSystemProvider.class$("com.ecyrd.jspwiki.providers.FileSystemProvider")) : class$com$ecyrd$jspwiki$providers$FileSystemProvider));
    public static final String PROP_EXT = ".properties";
    static /* synthetic */ Class class$com$ecyrd$jspwiki$providers$FileSystemProvider;

    public void putPageText(WikiPage page, String text) {
        try {
            super.putPageText(page, text);
            this.putPageProperties(page);
        }
        catch (IOException e) {
            log.error((Object)"Saving failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putPageProperties(WikiPage page) throws IOException {
        Properties props = new Properties();
        OutputStream out = null;
        try {
            String author = page.getAuthor();
            if (author != null) {
                props.setProperty("author", author);
                File file = new File(this.getPageDirectory(), this.mangleName(page.getName()) + PROP_EXT);
                out = new FileOutputStream(file);
                props.store(out, "JSPWiki page properties for page " + page.getName());
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPageProperties(WikiPage page) throws IOException {
        Properties props = new Properties();
        InputStream in = null;
        try {
            File file = new File(this.getPageDirectory(), this.mangleName(page.getName()) + PROP_EXT);
            if (file != null && file.exists()) {
                in = new FileInputStream(file);
                props.load(in);
                page.setAuthor(props.getProperty("author"));
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        WikiPage p = super.getPageInfo(page, version);
        if (p != null) {
            try {
                this.getPageProperties(p);
            }
            catch (IOException e) {
                log.error((Object)"Unable to read page properties", (Throwable)e);
                throw new ProviderException("Unable to read page properties, check logs.");
            }
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

