/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.providers;

import com.ecyrd.jspwiki.FileUtil;
import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiPage;
import com.ecyrd.jspwiki.providers.AbstractFileProvider;
import com.ecyrd.jspwiki.providers.ProviderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RCSFileProvider
extends AbstractFileProvider {
    private String m_checkinCommand = "ci -q -m\"author=%u\" -l -t-none %s";
    private String m_checkoutCommand = "co -l %s";
    private String m_logCommand = "rlog -zLT -r %s";
    private String m_fullLogCommand = "rlog -zLT %s";
    private String m_checkoutVersionCommand = "co -p -r1.%v %s";
    private static final Category log = Category.getInstance((Class)(class$com$ecyrd$jspwiki$providers$RCSFileProvider == null ? (class$com$ecyrd$jspwiki$providers$RCSFileProvider = RCSFileProvider.class$("com.ecyrd.jspwiki.providers.RCSFileProvider")) : class$com$ecyrd$jspwiki$providers$RCSFileProvider));
    public static final String PROP_CHECKIN = "jspwiki.rcsFileProvider.checkinCommand";
    public static final String PROP_CHECKOUT = "jspwiki.rcsFileProvider.checkoutCommand";
    public static final String PROP_LOG = "jspwiki.rcsFileProvider.logCommand";
    public static final String PROP_FULLLOG = "jspwiki.rcsFileProvider.fullLogCommand";
    public static final String PROP_CHECKOUTVERSION = "jspwiki.rcsFileProvider.checkoutVersionCommand";
    private static final String PATTERN_DATE = "^date:\\s*(.*\\d);";
    private static final String PATTERN_AUTHOR = "^\"?author=([\\w\\.\\s\\+\\.\\%]*)\"?";
    private static final String PATTERN_REVISION = "^revision \\d+\\.(\\d+)";
    private static final String RCSFMT_DATE = "yyyy-MM-dd HH:mm:ss";
    private static final String RCSFMT_DATE_UTC = "yyyy/MM/dd HH:mm:ss";
    private SimpleDateFormat m_rcsdatefmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private SimpleDateFormat m_rcsdatefmt_utc = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static /* synthetic */ Class class$com$ecyrd$jspwiki$providers$RCSFileProvider;

    public void initialize(Properties props) throws NoRequiredPropertyException, IOException {
        log.debug((Object)"Initing RCS");
        super.initialize(props);
        this.m_checkinCommand = props.getProperty(PROP_CHECKIN, this.m_checkinCommand);
        this.m_checkoutCommand = props.getProperty(PROP_CHECKOUT, this.m_checkoutCommand);
        this.m_logCommand = props.getProperty(PROP_LOG, this.m_logCommand);
        this.m_fullLogCommand = props.getProperty(PROP_FULLLOG, this.m_fullLogCommand);
        this.m_checkoutVersionCommand = props.getProperty(PROP_CHECKOUTVERSION, this.m_checkoutVersionCommand);
        File rcsdir = new File(this.getPageDirectory(), "RCS");
        if (!rcsdir.exists()) {
            rcsdir.mkdirs();
        }
        log.debug((Object)("checkin=" + this.m_checkinCommand));
        log.debug((Object)("checkout=" + this.m_checkoutCommand));
        log.debug((Object)("log=" + this.m_logCommand));
        log.debug((Object)("fulllog=" + this.m_fullLogCommand));
        log.debug((Object)("checkoutversion=" + this.m_checkoutVersionCommand));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public WikiPage getPageInfo(String page, int version) throws ProviderException {
        WikiPage info;
        block17: {
            String line;
            Perl5Matcher matcher = new Perl5Matcher();
            Perl5Compiler compiler = new Perl5Compiler();
            BufferedReader stdout = null;
            info = super.getPageInfo(page, version);
            String cmd = this.m_fullLogCommand;
            cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(page) + ".txt");
            Process process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            Pattern headpattern = compiler.compile(PATTERN_REVISION);
            Pattern userpattern = compiler.compile(PATTERN_AUTHOR);
            Pattern datepattern = compiler.compile(PATTERN_DATE);
            boolean found = false;
            while ((line = stdout.readLine()) != null) {
                MatchResult result;
                if (matcher.contains(line, headpattern)) {
                    result = matcher.getMatch();
                    int vernum = Integer.parseInt(result.group(1));
                    if (vernum != version && version != -1) continue;
                    info.setVersion(vernum);
                    found = true;
                    continue;
                }
                if (matcher.contains(line, datepattern) && found) {
                    result = matcher.getMatch();
                    Date d = this.parseDate(result.group(1));
                    if (d != null) {
                        info.setLastModified(d);
                        continue;
                    }
                    log.info((Object)("WikiPage " + info.getName() + " has null modification date for version " + version));
                    continue;
                }
                if (matcher.contains(line, userpattern) && found) {
                    result = matcher.getMatch();
                    info.setAuthor(TextUtil.urlDecodeUTF8(result.group(1)));
                    continue;
                }
                if (!found || !line.startsWith("----")) continue;
            }
            while ((line = stdout.readLine()) != null) {
            }
            process.waitFor();
            Object var18_18 = null;
            try {
                if (stdout != null) {
                    stdout.close();
                }
                break block17;
            }
            catch (IOException e2) {}
            break block17;
            {
                catch (Exception e) {
                    log.warn((Object)"Failed to read RCS info", (Throwable)e);
                    Object var18_19 = null;
                    try {
                        if (stdout != null) {
                            stdout.close();
                        }
                        break block17;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                try {
                    if (stdout != null) {
                        stdout.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getPageText(String page, int version) throws ProviderException {
        String result;
        block13: {
            InputStream stdout;
            block12: {
                result = null;
                stdout = null;
                if (version == -1) {
                    return super.getPageText(page, version);
                }
                log.debug((Object)("Fetching specific version " + version + " of page " + page));
                String cmd = this.m_checkoutVersionCommand;
                cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(page) + ".txt");
                cmd = TextUtil.replaceString(cmd, "%v", Integer.toString(version));
                log.debug((Object)("Command = '" + cmd + "'"));
                Process process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
                stdout = process.getInputStream();
                result = FileUtil.readContents(stdout, this.m_encoding);
                process.waitFor();
                int exitVal = process.exitValue();
                log.debug((Object)("Done, returned = " + exitVal));
                if (exitVal == 0 || version != 1) break block12;
                result = super.getPageText(page, version);
            }
            Object var9_9 = null;
            try {
                if (stdout != null) {
                    stdout.close();
                }
                break block13;
            }
            catch (Exception e2) {}
            break block13;
            {
                catch (Exception e) {
                    log.error((Object)"RCS checkout failed", (Throwable)e);
                    Object var9_10 = null;
                    try {
                        if (stdout != null) {
                            stdout.close();
                        }
                        break block13;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (stdout != null) {
                        stdout.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return result;
    }

    public void putPageText(WikiPage page, String text) {
        String pagename = page.getName();
        super.putPageText(page, text);
        log.debug((Object)"Checking in text...");
        try {
            String cmd = this.m_checkinCommand;
            String author = page.getAuthor();
            if (author == null) {
                author = "unknown";
            }
            cmd = TextUtil.replaceString(cmd, "%s", this.mangleName(pagename) + ".txt");
            cmd = TextUtil.replaceString(cmd, "%u", TextUtil.urlEncodeUTF8(author));
            log.debug((Object)("Command = '" + cmd + "'"));
            Process process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            process.waitFor();
            log.debug((Object)("Done, returned = " + process.exitValue()));
        }
        catch (Exception e) {
            log.error((Object)"RCS checkin failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getVersionHistory(String page) {
        ArrayList<WikiPage> list;
        block14: {
            String line;
            Perl5Matcher matcher = new Perl5Matcher();
            Perl5Compiler compiler = new Perl5Compiler();
            BufferedReader stdout = null;
            log.debug((Object)"Getting RCS version history");
            list = new ArrayList<WikiPage>();
            Pattern revpattern = compiler.compile(PATTERN_REVISION);
            Pattern datepattern = compiler.compile(PATTERN_DATE);
            Pattern userpattern = compiler.compile(PATTERN_AUTHOR);
            String cmd = TextUtil.replaceString(this.m_fullLogCommand, "%s", this.mangleName(page) + ".txt");
            Process process = Runtime.getRuntime().exec(cmd, null, new File(this.getPageDirectory()));
            stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            WikiPage info = null;
            while ((line = stdout.readLine()) != null) {
                MatchResult result;
                if (matcher.contains(line, revpattern)) {
                    info = new WikiPage(page);
                    result = matcher.getMatch();
                    int vernum = Integer.parseInt(result.group(1));
                    info.setVersion(vernum);
                    list.add(info);
                }
                if (matcher.contains(line, datepattern)) {
                    result = matcher.getMatch();
                    Date d = this.parseDate(result.group(1));
                    info.setLastModified(d);
                }
                if (!matcher.contains(line, userpattern)) continue;
                result = matcher.getMatch();
                info.setAuthor(TextUtil.urlDecodeUTF8(result.group(1)));
            }
            process.waitFor();
            Object var17_17 = null;
            try {
                if (stdout != null) {
                    stdout.close();
                }
                break block14;
            }
            catch (IOException e2) {}
            break block14;
            {
                catch (Exception e) {
                    log.error((Object)"RCS log failed", (Throwable)e);
                    Object var17_18 = null;
                    try {
                        if (stdout != null) {
                            stdout.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    if (stdout != null) {
                        stdout.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return list;
    }

    private Date parseDate(String str) {
        Date d = null;
        try {
            d = this.m_rcsdatefmt.parse(str);
            return d;
        }
        catch (ParseException pe) {
            try {
                d = this.m_rcsdatefmt_utc.parse(str);
                return d;
            }
            catch (ParseException parseException) {
                return d;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

